/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.hipo.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.hipo.data.HipoNodeType;
import org.jlab.hipo.io.HipoByteUtils;

public class HipoNode {
    ByteBuffer nodeBuffer = null;
    HipoNodeType nodeType = null;
    private int headerLength = 8;
    private int headerLengthDataOffset = 6;
    private int hederTypeDataOffset = 2;

    public HipoNode(int group, int item, HipoNodeType type, int length) {
        this.createNode(group, item, type, length);
    }

    public HipoNode(int group, int item, String value) {
        this.createNode(group, item, value);
    }

    public HipoNode(int group, int item, float[] value) {
        this.createNode(group, item, HipoNodeType.FLOAT, value.length);
        for (int i = 0; i < value.length; ++i) {
            this.setFloat(i, value[i]);
        }
    }

    public HipoNode(int group, int item, double[] value) {
        this.createNode(group, item, HipoNodeType.DOUBLE, value.length);
        for (int i = 0; i < value.length; ++i) {
            this.setDouble(i, value[i]);
        }
    }

    public HipoNode(byte[] buffer) {
        this.nodeBuffer = ByteBuffer.wrap(buffer);
        this.nodeBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.nodeType = this.getType();
    }

    public final void createNode(int group, int item, String value) {
        byte[] array = value.getBytes();
        this.createNode(group, item, HipoNodeType.STRING, array.length);
        System.arraycopy(array, 0, this.nodeBuffer.array(), 8, array.length);
    }

    public final void createNode(int group, int item, HipoNodeType type, int length) {
        int bytesPerEntry = type.getSize();
        int totalLength = this.headerLength + length * bytesPerEntry;
        byte[] array = new byte[totalLength];
        this.nodeBuffer = ByteBuffer.wrap(array);
        this.nodeBuffer.order(ByteOrder.LITTLE_ENDIAN);
        short groupID = HipoByteUtils.getShortFromInt(group);
        int lengthID = length * bytesPerEntry;
        byte itemID = HipoByteUtils.getByteFromInt(item);
        byte typeID = HipoByteUtils.getByteFromInt(type.getType());
        this.nodeBuffer.putShort(0, groupID);
        this.nodeBuffer.put(2, itemID);
        this.nodeBuffer.put(3, typeID);
        this.nodeBuffer.putInt(4, lengthID);
        this.nodeType = this.getType();
    }

    public int getDataSize() {
        HipoNodeType type = this.getType();
        int bufferLength = this.nodeBuffer.getInt(4);
        int ndata = bufferLength / type.getSize();
        return ndata;
    }

    public int getBufferSize() {
        return this.nodeBuffer.capacity();
    }

    public byte[] getBufferData() {
        return this.nodeBuffer.array();
    }

    public int getGroup() {
        short groupid = this.nodeBuffer.getShort(0);
        return groupid;
    }

    public int getItem() {
        byte itemid = this.nodeBuffer.get(2);
        return itemid;
    }

    public String getDataString() {
        int i;
        int ndata;
        StringBuilder str = new StringBuilder();
        HipoNodeType type = this.getType();
        if (type == HipoNodeType.BYTE) {
            ndata = this.getDataSize();
            for (i = 0; i < ndata; ++i) {
                str.append(String.format(" %8d", this.getByte(i)));
            }
        }
        if (type == HipoNodeType.SHORT) {
            ndata = this.getDataSize();
            for (i = 0; i < ndata; ++i) {
                str.append(String.format(" %8d", this.getShort(i)));
            }
        }
        if (type == HipoNodeType.INT) {
            ndata = this.getDataSize();
            for (i = 0; i < ndata; ++i) {
                str.append(String.format(" %8d", this.getInt(i)));
            }
        }
        if (type == HipoNodeType.LONG) {
            ndata = this.getDataSize();
            for (i = 0; i < ndata; ++i) {
                str.append(String.format(" %8d", this.getLong(i)));
            }
        }
        if (type == HipoNodeType.FLOAT) {
            ndata = this.getDataSize();
            for (i = 0; i < ndata; ++i) {
                str.append(String.format(" %8.3f", Float.valueOf(this.getFloat(i))));
            }
        }
        if (type == HipoNodeType.DOUBLE) {
            ndata = this.getDataSize();
            for (i = 0; i < ndata; ++i) {
                str.append(String.format(" %8.3f", this.getDouble(i)));
            }
        }
        if (type == HipoNodeType.VECTOR3F) {
            ndata = this.getDataSize();
            for (i = 0; i < ndata; ++i) {
                str.append(String.format("(%.3f,%.3f,%.3f) ", Float.valueOf(this.getVectorX(i)), Float.valueOf(this.getVectorY(i)), Float.valueOf(this.getVectorZ(i))));
            }
        }
        return str.toString();
    }

    public String getHeaderString() {
        StringBuilder str = new StringBuilder();
        short group = this.nodeBuffer.getShort(0);
        byte item = this.nodeBuffer.get(2);
        byte type = this.nodeBuffer.get(3);
        int len = this.nodeBuffer.getInt(4);
        str.append(String.format("(%8d,%4d) <%2d> [%6d]", group, item, type, len));
        return str.toString();
    }

    public final HipoNodeType getType() {
        byte type = this.nodeBuffer.get(3);
        return HipoNodeType.getType(type);
    }

    private int getOffset(int index) {
        HipoNodeType type = this.getType();
        return this.headerLength + type.getSize() * index;
    }

    public String getString() {
        if (this.nodeType != HipoNodeType.STRING) {
            this.printWrongTypeMessage(HipoNodeType.STRING);
            return "";
        }
        int offset = this.getOffset(0);
        int length = this.getDataSize();
        byte[] array = new byte[length];
        System.arraycopy(this.nodeBuffer.array(), offset, array, 0, length);
        return new String(array);
    }

    public byte getByte(int index) {
        if (this.nodeType != HipoNodeType.BYTE) {
            this.printWrongTypeMessage(HipoNodeType.BYTE);
            return 0;
        }
        int offset = this.getOffset(index);
        return this.nodeBuffer.get(offset);
    }

    public byte[] getByte() {
        byte[] array = new byte[this.getDataSize()];
        System.arraycopy(this.nodeBuffer.array(), this.headerLength, array, 0, array.length);
        return array;
    }

    public float[] getFloat() {
        if (this.nodeType != HipoNodeType.FLOAT) {
            this.printWrongTypeMessage(HipoNodeType.FLOAT);
            return new float[0];
        }
        float[] result = new float[this.getDataSize()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getFloat(i);
        }
        return result;
    }

    public double[] getDouble() {
        if (this.nodeType != HipoNodeType.DOUBLE) {
            this.printWrongTypeMessage(HipoNodeType.DOUBLE);
            return new double[0];
        }
        double[] result = new double[this.getDataSize()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getDouble(i);
        }
        return result;
    }

    public float getFloat(int index) {
        if (this.nodeType != HipoNodeType.FLOAT) {
            this.printWrongTypeMessage(HipoNodeType.FLOAT);
            return 0.0f;
        }
        int offset = this.getOffset(index);
        return this.nodeBuffer.getFloat(offset);
    }

    public float getVectorX(int index) {
        if (this.nodeType != HipoNodeType.VECTOR3F) {
            this.printWrongTypeMessage(HipoNodeType.VECTOR3F);
            return 0.0f;
        }
        int start = this.getOffset(0);
        int offset = start + index * this.nodeType.getSize();
        return this.nodeBuffer.getFloat(offset);
    }

    public float getVectorY(int index) {
        if (this.nodeType != HipoNodeType.VECTOR3F) {
            this.printWrongTypeMessage(HipoNodeType.VECTOR3F);
            return 0.0f;
        }
        int start = this.getOffset(0);
        int offset = start + (index * this.nodeType.getSize() + 4);
        return this.nodeBuffer.getFloat(offset);
    }

    public float getVectorZ(int index) {
        if (this.nodeType != HipoNodeType.VECTOR3F) {
            this.printWrongTypeMessage(HipoNodeType.VECTOR3F);
            return 0.0f;
        }
        int start = this.getOffset(0);
        int offset = start + (index * this.nodeType.getSize() + 8);
        return this.nodeBuffer.getFloat(offset);
    }

    public short getShort(int index) {
        if (this.nodeType != HipoNodeType.SHORT) {
            this.printWrongTypeMessage(HipoNodeType.SHORT);
            return 0;
        }
        int offset = this.getOffset(index);
        return this.nodeBuffer.getShort(offset);
    }

    public int getInt(int index) {
        if (this.nodeType != HipoNodeType.BYTE && this.nodeType != HipoNodeType.SHORT && this.nodeType != HipoNodeType.INT) {
            this.printWrongTypeMessage(HipoNodeType.INT);
            return 0;
        }
        int offset = this.getOffset(index);
        if (this.nodeType == HipoNodeType.INT) {
            return this.nodeBuffer.getInt(offset);
        }
        if (this.nodeType == HipoNodeType.SHORT) {
            return this.nodeBuffer.getShort(offset);
        }
        if (this.nodeType == HipoNodeType.BYTE) {
            return this.nodeBuffer.get(offset);
        }
        return 0;
    }

    public int[] getInt() {
        if (this.nodeType != HipoNodeType.INT) {
            this.printWrongTypeMessage(HipoNodeType.INT);
            return new int[0];
        }
        int[] array = new int[this.getDataSize()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getInt(i);
        }
        return array;
    }

    public short[] getShort() {
        if (this.nodeType != HipoNodeType.SHORT) {
            this.printWrongTypeMessage(HipoNodeType.SHORT);
            return new short[0];
        }
        short[] array = new short[this.getDataSize()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getShort(i);
        }
        return array;
    }

    public long getLong(int index) {
        if (this.nodeType != HipoNodeType.LONG) {
            this.printWrongTypeMessage(HipoNodeType.LONG);
            return 0L;
        }
        int offset = this.getOffset(index);
        return this.nodeBuffer.getLong(offset);
    }

    public double getDouble(int index) {
        if (this.nodeType != HipoNodeType.DOUBLE) {
            this.printWrongTypeMessage(HipoNodeType.DOUBLE);
            return 0.0;
        }
        int offset = this.getOffset(index);
        return this.nodeBuffer.getDouble(offset);
    }

    public void setByte(int index, byte value) {
        if (this.nodeType != HipoNodeType.BYTE) {
            this.printWrongTypeMessage(HipoNodeType.BYTE);
            return;
        }
        int offset = this.getOffset(index);
        this.nodeBuffer.put(offset, value);
    }

    public void setShort(int index, short value) {
        if (this.nodeType != HipoNodeType.SHORT) {
            this.printWrongTypeMessage(HipoNodeType.SHORT);
            return;
        }
        int offset = this.getOffset(index);
        this.nodeBuffer.putShort(offset, value);
    }

    public void setInt(int index, int value) {
        if (this.nodeType == HipoNodeType.INT) {
            int offset = this.getOffset(index);
            this.nodeBuffer.putInt(offset, value);
            return;
        }
        if (this.nodeType == HipoNodeType.SHORT) {
            if (value > Short.MIN_VALUE && value < Short.MAX_VALUE) {
                short short_value = (short)value;
                int offset = this.getOffset(index);
                this.nodeBuffer.putShort(offset, short_value);
                return;
            }
            System.out.println("[HipoNode::setInt] --> setting int value to short failed. Value is  out of range. " + value);
            return;
        }
        if (this.nodeType == HipoNodeType.BYTE) {
            if (value > -128 && value < 127) {
                byte byte_value = (byte)value;
                int offset = this.getOffset(index);
                this.nodeBuffer.putShort(offset, byte_value);
                return;
            }
            System.out.println("[HipoNode::setInt] --> setting int value to short failed. Value is  out of range. " + value);
            return;
        }
        this.printWrongTypeMessage(HipoNodeType.INT);
    }

    public void setLong(int index, long value) {
        if (this.nodeType != HipoNodeType.LONG) {
            this.printWrongTypeMessage(HipoNodeType.LONG);
            return;
        }
        int offset = this.getOffset(index);
        this.nodeBuffer.putLong(offset, value);
    }

    public void setFloat(int index, float value) {
        if (this.nodeType != HipoNodeType.FLOAT) {
            this.printWrongTypeMessage(HipoNodeType.FLOAT);
            return;
        }
        int offset = this.getOffset(index);
        this.nodeBuffer.putFloat(offset, value);
    }

    public void setDouble(int index, double value) {
        if (this.nodeType != HipoNodeType.DOUBLE) {
            this.printWrongTypeMessage(HipoNodeType.DOUBLE);
            return;
        }
        int offset = this.getOffset(index);
        this.nodeBuffer.putDouble(offset, value);
    }

    public void setVector(int index, float x, float y, float z) {
        this.setVectorX(index, x);
        this.setVectorY(index, y);
        this.setVectorZ(index, z);
    }

    public void setVectorX(int index, float value) {
        if (this.nodeType != HipoNodeType.VECTOR3F) {
            this.printWrongTypeMessage(HipoNodeType.VECTOR3F);
            return;
        }
        int start = this.getOffset(0);
        int offset = start + index * this.nodeType.getSize();
        this.nodeBuffer.putFloat(offset, value);
    }

    public void setVectorY(int index, float value) {
        if (this.nodeType != HipoNodeType.VECTOR3F) {
            this.printWrongTypeMessage(HipoNodeType.VECTOR3F);
            return;
        }
        int start = this.getOffset(0);
        int offset = start + (index * this.nodeType.getSize() + 4);
        this.nodeBuffer.putFloat(offset, value);
    }

    public void setVectorZ(int index, float value) {
        if (this.nodeType != HipoNodeType.VECTOR3F) {
            this.printWrongTypeMessage(HipoNodeType.VECTOR3F);
            return;
        }
        int start = this.getOffset(0);
        int offset = start + (index * this.nodeType.getSize() + 8);
        this.nodeBuffer.putFloat(offset, value);
    }

    private void printWrongTypeMessage(HipoNodeType type) {
        System.out.print("[hipo node] --> error : ");
        System.out.print(String.format("(%d,%d)", this.getGroup(), this.getItem()));
        System.out.println(" requested type=" + type.getName() + " has type=" + this.nodeType.getName());
    }

    public static void main(String[] args) {
        HipoNode node = new HipoNode(300, 1, HipoNodeType.SHORT, 20);
        for (int i = 0; i < 20; ++i) {
            int value = (i + 1) * 20;
            node.setInt(i, value);
        }
        System.out.println(node.getDataString());
        short[] buff = node.getShort();
        for (int i = 0; i < buff.length; ++i) {
            System.out.println(i + " = " + buff[i]);
        }
        HipoNode nodeB = new HipoNode(300, 1, HipoNodeType.BYTE, 20);
        for (int i = 0; i < 20; ++i) {
            int value = (i + 1) * 2;
            nodeB.setByte(i, (byte)value);
        }
        byte[] buffb = nodeB.getByte();
        for (int i = 0; i < buffb.length; ++i) {
            System.out.println(i + " = " + buffb[i]);
        }
    }
}

