/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jlab.groot.graphics.EmbeddedCanvas;
import org.jlab.groot.math.Func1D;

public class ParameterPanel
extends JPanel {
    private static final long serialVersionUID = -3175511650738525339L;
    int index;
    EmbeddedCanvas canvas;
    Func1D fitFunction;
    boolean modified = false;
    JPanel parameterPanel;
    ArrayList<JPanel> parameterPanels = new ArrayList();
    ArrayList<JCheckBox> parameterLimited = new ArrayList();
    ArrayList<JCheckBox> parameterFixed = new ArrayList();
    ArrayList<JTextField> parameterMin = new ArrayList();
    ArrayList<JTextField> parameterMax = new ArrayList();
    ArrayList<JLabel> parameterName = new ArrayList();
    ArrayList<JLabel> parameterValueLabel = new ArrayList();
    ArrayList<JTextField> parameterValue = new ArrayList();
    ArrayList<JSlider> parameterValueSliders = new ArrayList();
    ArrayList<Double> lowerLim = new ArrayList();
    ArrayList<Double> upperLim = new ArrayList();

    public ParameterPanel(EmbeddedCanvas canvas, int index, Func1D fitFunction2) {
        this.index = index;
        this.fitFunction = fitFunction2;
        this.canvas = canvas;
        this.setLayout(new GridLayout(fitFunction2.getNPars(), 1));
        this.initParameterPanel();
    }

    private void initParameterPanel() {
        ArrayList parameterLimitedCheckboxes = new ArrayList();
        if (this.upperLim.size() != this.fitFunction.getNPars()) {
            this.upperLim.clear();
        }
        if (this.lowerLim.size() != this.fitFunction.getNPars()) {
            this.lowerLim.clear();
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        for (int i = 0; i < this.fitFunction.getNPars(); ++i) {
            c.gridy = i;
            this.parameterLimited.add(new JCheckBox("Lim."));
            this.parameterLimited.get(i).setSelected(this.fitFunction.parameter(i).isLimited());
            this.parameterFixed.add(new JCheckBox("Fix"));
            if (this.lowerLim.size() != this.fitFunction.getNPars()) {
                this.lowerLim.add(new Double(this.fitFunction.parameter(i).value() / 10.0));
            }
            if (this.upperLim.size() != this.fitFunction.getNPars()) {
                this.upperLim.add(new Double(this.fitFunction.parameter(i).value() * 10.0));
            }
            this.parameterValue.add(new JTextField(String.format("%4.2f", this.fitFunction.parameter(i).value())));
            if (this.parameterLimited.get(i).isSelected()) {
                this.parameterMin.add(new JTextField(String.format("%4.2f", this.fitFunction.parameter(i).min())));
                this.parameterMax.add(new JTextField(String.format("%4.2f", this.fitFunction.parameter(i).max())));
            } else {
                this.parameterMin.add(new JTextField(String.format("%4.2f", this.lowerLim.get(i))));
                this.parameterMax.add(new JTextField(String.format("%4.2f", this.upperLim.get(i))));
            }
            this.parameterMin.get(i).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTextField textField = (JTextField)e.getSource();
                    for (int i = 0; i < ParameterPanel.this.parameterMin.size(); ++i) {
                        if (!textField.equals(ParameterPanel.this.parameterMin.get(i))) continue;
                        ParameterPanel.this.lowerLim.remove(i);
                        ParameterPanel.this.lowerLim.add(i, new Double(Double.parseDouble(ParameterPanel.this.parameterMin.get(i).getText())));
                        double xLow = Double.parseDouble(ParameterPanel.this.parameterMin.get(i).getText());
                        double xHigh = Double.parseDouble(ParameterPanel.this.parameterMax.get(i).getText());
                        double sliderMax = ParameterPanel.this.parameterValueSliders.get(i).getMaximum();
                        double sliderMin = ParameterPanel.this.parameterValueSliders.get(i).getMinimum();
                        ParameterPanel.this.parameterValueSliders.get(i).setValue((int)((ParameterPanel.this.fitFunction.parameter(i).value() - xLow) / ((xHigh - xLow) / (sliderMax - sliderMin))));
                    }
                }
            });
            this.parameterMax.get(i).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTextField textField = (JTextField)e.getSource();
                    for (int i = 0; i < ParameterPanel.this.parameterMax.size(); ++i) {
                        if (!textField.equals(ParameterPanel.this.parameterMax.get(i))) continue;
                        ParameterPanel.this.upperLim.remove(i);
                        ParameterPanel.this.upperLim.add(i, new Double(Double.parseDouble(ParameterPanel.this.parameterMax.get(i).getText())));
                        double xLow = Double.parseDouble(ParameterPanel.this.parameterMin.get(i).getText());
                        double xHigh = Double.parseDouble(ParameterPanel.this.parameterMax.get(i).getText());
                        double sliderMax = ParameterPanel.this.parameterValueSliders.get(i).getMaximum();
                        double sliderMin = ParameterPanel.this.parameterValueSliders.get(i).getMinimum();
                        ParameterPanel.this.parameterValueSliders.get(i).setValue((int)((ParameterPanel.this.fitFunction.parameter(i).value() - xLow) / ((xHigh - xLow) / (sliderMax - sliderMin))));
                    }
                }
            });
            this.parameterValueSliders.add(new JSlider());
            this.parameterValueSliders.get(i).setMaximum(10000);
            this.parameterValueSliders.get(i).setMinimum(0);
            double xLow = Double.parseDouble(this.parameterMin.get(i).getText());
            double xHigh = Double.parseDouble(this.parameterMax.get(i).getText());
            double sliderMax = this.parameterValueSliders.get(i).getMaximum();
            double sliderMin = this.parameterValueSliders.get(i).getMinimum();
            this.parameterValueSliders.get(i).setValue((int)((this.fitFunction.parameter(i).value() - xLow) / ((xHigh - xLow) / (sliderMax - sliderMin))));
            System.out.println("Initialize Slider:" + (int)((this.fitFunction.parameter(i).value() - xLow) / ((xHigh - xLow) / (sliderMax - sliderMin))));
            this.parameterValueLabel.add(new JLabel("Value:"));
            this.parameterName.add(new JLabel());
            this.parameterName.get(i).setText(this.fitFunction.parameter(i).name());
            this.parameterValueSliders.get(i).addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ParameterPanel.this.modified = true;
                    JSlider slider = (JSlider)e.getSource();
                    for (int i = 0; i < ParameterPanel.this.parameterValueSliders.size(); ++i) {
                        if (!slider.equals(ParameterPanel.this.parameterValueSliders.get(i))) continue;
                        double xLow = Double.parseDouble(ParameterPanel.this.parameterMin.get(i).getText());
                        double xHigh = Double.parseDouble(ParameterPanel.this.parameterMax.get(i).getText());
                        double sliderMax = ParameterPanel.this.parameterValueSliders.get(i).getMaximum();
                        double sliderMin = ParameterPanel.this.parameterValueSliders.get(i).getMinimum();
                        double parameterValueDouble = (double)slider.getValue() * (xHigh - xLow) / (sliderMax - sliderMin) + xLow;
                        ParameterPanel.this.fitFunction.setParameter(i, parameterValueDouble);
                        System.out.println("ParameterValue:" + parameterValueDouble);
                        ParameterPanel.this.parameterValue.get(i).setText(String.format("%2.2f", parameterValueDouble));
                        if (ParameterPanel.this.parameterFixed.get(i).isSelected()) {
                            System.out.println("Nooooooooooo, I'm fixed");
                        }
                        ParameterPanel.this.updateFitFunction();
                    }
                    double temp = slider.getValue();
                    System.out.println("Changing slider Value:" + temp);
                }
            });
            this.add((Component)this.parameterName.get(i), c);
            this.add((Component)this.parameterLimited.get(i), c);
            this.add((Component)this.parameterFixed.get(i), c);
            this.add((Component)this.parameterMin.get(i), c);
            this.add((Component)this.parameterValueSliders.get(i), c);
            this.add((Component)this.parameterMax.get(i), c);
            this.add((Component)this.parameterValueLabel.get(i), c);
            this.add((Component)this.parameterValue.get(i), c);
        }
    }

    public void updateFitFunction() {
        this.canvas.cd(this.index);
        this.canvas.update();
    }

    public void updateNewFunction(Func1D fitFunction2) {
        this.fitFunction = fitFunction2;
        int nComponents = this.getComponentCount();
        for (int i = nComponents - 1; i >= 0; --i) {
            this.remove(i);
        }
        this.parameterLimited.clear();
        this.parameterFixed.clear();
        this.parameterMin.clear();
        this.parameterMax.clear();
        this.parameterName.clear();
        this.parameterValue.clear();
        this.parameterValueSliders.clear();
        this.initParameterPanel();
        this.revalidate();
        this.repaint();
    }

    public boolean modified() {
        return this.modified;
    }
}

