/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.ui;

import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class LatexTextTools {
    private static Map<String, String> greekTranslation = LatexTextTools.getTable();

    public static Map<String, String> getTable() {
        LinkedHashMap<String, String> table = new LinkedHashMap<String, String>();
        table.put("#alpha", "\u03b1");
        table.put("#beta", "\u03b2");
        table.put("#gamma", "\u03b3");
        table.put("#delta", "\u03b4");
        table.put("#Delta", "\u0394");
        table.put("#eps", "\u03b5");
        table.put("#zeta", "\u03b6");
        table.put("#eta", "\u03b7");
        table.put("#kappa", "\u03ba");
        table.put("#lamda", "\u03bb");
        table.put("#mu", "\u03bc");
        table.put("#nu", "\u03bd");
        table.put("#xi", "\u03be");
        table.put("#rho", "\u03c1");
        table.put("#sigma", "\u03c3");
        table.put("#tau", "\u03c4");
        table.put("#phi", "\u03c6");
        table.put("#chi", "\u03c7");
        table.put("#psi", "\u03c8");
        table.put("#theta", "\u03b8");
        table.put("#omega", "\u03c9");
        table.put("#pi", "\u03c0");
        table.put("#Theta", "\u0398");
        table.put("#degree", "\u00b0");
        table.put("#rarrow", "\u2192");
        table.put("#larrow", "\u2190");
        table.put("#uarrow", "\u2191");
        table.put("#darrow", "\u2193");
        table.put("#overline", "\u0305");
        table.put("#bar", "\u0304");
        return table;
    }

    public static String convertUnicode(String original) {
        if (!original.contains("#") && !original.contains("^")) {
            return original;
        }
        String newString = original;
        for (Map.Entry<String, String> entry : greekTranslation.entrySet()) {
            newString = newString.replaceAll(entry.getKey(), entry.getValue());
        }
        return newString;
    }

    public static AttributedString converSubScript(String line) {
        ArrayList<Integer> supindex = new ArrayList<Integer>();
        ArrayList subindex = new ArrayList();
        int index = line.indexOf("^");
        String newString = line;
        while (index >= 0) {
            supindex.add(index);
            newString = newString.substring(0, index) + newString.substring(index + 1);
            index = newString.indexOf("_");
        }
        AttributedString string = new AttributedString(newString);
        for (Integer indx : supindex) {
            if (indx <= 0) continue;
            string.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, indx, indx + 1);
        }
        return string;
    }

    public static AttributedString converSuperScript(String line) {
        ArrayList<Integer> supindex = new ArrayList<Integer>();
        int index = line.indexOf("^");
        String newString = line;
        while (index >= 0) {
            supindex.add(index);
            newString = newString.substring(0, index) + newString.substring(index + 1);
            index = newString.indexOf("^");
        }
        AttributedString string = new AttributedString(newString);
        for (Integer indx : supindex) {
            if (indx <= 0) continue;
            string.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, indx, indx + 1);
        }
        return string;
    }

    public static void main(String[] args) {
        String text = "Value #theta (#alpha + #beta) = #gamma^2 = 5.0  #pi^3 = 3.14^5";
        String latex = LatexTextTools.convertUnicode(text);
        System.out.println(latex);
        AttributedString str = LatexTextTools.converSuperScript(latex);
    }
}

