/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.ui;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.jlab.groot.ui.LatexText;

public class GraphicsAxisLabels {
    private List<LatexText> axisLabels = new ArrayList<LatexText>();
    private List<Double> axisTicks = new ArrayList<Double>();
    private String axisFontName = "Avenir";
    private Integer axisFontSize = 12;

    public List<Double> getTicks() {
        return this.axisTicks;
    }

    public List<LatexText> getLabels() {
        return this.axisLabels;
    }

    public void update(double[] numbers, String[] labels) {
        if (numbers.length != labels.length) {
            System.out.println("[graphicsAxisLabel] ---> error : number of ticks do not match labels.");
            return;
        }
        this.axisLabels.clear();
        this.axisTicks.clear();
        for (int loop = 0; loop < numbers.length; ++loop) {
            this.axisTicks.add(numbers[loop]);
            this.axisLabels.add(new LatexText(labels[loop]));
        }
    }

    public GraphicsAxisLabels setFontSize(int size) {
        this.axisFontSize = size;
        return this;
    }

    public GraphicsAxisLabels setFontName(String name) {
        for (LatexText t : this.axisLabels) {
            t.setFont(name);
        }
        return this;
    }

    public void update(double[] numbers) {
        this.axisLabels.clear();
        this.axisTicks.clear();
        for (int loop = 0; loop < numbers.length; ++loop) {
            this.axisTicks.add(numbers[loop]);
        }
        int significantFigures = this.getSignificantFigures(this.axisTicks);
        if (significantFigures < 0) {
            significantFigures = 0;
        }
        for (int loop = 0; loop < this.axisTicks.size(); ++loop) {
            this.axisLabels.add(LatexText.createFromDouble(this.axisTicks.get(loop), significantFigures));
        }
    }

    public void updateLog(List<Double> numbers) {
        int loop;
        this.axisLabels.clear();
        this.axisTicks.clear();
        for (loop = 0; loop < numbers.size(); ++loop) {
            this.axisTicks.add(numbers.get(loop));
        }
        for (loop = 0; loop < this.axisTicks.size(); ++loop) {
            int order = (int)Math.log10(this.axisTicks.get(loop));
            if (order == 0) {
                this.axisLabels.add(new LatexText("10"));
                continue;
            }
            this.axisLabels.add(new LatexText(String.format("10^%d", order)));
        }
    }

    public void update(List<Double> numbers) {
        this.axisLabels.clear();
        this.axisTicks.clear();
        for (int loop = 0; loop < numbers.size(); ++loop) {
            this.axisTicks.add(numbers.get(loop));
        }
        int significantFigures = this.getSignificantFigures(this.axisTicks);
        if (significantFigures < 0) {
            significantFigures = -1;
        }
        for (int loop = 0; loop < this.axisTicks.size(); ++loop) {
            LatexText text = LatexText.createFromDouble(this.axisTicks.get(loop), significantFigures + 1);
            text.setFontSize(this.axisFontSize);
            this.axisLabels.add(text);
        }
    }

    public int getSignificantFigures(List<Double> array) {
        if (array.size() < 2) {
            return 0;
        }
        double min = array.get(0);
        double max = array.get(array.size() - 1);
        double difference = max - min;
        int placeOfDifference = (int)Math.floor(Math.log(difference) / Math.log(10.0));
        return -placeOfDifference;
    }

    public int getAxisLabelsWidth(Graphics2D g2d) {
        int length = 0;
        for (LatexText t : this.axisLabels) {
            length = (int)((double)length + t.getBounds(g2d).getWidth());
        }
        return length;
    }

    public int getAxisLabelsHeight(Graphics2D g2d) {
        int length = 0;
        for (LatexText t : this.axisLabels) {
            length = (int)((double)length + t.getBounds(g2d).getHeight());
        }
        return length;
    }

    public int getAxisMaxWidth(Graphics2D g2d) {
        int maxLength = 0;
        for (LatexText t : this.axisLabels) {
            int len = (int)t.getBounds(g2d).getWidth();
            if (len <= maxLength) continue;
            maxLength = len;
        }
        return maxLength;
    }

    public int getAxisMaxHeight(Graphics2D g2d) {
        int maxLength = 0;
        for (LatexText t : this.axisLabels) {
            int len = (int)t.getBounds(g2d).getHeight();
            if (len <= maxLength) continue;
            maxLength = len;
        }
        return maxLength;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Ticks : ( ");
        for (LatexText t : this.axisLabels) {
            str.append(t.getTextString());
            str.append(" , ");
        }
        str.append(" )");
        return str.toString();
    }
}

