/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.ui;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jlab.groot.base.AttributeType;
import org.jlab.groot.base.Attributes;
import org.jlab.groot.base.ColorPalette;
import org.jlab.groot.base.FontProperties;
import org.jlab.groot.base.PadMargins;
import org.jlab.groot.base.TStyle;
import org.jlab.groot.math.Dimension2D;
import org.jlab.groot.ui.GraphicsAxis;
import org.jlab.groot.ui.LatexText;

public class GraphicsAxisFrame {
    List<GraphicsAxis> graphicsAxis = new ArrayList<GraphicsAxis>();
    FontProperties frameTitleFont = new FontProperties();
    LatexText graphicsFrameTitle = new LatexText("");
    Dimension2D frameDimensions = new Dimension2D();
    PadMargins axisFrameMargins = new PadMargins();
    ColorPalette zAxisPalette = new ColorPalette();
    private Attributes frameAttributes = new Attributes();

    public GraphicsAxisFrame() {
        this.setAxis(3);
        this.initAttributes();
    }

    public GraphicsAxisFrame(int naxis) {
        this.setAxis(naxis);
        this.initAttributes();
    }

    public final void setAxis(int naxis) {
        this.graphicsAxis.clear();
        for (int i = 0; i < naxis; ++i) {
            this.graphicsAxis.add(new GraphicsAxis());
        }
    }

    public Attributes getAttributes() {
        return this.frameAttributes;
    }

    private void initAttributes() {
        this.frameAttributes.addString(AttributeType.STRING_TITLE, "");
        this.frameAttributes.addString(AttributeType.STRING_TITLE_X, "");
        this.frameAttributes.addString(AttributeType.STRING_TITLE_Y, "");
        this.frameAttributes.add(AttributeType.AXIS_LINE_COLOR, 1);
        this.frameAttributes.add(AttributeType.AXIS_LINE_WIDTH, 1);
        this.frameAttributes.add(AttributeType.AXIS_LINE_STYLE, 1);
        this.frameAttributes.add(AttributeType.FILL_COLOR, -11);
        this.frameAttributes.add(AttributeType.AXIS_TICKS_SIZE, 15);
        this.frameAttributes.add(AttributeType.AXIS_TICKS_STYLE, 0);
        this.frameAttributes.add(AttributeType.AXIS_LABEL_OFFSET, 4);
        this.frameAttributes.add(AttributeType.AXIS_TITLE_OFFSET, 5);
        this.frameAttributes.add(AttributeType.AXIS_FRAME_STYLE, 1);
        this.frameAttributes.add(AttributeType.AXIS_GRID_X, 1);
        this.frameAttributes.add(AttributeType.AXIS_GRID_Y, 1);
        this.frameAttributes.add(AttributeType.AXIS_DRAW_X, 1);
        this.frameAttributes.add(AttributeType.AXIS_DRAW_Y, 1);
        this.frameAttributes.add(AttributeType.AXIS_DRAW_Z, 0);
        this.frameAttributes.copyValues(TStyle.getStyle());
    }

    public GraphicsAxis getAxis(int index) {
        return this.graphicsAxis.get(index);
    }

    public double getPointX(double value) {
        return this.graphicsAxis.get(0).getAxisPosition(value);
    }

    public double getPointY(double value) {
        double frac = this.graphicsAxis.get(1).getRange().getFraction(value);
        int xticks_y = (int)(this.frameDimensions.getDimension(1).getMax() - (this.graphicsAxis.get(1).getDimension().getMin() - this.frameDimensions.getDimension(1).getMin()));
        double length = this.graphicsAxis.get(1).getDimension().getLength();
        return (double)xticks_y - frac * length;
    }

    public Point2D getPoint(float x, float y) {
        return new Point2D.Double(this.graphicsAxis.get(0).getAxisPosition(x), this.graphicsAxis.get(1).getAxisPosition(y));
    }

    public Dimension2D getDimension() {
        return this.frameDimensions;
    }

    public void showAxis() {
        for (int i = 0; i < this.graphicsAxis.size(); ++i) {
            System.out.print(String.format("%3d : ", i));
            System.out.println(this.graphicsAxis.get(i));
        }
    }

    public void draw(Graphics2D g2d, Dimension2D frame) {
        this.update(g2d);
        int tickSize = this.frameAttributes.get(AttributeType.AXIS_TICKS_SIZE);
        int axisLabelOffset = this.frameAttributes.get(AttributeType.AXIS_LABEL_OFFSET);
        int axisColor = this.frameAttributes.get(AttributeType.AXIS_LINE_COLOR);
        g2d.setColor(this.zAxisPalette.getColor3D(axisColor));
        g2d.setStroke(new BasicStroke(this.frameAttributes.get(AttributeType.AXIS_LINE_WIDTH)));
        int xticks_y = (int)(this.frameDimensions.getDimension(1).getMax() - (this.graphicsAxis.get(1).getDimension().getMin() - this.frameDimensions.getDimension(1).getMin()));
        g2d.drawLine((int)this.graphicsAxis.get(0).getDimension().getMin(), xticks_y, (int)this.graphicsAxis.get(0).getDimension().getMax(), xticks_y);
        List<Double> xTicks = this.graphicsAxis.get(0).getAxisTicks();
        List<LatexText> xTexts = this.graphicsAxis.get(0).getAxisLabels();
        for (int ix = 0; ix < xTicks.size(); ++ix) {
            int xtick = (int)this.graphicsAxis.get(0).getAxisPosition(xTicks.get(ix));
            g2d.drawLine(xtick, xticks_y, xtick, xticks_y - tickSize);
            xTexts.get(ix).drawString(g2d, xtick, xticks_y + axisLabelOffset, 1, 0);
        }
        List<Double> xMinorTicks = this.graphicsAxis.get(0).getAxisMinorTicks();
        for (int ix = 0; ix < xMinorTicks.size(); ++ix) {
            int xtick = (int)this.graphicsAxis.get(0).getAxisPosition(xMinorTicks.get(ix));
            g2d.drawLine(xtick, xticks_y, xtick, xticks_y - (int)(0.5 * (double)tickSize));
        }
        int yticks_x = (int)this.graphicsAxis.get(0).getDimension().getMin();
        g2d.drawLine(yticks_x, (int)(frame.getDimension(1).getLength() - this.graphicsAxis.get(1).getDimension().getMin()), yticks_x, (int)(frame.getDimension(1).getLength() - this.graphicsAxis.get(1).getDimension().getMax()));
        List<Double> yTicks = this.graphicsAxis.get(1).getAxisTicks();
        List<LatexText> yTexts = this.graphicsAxis.get(1).getAxisLabels();
        for (int iy = 0; iy < yTicks.size(); ++iy) {
            int ytick = (int)this.getPointY(yTicks.get(iy));
            g2d.drawLine(yticks_x, ytick, yticks_x + tickSize, ytick);
            yTexts.get(iy).drawString(g2d, yticks_x - axisLabelOffset, ytick, 2, 1);
        }
        List<Double> yMinorTicks = this.graphicsAxis.get(1).getAxisMinorTicks();
        for (int iy = 0; iy < yMinorTicks.size(); ++iy) {
            int ytick = (int)this.getPointY(yMinorTicks.get(iy));
            g2d.drawLine(yticks_x, ytick, yticks_x + (int)(0.5 * (double)tickSize), ytick);
        }
        if (this.frameAttributes.get(AttributeType.AXIS_FRAME_STYLE) > 0) {
            g2d.drawRect(yticks_x, (int)((double)xticks_y - this.graphicsAxis.get(1).getDimension().getLength()), (int)this.graphicsAxis.get(0).getDimension().getLength(), (int)this.graphicsAxis.get(1).getDimension().getLength());
        }
        if (this.frameAttributes.get(AttributeType.AXIS_DRAW_Z) > 0) {
            int x = (int)this.graphicsAxis.get(0).getDimension().getMax();
            int y = (int)(this.frameDimensions.getDimension(1).getMin() + (double)this.axisFrameMargins.getTopMargin());
            int height = (int)this.graphicsAxis.get(1).getDimension().getLength();
            this.zAxisPalette.draw(g2d, x + 4, y, 15, height, 0.0, 400.0, this.getAxis(2).getLog());
        }
    }

    public void update(Graphics2D g2d) {
        this.graphicsAxis.get(0).setDimension((int)this.frameDimensions.getDimension(0).getMin(), (int)this.frameDimensions.getDimension(0).getMax());
        this.graphicsAxis.get(1).setDimension((int)this.frameDimensions.getDimension(1).getMin(), (int)this.frameDimensions.getDimension(1).getMax());
        this.graphicsAxis.get(0).setAxisDivisions(10);
        this.graphicsAxis.get(1).setAxisDivisions(10);
        int yStringWidth = this.graphicsAxis.get(1).getSize(g2d, true);
        int xStringHeight = this.graphicsAxis.get(0).getSize(g2d, false);
        double fractionX = this.graphicsAxis.get(0).getLabelFraction(g2d, false);
        int ndivisionsX = this.graphicsAxis.get(0).getAxisDivisions();
        while (fractionX > 0.6 && ndivisionsX > 2) {
            this.graphicsAxis.get(0).setAxisDivisions(--ndivisionsX);
            fractionX = this.graphicsAxis.get(0).getLabelFraction(g2d, false);
        }
        double fractionY = this.graphicsAxis.get(1).getLabelFraction(g2d, true);
        int ndivisionsY = 10;
        while (fractionY > 0.8 && ndivisionsY > 2) {
            this.graphicsAxis.get(1).setAxisDivisions(--ndivisionsY);
            fractionY = this.graphicsAxis.get(1).getLabelFraction(g2d, true);
        }
        this.axisFrameMargins.setLeftMargin(yStringWidth + 5);
        this.axisFrameMargins.setRightMargin(15);
        this.axisFrameMargins.setBottomMargin(xStringHeight + 5);
        this.axisFrameMargins.setTopMargin(10);
        if (this.frameAttributes.get(AttributeType.AXIS_DRAW_Z) > 0) {
            int zAxisWidth = this.zAxisPalette.getAxisWidth(g2d, 0, 0, 15, (int)this.frameDimensions.getDimension(1).getLength(), 0.0, 400.0, this.getAxis(2).getLog());
            this.axisFrameMargins.setRightMargin(15 + zAxisWidth);
        }
        this.graphicsAxis.get(1).setDimension((int)this.frameDimensions.getDimension(1).getMin() + this.axisFrameMargins.getBottomMargin(), (int)this.frameDimensions.getDimension(1).getMax() - this.axisFrameMargins.getTopMargin());
        this.graphicsAxis.get(0).setDimension((int)this.frameDimensions.getDimension(0).getMin() + this.axisFrameMargins.getLeftMargin(), (int)this.frameDimensions.getDimension(0).getMax() - this.axisFrameMargins.getRightMargin());
    }

    public static void main(String[] args) {
        GraphicsAxisFrame frame = new GraphicsAxisFrame();
        frame.showAxis();
    }
}

