/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jlab.groot.data.H1F;
import org.jlab.groot.data.IDataSet;
import org.jlab.groot.fitter.DataFitter;
import org.jlab.groot.graphics.EmbeddedCanvas;
import org.jlab.groot.graphics.EmbeddedPad;
import org.jlab.groot.graphics.IDataSetPlotter;
import org.jlab.groot.math.F1D;
import org.jlab.groot.math.Func1D;
import org.jlab.groot.ui.ParameterPanel;
import org.jlab.groot.ui.RangeSlider;

public class FitPanel
extends JPanel {
    EmbeddedCanvas canvas;
    int index;
    ArrayList<IDataSet> datasets = new ArrayList();
    ArrayList<String> dataSetNames = new ArrayList();
    IDataSet currentDataset = null;
    ArrayList<F1D> fitAllFitFunctions = new ArrayList();
    JComboBox paramEstimationMethods;
    String[] predefFunctions = new String[]{"gaus", "gaus+p0", "gaus+p1", "gaus+p2", "gaus+p3", "p0", "p1", "p2", "p3", "exp", "a+bcos", "a+bcos+ccos2", "amdahl"};
    String[] predefFunctionsF1D = new String[]{"[amp]*gaus(x,[mean],[sigma])", "[amp]*gaus(x,[mean],[sigma])+[p0]", "[amp]*gaus(x,[mean],[sigma])+[p0]+x*[p1]", "[amp]*gaus(x,[mean],[sigma])+[p0]+x*[p1]+x*x*[p2]", "[amp]*gaus(x,[mean],[sigma])+[p0]+x*[p1]+x*x*[p2]", "[p0]", "[p0]+[p1]*x", "[p0]+[p1]*x+[p2]*x*x", "[p0]+[p1]*x+[p2]*x*x+[p3]*x*x", "[a]*exp(x,[b])", "[a]+[b]*cos(x*[c])", "[a]+[b]*cos(x*[d])+[c]*cos(2*x*[e])", "1/((1-[p])+[p]/x)"};
    boolean predef = true;
    JComboBox predefinedFunctionsSelector;
    JPanel fitSettings;
    JPanel fitSwapSettings;
    JPanel fitFunctionPanel;
    JPanel lowerWindow;
    Func1D fitFunction;
    boolean parameterPanelSwapped = false;
    boolean fitSettingsSwapped = false;
    JPanel blankPanel = new JPanel();
    ArrayList<JCheckBox> optionCheckBoxes;
    double xMin = 0.0;
    double xMax = 100.0;
    String options = "";
    int xSliderMin = 0;
    int xSliderMax = 1000000;
    double currentRangeMin = 0.0;
    double currentRangeMax = 100.0;
    ParameterPanel parameterPanel;

    public FitPanel(EmbeddedCanvas canvas, int index) {
        this.canvas = canvas;
        this.index = index;
        this.fitFunction = new F1D("f1", this.predefFunctionsF1D[0], this.xMin, this.xMax);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        int gridy = 0;
        c.gridy = gridy++;
        this.add((Component)this.initFitFunction(), c);
        c.gridy = gridy++;
        this.add((Component)this.initFitSettings(), c);
        c.gridy = gridy++;
        this.add((Component)this.initRangeSelector(), c);
        if (this.currentDataset != null && this.currentDataset instanceof H1F) {
            this.paramEstimationMethods.setSelectedIndex(1);
        }
    }

    JTabbedPane initFitSettings() {
        JPanel fitMethod = new JPanel(new FlowLayout());
        String[] labs = new String[]{"Chi-square", "Chi-square (Neyman)", "Chi-square (Pearson)", "Chi-square (All weights=1)", "Binned Extended-MLE"};
        this.paramEstimationMethods = new JComboBox<String>(labs);
        this.paramEstimationMethods.setSelectedIndex(0);
        fitMethod.add(new JLabel("Method:"));
        fitMethod.add(this.paramEstimationMethods);
        JPanel fitOptions = new JPanel(new GridLayout(1, 2));
        String[] options = new String[]{"Draw Stats", "Quiet"};
        this.optionCheckBoxes = new ArrayList();
        for (int i = 0; i < options.length; ++i) {
            this.optionCheckBoxes.add(new JCheckBox(options[i]));
            fitOptions.add(this.optionCheckBoxes.get(i));
        }
        final JTabbedPane tabbedPane = new JTabbedPane();
        this.fitSettings = new JPanel(new GridLayout(2, 1));
        this.fitSettings.add(fitMethod);
        this.fitSettings.add(fitOptions);
        this.parameterPanel = new ParameterPanel(this.canvas, this.index, this.fitFunction);
        tabbedPane.add("Minimizer Settings", this.fitSettings);
        tabbedPane.add("Parameter Settings", this.blankPanel);
        tabbedPane.setBorder(new TitledBorder("Minimizer Settings"));
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (tabbedPane.getSelectedIndex() == 0) {
                    tabbedPane.setComponentAt(1, FitPanel.this.blankPanel);
                }
                if (tabbedPane.getSelectedIndex() == 1) {
                    tabbedPane.setComponentAt(1, FitPanel.this.parameterPanel);
                }
                JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(tabbedPane);
                topFrame.pack();
            }
        });
        return tabbedPane;
    }

    private JPanel initFitFunction() {
        this.fitFunctionPanel = new JPanel(new GridLayout(2, 1));
        this.fitFunctionPanel.setBorder(new TitledBorder("Function Settings"));
        this.xMin = this.canvas.getPad(this.index).getAxisX().getMin();
        this.xMax = this.canvas.getPad(this.index).getAxisX().getMax();
        for (IDataSetPlotter plotter : this.canvas.getPad(this.index).getDatasetPlotters()) {
            this.datasets.add(plotter.getDataSet());
            this.dataSetNames.add(plotter.getDataSet().getName());
        }
        final JComboBox<Object> dataSetBox = new JComboBox<Object>(this.dataSetNames.toArray());
        dataSetBox.setSelectedIndex(0);
        this.currentDataset = this.datasets.get(0);
        dataSetBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FitPanel.this.currentDataset = FitPanel.this.datasets.get(dataSetBox.getSelectedIndex());
            }
        });
        this.predefinedFunctionsSelector = new JComboBox<String>(this.predefFunctions);
        this.predefinedFunctionsSelector.setSelectedIndex(0);
        this.parameterPanel = new ParameterPanel(this.canvas, this.index, this.fitFunction);
        this.predefinedFunctionsSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                boolean functionSetup = false;
                for (i = 0; i < FitPanel.this.predefFunctions.length; ++i) {
                    if (!FitPanel.this.predefFunctions[FitPanel.this.predefinedFunctionsSelector.getSelectedIndex()].equals(FitPanel.this.predefFunctions[i])) continue;
                    FitPanel.this.fitFunction = new F1D("f1", FitPanel.this.predefFunctionsF1D[FitPanel.this.predefinedFunctionsSelector.getSelectedIndex()], FitPanel.this.currentRangeMin, FitPanel.this.currentRangeMax);
                    functionSetup = true;
                    FitPanel.this.predef = true;
                }
                if (FitPanel.this.predef) {
                    for (i = 0; i < FitPanel.this.fitFunction.getNPars(); ++i) {
                        if (i == 0) {
                            FitPanel.this.fitFunction.setParameter(0, FitPanel.this.getMaxYIDataSet(FitPanel.this.currentDataset, FitPanel.this.currentRangeMin, FitPanel.this.currentRangeMax));
                        } else if (i == 1) {
                            FitPanel.this.fitFunction.setParameter(1, FitPanel.this.getMeanIDataSet(FitPanel.this.currentDataset, FitPanel.this.currentRangeMin, FitPanel.this.currentRangeMax));
                        } else if (i == 2) {
                            FitPanel.this.fitFunction.setParameter(2, FitPanel.this.getRMSIDataSet(FitPanel.this.currentDataset, FitPanel.this.currentRangeMin, FitPanel.this.currentRangeMax));
                            if (FitPanel.this.predefinedFunctionsSelector.getSelectedIndex() < 5) {
                                FitPanel.this.fitFunction.setParLimits(2, 0.0, Double.MAX_VALUE);
                            }
                        } else if (i == 3) {
                            FitPanel.this.fitFunction.setParameter(3, FitPanel.this.getAverageHeightIDataSet(FitPanel.this.currentDataset, FitPanel.this.currentRangeMin, FitPanel.this.currentRangeMax));
                        } else if (i > 3) {
                            FitPanel.this.fitFunction.setParameter(i, 1.0);
                        }
                        System.out.println("Paramter " + i + " =" + FitPanel.this.fitFunction.getParameter(i));
                    }
                }
                FitPanel.this.parameterPanel.updateNewFunction(FitPanel.this.fitFunction);
                JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(FitPanel.this.predefinedFunctionsSelector);
                topFrame.pack();
            }
        });
        JLabel labelForFunction = new JLabel("Function:");
        JLabel dataSetLabel = new JLabel("Select Dataset:");
        this.fitFunctionPanel.add(dataSetLabel);
        this.fitFunctionPanel.add(dataSetBox);
        this.fitFunctionPanel.add(labelForFunction);
        this.fitFunctionPanel.add(this.predefinedFunctionsSelector);
        return this.fitFunctionPanel;
    }

    private JPanel initRangeSelector() {
        this.lowerWindow = new JPanel(new GridLayout(2, 1));
        JPanel rangeSelector = new JPanel();
        JLabel xLabel = new JLabel("X:");
        RangeSlider slider = new RangeSlider();
        slider.setMinimum(this.xSliderMin);
        slider.setMaximum(this.xSliderMax);
        slider.setValue(this.xSliderMin);
        slider.setUpperValue(this.xSliderMax);
        this.currentRangeMin = (double)slider.getValue() * (this.xMax - this.xMin) / (double)(this.xSliderMax - this.xSliderMin) + this.xMin;
        this.currentRangeMax = (double)slider.getUpperValue() * (this.xMax - this.xMin) / (double)(this.xSliderMax - this.xSliderMin) + this.xMin;
        final JLabel rangeSliderValue1 = new JLabel("" + String.format("%4.2f", this.currentRangeMin));
        final JLabel rangeSliderValue2 = new JLabel("" + String.format("%4.2f", this.currentRangeMax));
        this.fitFunction.setRange(this.currentRangeMin, this.currentRangeMax);
        rangeSelector.add(xLabel);
        rangeSelector.add(rangeSliderValue1);
        rangeSelector.add(slider);
        rangeSelector.add(rangeSliderValue2);
        this.lowerWindow.add(rangeSelector);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RangeSlider slider = (RangeSlider)e.getSource();
                FitPanel.this.currentRangeMin = (double)slider.getValue() * (FitPanel.this.xMax - FitPanel.this.xMin) / (double)(FitPanel.this.xSliderMax - FitPanel.this.xSliderMin) + FitPanel.this.xMin;
                FitPanel.this.currentRangeMax = (double)slider.getUpperValue() * (FitPanel.this.xMax - FitPanel.this.xMin) / (double)(FitPanel.this.xSliderMax - FitPanel.this.xSliderMin) + FitPanel.this.xMin;
                rangeSliderValue1.setText(String.valueOf("" + String.format("%4.2f", FitPanel.this.currentRangeMin)));
                rangeSliderValue2.setText(String.valueOf("" + String.format("%4.2f", FitPanel.this.currentRangeMax)));
            }
        });
        JButton fit = new JButton("Fit");
        fit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                int method = FitPanel.this.paramEstimationMethods.getSelectedIndex();
                if (method == 0) {
                    FitPanel.this.options = "ER";
                } else if (method == 1) {
                    FitPanel.this.options = "NR";
                } else if (method == 2) {
                    FitPanel.this.options = "PR";
                } else if (method == 3) {
                    FitPanel.this.options = "R";
                } else if (method == 4) {
                    FitPanel.this.options = "LR";
                }
                String drawOption = "";
                for (i = 0; i < FitPanel.this.optionCheckBoxes.size(); ++i) {
                    if (FitPanel.this.optionCheckBoxes.get(0).isSelected()) {
                        drawOption = "S";
                    }
                    if (!FitPanel.this.optionCheckBoxes.get(1).isSelected()) continue;
                    FitPanel.this.options = FitPanel.this.options + "Q";
                }
                FitPanel.this.fitFunction.setRange(FitPanel.this.currentRangeMin, FitPanel.this.currentRangeMax);
                if (FitPanel.this.predef && !FitPanel.this.parameterPanel.modified()) {
                    for (i = 0; i < FitPanel.this.fitFunction.getNPars(); ++i) {
                        if (i == 0) {
                            FitPanel.this.fitFunction.setParameter(0, FitPanel.this.getMaxYIDataSet(FitPanel.this.currentDataset, FitPanel.this.currentRangeMin, FitPanel.this.currentRangeMax));
                        } else if (i == 1) {
                            FitPanel.this.fitFunction.setParameter(1, FitPanel.this.getMeanIDataSet(FitPanel.this.currentDataset, FitPanel.this.currentRangeMin, FitPanel.this.currentRangeMax));
                        } else if (i == 2) {
                            FitPanel.this.fitFunction.setParameter(2, FitPanel.this.getRMSIDataSet(FitPanel.this.currentDataset, FitPanel.this.currentRangeMin, FitPanel.this.currentRangeMax));
                        } else if (i == 3) {
                            FitPanel.this.fitFunction.setParameter(3, FitPanel.this.getAverageHeightIDataSet(FitPanel.this.currentDataset, FitPanel.this.currentRangeMin, FitPanel.this.currentRangeMax));
                        } else if (i > 3) {
                            FitPanel.this.fitFunction.setParameter(i, 1.0);
                        }
                        System.out.println("Paramter " + i + " =" + FitPanel.this.fitFunction.getParameter(i));
                    }
                }
                System.out.println("Fitting!");
                DataFitter.fit(FitPanel.this.fitFunction, FitPanel.this.currentDataset, FitPanel.this.options);
                FitPanel.this.fitFunction.show();
                FitPanel.this.fitFunction.setLineColor(2);
                FitPanel.this.fitFunction.setLineWidth(5);
                FitPanel.this.fitFunction.setLineStyle(1);
                FitPanel.this.canvas.cd(FitPanel.this.index);
                FitPanel.this.canvas.draw(FitPanel.this.fitFunction, "same" + drawOption);
                FitPanel.this.canvas.update();
                FitPanel.this.parameterPanel.updateNewFunction(FitPanel.this.fitFunction);
            }
        });
        final List<EmbeddedPad> canvasPads = this.canvas.getCanvasPads();
        JPanel fitButtons = new JPanel(new GridLayout(1, 2));
        if (canvasPads.size() > 1) {
            JButton fitAll = new JButton("Fit All");
            fitAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int method = FitPanel.this.paramEstimationMethods.getSelectedIndex();
                    if (method == 0) {
                        FitPanel.this.options = "ER";
                    } else if (method == 1) {
                        FitPanel.this.options = "NR";
                    } else if (method == 2) {
                        FitPanel.this.options = "PR";
                    } else if (method == 3) {
                        FitPanel.this.options = "R";
                    } else if (method == 4) {
                        FitPanel.this.options = "LR";
                    }
                    String drawOption = "";
                    for (int i = 0; i < FitPanel.this.optionCheckBoxes.size(); ++i) {
                        if (FitPanel.this.optionCheckBoxes.get(0).isSelected()) {
                            drawOption = "S";
                        }
                        if (!FitPanel.this.optionCheckBoxes.get(1).isSelected()) continue;
                        FitPanel.this.options = FitPanel.this.options + "Q";
                    }
                    for (int padCounter = 0; padCounter < canvasPads.size(); ++padCounter) {
                        double min = FitPanel.this.canvas.getPad(padCounter).getAxisX().getMin();
                        double max = FitPanel.this.canvas.getPad(padCounter).getAxisX().getMax();
                        if (FitPanel.this.fitAllFitFunctions.size() != canvasPads.size()) {
                            FitPanel.this.fitAllFitFunctions.add(new F1D("f1", FitPanel.this.predefFunctionsF1D[FitPanel.this.predefinedFunctionsSelector.getSelectedIndex()], min, max));
                        } else {
                            FitPanel.this.fitAllFitFunctions.set(padCounter, new F1D("f1", FitPanel.this.predefFunctionsF1D[FitPanel.this.predefinedFunctionsSelector.getSelectedIndex()], min, max));
                        }
                        ArrayList<IDataSet> tempDataset = new ArrayList<IDataSet>();
                        int ndataset = FitPanel.this.canvas.getPad(padCounter).getDatasetPlotters().size();
                        for (int i = 0; i < ndataset; ++i) {
                            IDataSet ds = FitPanel.this.canvas.getPad(padCounter).getDatasetPlotters().get(i).getDataSet();
                            String name = ds.getName();
                            FitPanel.this.dataSetNames.add(name);
                            tempDataset.add(ds);
                        }
                        if (ndataset <= 0) continue;
                        IDataSet currentDataset = (IDataSet)tempDataset.get(0);
                        FitPanel.this.fitAllFitFunctions.get(padCounter).setRange(min, max);
                        if (FitPanel.this.predef) {
                            for (int i = 0; i < FitPanel.this.fitAllFitFunctions.get(padCounter).getNPars(); ++i) {
                                if (i == 0) {
                                    FitPanel.this.fitAllFitFunctions.get(padCounter).setParameter(0, FitPanel.this.getMaxYIDataSet(currentDataset, min, max));
                                    continue;
                                }
                                if (i == 1) {
                                    FitPanel.this.fitAllFitFunctions.get(padCounter).setParameter(1, FitPanel.this.getMeanIDataSet(currentDataset, min, max));
                                    continue;
                                }
                                if (i == 2) {
                                    FitPanel.this.fitAllFitFunctions.get(padCounter).setParameter(2, FitPanel.this.getRMSIDataSet(currentDataset, min, max));
                                    if (FitPanel.this.predefinedFunctionsSelector.getSelectedIndex() >= 5) continue;
                                    FitPanel.this.fitFunction.setParLimits(2, 0.0, Double.MAX_VALUE);
                                    continue;
                                }
                                if (i == 3) {
                                    FitPanel.this.fitAllFitFunctions.get(padCounter).setParameter(3, FitPanel.this.getAverageHeightIDataSet(currentDataset, min, max));
                                    continue;
                                }
                                if (i <= 3) continue;
                                FitPanel.this.fitAllFitFunctions.get(padCounter).setParameter(i, 1.0);
                            }
                        }
                        DataFitter.fit(FitPanel.this.fitAllFitFunctions.get(padCounter), currentDataset, FitPanel.this.options);
                        FitPanel.this.fitAllFitFunctions.get(padCounter).setLineColor(2);
                        FitPanel.this.fitAllFitFunctions.get(padCounter).setLineWidth(5);
                        FitPanel.this.fitAllFitFunctions.get(padCounter).setLineStyle(1);
                        FitPanel.this.canvas.cd(padCounter);
                        FitPanel.this.canvas.draw(FitPanel.this.fitAllFitFunctions.get(padCounter), "same" + drawOption);
                        FitPanel.this.canvas.update();
                    }
                }
            });
            fitButtons.add(fit);
            fitButtons.add(fitAll);
            this.lowerWindow.add(fitButtons);
        } else {
            this.lowerWindow.add(fit);
        }
        return this.lowerWindow;
    }

    private double getMeanIDataSet(IDataSet data, double min, double max) {
        int nsamples = 0;
        double sum = 0.0;
        double nEntries = 0.0;
        for (int i = 0; i < data.getDataSize(0); ++i) {
            double x = data.getDataX(i);
            double y = data.getDataY(i);
            if (!(x > min) || !(x < max) || y == 0.0) continue;
            ++nsamples;
            sum += x * y;
            nEntries += y;
        }
        return sum / nEntries;
    }

    private double getRMSIDataSet(IDataSet data, double min, double max) {
        int nsamples = 0;
        double mean = this.getMeanIDataSet(data, min, max);
        double sum = 0.0;
        double nEntries = 0.0;
        for (int i = 0; i < data.getDataSize(0); ++i) {
            double x = data.getDataX(i);
            double y = data.getDataY(i);
            if (!(x > min) || !(x < max) || y == 0.0) continue;
            ++nsamples;
            sum += Math.pow(x - mean, 2.0) * y;
            nEntries += y;
        }
        return Math.sqrt(sum / nEntries);
    }

    private double getAverageHeightIDataSet(IDataSet data, double min, double max) {
        int nsamples = 0;
        double sum = 0.0;
        for (int i = 0; i < data.getDataSize(0); ++i) {
            double x = data.getDataX(i);
            double y = data.getDataY(i);
            if (!(x > min) || !(x < max) || y == 0.0) continue;
            ++nsamples;
            sum += y;
        }
        return sum / (double)nsamples;
    }

    private double getMaxXIDataSet(IDataSet data, double min, double max) {
        double max1 = 0.0;
        double xMax = 0.0;
        for (int i = 0; i < data.getDataSize(0); ++i) {
            double x = data.getDataX(i);
            double y = data.getDataY(i);
            if (!(x > min) || !(x < max) || y == 0.0 || !(y > max1)) continue;
            max1 = y;
            xMax = x;
        }
        return xMax;
    }

    private double getMaxYIDataSet(IDataSet data, double min, double max) {
        double max1 = 0.0;
        double xMax = 0.0;
        for (int i = 0; i < data.getDataSize(0); ++i) {
            double x = data.getDataX(i);
            double y = data.getDataY(i);
            if (!(x > min) || !(x < max) || y == 0.0 || !(y > max1)) continue;
            max1 = y;
            xMax = x;
        }
        return max1;
    }
}

