/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.matrix;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jlab.groot.data.H1F;
import org.jlab.groot.graphics.EmbeddedCanvasTabbed;
import org.jlab.groot.matrix.SparseGridIO;
import org.jlab.groot.matrix.SparseIndexPane;
import org.jlab.groot.matrix.SparseVectorGrid;

public class GridStudio
extends JFrame
implements ActionListener {
    JPanel mainPane = null;
    JPanel actionPane = null;
    EmbeddedCanvasTabbed canvas = null;
    SparseIndexPane indexPane = null;
    SparseVectorGrid grid = null;

    public GridStudio(String filename) {
        this.initUI();
        this.add(this.mainPane);
        this.pack();
        this.setVisible(true);
    }

    public GridStudio() {
        this.initUI();
        this.add(this.mainPane);
        this.pack();
        this.setVisible(true);
    }

    public void openFile(String filename) {
        this.grid = SparseGridIO.importHipo(filename);
        this.mainPane.remove(this.indexPane);
        this.indexPane = new SparseIndexPane(this.grid.getIndexer().getBinsPerAxis(), this.grid.getVectorSize());
        this.mainPane.add((Component)this.indexPane, "Last");
        this.validate();
    }

    private void initUI() {
        this.mainPane = new JPanel();
        this.mainPane.setLayout(new BorderLayout());
        this.canvas = new EmbeddedCanvasTabbed();
        this.indexPane = new SparseIndexPane(new int[]{9, 21, 31}, 1);
        this.mainPane.add((Component)this.canvas, "Center");
        this.mainPane.add((Component)this.indexPane, "Last");
        this.actionPane = new JPanel();
        JButton buttonPlot = new JButton("Draw");
        buttonPlot.addActionListener(this);
        JButton buttonOverView = new JButton("Over View");
        buttonOverView.addActionListener(this);
        this.actionPane.add(buttonPlot);
        this.actionPane.add(buttonOverView);
        this.mainPane.add((Component)this.actionPane, "First");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        H1F h;
        int[] binsMax;
        if (e.getActionCommand().compareTo("Draw") == 0) {
            int[] binsMin = this.indexPane.getBinsMin();
            binsMax = this.indexPane.getBinsMax();
            int dim = this.indexPane.getSelectedBin();
            int order = this.indexPane.getSelectedOrder();
            h = this.grid.slice(dim, order, binsMin, binsMax);
            this.canvas.getCanvas().drawNext(h);
            this.canvas.getCanvas().update();
        }
        if (e.getActionCommand().compareTo("Over View") == 0) {
            this.canvas.getCanvas().divide(1, this.grid.getIndexer().getRank());
            int order = this.indexPane.getSelectedOrder();
            binsMax = this.grid.getIndexer().getBinsPerAxis();
            int[] binsMin = new int[binsMax.length];
            for (int k = 0; k < binsMin.length; ++k) {
                binsMin[k] = 0;
            }
            for (int i = 0; i < this.grid.getIndexer().getRank(); ++i) {
                h = this.grid.slice(i, order, binsMin, binsMax);
                this.canvas.getCanvas().drawNext(h);
            }
        }
    }

    public static void main(String[] args) {
        GridStudio studio = new GridStudio();
        studio.openFile("grid.hipo");
    }
}

