/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.math;

import org.jlab.groot.data.GraphErrors;
import org.jlab.groot.data.H1F;
import org.jlab.groot.math.Func1D;

public class RandomFunc {
    private GraphErrors dataFunc = null;
    private H1F randomHIST = null;

    public RandomFunc(Func1D func) {
        this.cumulative(func, 200);
        this.cummulativeHist(func, 200);
    }

    public RandomFunc(Func1D func, int resolution) {
        this.cumulative(func, resolution);
        this.cummulativeHist(func, resolution);
    }

    private void cumulative(Func1D func, int nsamples) {
        this.dataFunc = new GraphErrors();
        double min = func.getMin();
        double max = func.getMax();
        for (int i = 0; i < nsamples; ++i) {
            double x = min + (double)i * (max - min) / (double)nsamples;
            double y = func.evaluate(x);
            double xprev = 0.0;
            double yprev = 0.0;
            if (i != 0) {
                xprev = this.dataFunc.getDataX(i - 1);
                yprev = this.dataFunc.getDataY(i - 1);
            }
            this.dataFunc.addPoint(x, y + yprev, 0.0, 0.0);
        }
        int nBins = this.dataFunc.getDataSize(0);
        double maxValue = this.dataFunc.getDataY(nBins - 1);
        for (int i = 0; i < nBins; ++i) {
            double x = this.dataFunc.getDataX(i);
            double y = this.dataFunc.getDataY(i);
            this.dataFunc.setPoint(i, x, y / maxValue);
        }
    }

    public final void cummulativeHist(Func1D func, int nsamples) {
        this.randomHIST = new H1F("RANDOM", "", nsamples, func.getMin(), func.getMax());
        double integral = 0.0;
        for (int i = 0; i < nsamples; ++i) {
            double x = this.randomHIST.getAxis().getBinCenter(i);
            double y = func.evaluate(x);
            this.randomHIST.setBinContent(i, integral += y);
        }
        this.randomHIST.divide(integral);
    }

    public GraphErrors getGraph() {
        return this.dataFunc;
    }

    public double random() {
        double number = Math.random();
        int bin = this.dataFunc.getVectorY().findBin(number);
        if (--bin < 0) {
            bin = 1;
        }
        double xlow = this.dataFunc.getVectorX().getLowEdge(bin);
        double xhi = this.dataFunc.getVectorX().getHighEdge(bin);
        return xlow + Math.random() * (xhi - xlow);
    }

    public double randomh() {
        double number = Math.random();
        int bin = 0;
        int i = 0;
        while (i < this.randomHIST.getAxis().getNBins() && !(this.randomHIST.getBinContent(bin = i++) > number)) {
        }
        double axisX = this.randomHIST.getAxis().getBinCenter(bin);
        double width = this.randomHIST.getAxis().getBinWidth(bin);
        return axisX + Math.random() * width - width / 2.0;
    }
}

