/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.math;

import java.io.Serializable;

public class MultiIndex
implements Serializable {
    private Integer indexDim;
    private Integer[] dimSizes;
    private Integer[] currentIndex;

    public MultiIndex() {
        this.indexDim = 0;
        this.dimSizes = new Integer[0];
        this.currentIndex = new Integer[0];
    }

    public MultiIndex(int ... d) {
        this.setDimensions(d);
    }

    public final void setDimensions(int ... d) {
        this.indexDim = d.length;
        this.dimSizes = new Integer[d.length];
        this.currentIndex = new Integer[d.length];
        for (int i = 0; i < d.length; ++i) {
            this.dimSizes[i] = d[i];
            this.currentIndex[i] = -1;
        }
    }

    public int getArraySize() {
        int aSize = 1;
        for (int i = 0; i < this.dimSizes.length; ++i) {
            aSize *= this.dimSizes[i].intValue();
        }
        return aSize;
    }

    public int getArrayIndex(int ... ind) {
        if (ind.length == this.indexDim) {
            if (ind.length == 1) {
                return ind[0];
            }
            if (ind.length == 2) {
                if (!this.checkIndex(0, ind[0]) || !this.checkIndex(1, ind[1])) {
                    return -1;
                }
                return ind[0] + ind[1] * this.dimSizes[0];
            }
            if (ind.length == 3) {
                if (!(this.checkIndex(0, ind[0]) && this.checkIndex(1, ind[1]) && this.checkIndex(2, ind[2]))) {
                    return -1;
                }
                return ind[2] * this.dimSizes[1] * this.dimSizes[0] + ind[1] * this.dimSizes[0] + ind[0];
            }
        }
        return -1;
    }

    private boolean checkIndex(int dim, int index) {
        return index >= 0 && index < this.dimSizes[dim];
    }
}

