/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextFileReader {
    private BufferedReader bufferedReader = null;
    private List<String> readLineTokens = new ArrayList<String>();
    private String tokenizer = "\\s+";

    public boolean openFile(String name) {
        try {
            FileReader fileReader = new FileReader(name);
            this.bufferedReader = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException ex) {
            System.out.println("[TextFileReader] ---> error openning file : " + name);
            this.bufferedReader = null;
            return false;
        }
        return true;
    }

    public boolean readNext() {
        if (this.bufferedReader == null) {
            this.readLineTokens.clear();
            return false;
        }
        try {
            String[] tokens;
            String line = null;
            while ((line = this.bufferedReader.readLine()) != null && line.startsWith("#")) {
            }
            this.readLineTokens.clear();
            if (line == null) {
                return false;
            }
            for (String token : tokens = line.split(this.tokenizer)) {
                this.readLineTokens.add(token);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(TextFileReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    public int getDataSize() {
        return this.readLineTokens.size();
    }

    public double[] getAsDouble(int min, int max) {
        int size = max - min + 1;
        int[] index = new int[size];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i + min;
        }
        return this.getAsDouble(index);
    }

    public double[] getAsDouble(int[] index) {
        double[] result = new double[index.length];
        for (int i = 0; i < index.length; ++i) {
            int id = index[i];
            try {
                double value;
                result[i] = value = Double.parseDouble(this.readLineTokens.get(id));
                continue;
            }
            catch (Exception e) {
                System.out.println("[getAsDouble] error : parsing " + this.readLineTokens.get(id) + " as double has failed");
                result[i] = 0.0;
            }
        }
        return result;
    }

    public int[] getAsInt(int min, int max) {
        int size = max - min + 1;
        int[] index = new int[size];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i + min;
        }
        return this.getAsInt(index);
    }

    public int[] getAsInt(int[] index) {
        int[] result = new int[index.length];
        for (int i = 0; i < index.length; ++i) {
            int id = index[i];
            try {
                int value;
                result[i] = value = Integer.parseInt(this.readLineTokens.get(id));
                continue;
            }
            catch (Exception e) {
                System.out.println("[getAsDouble] error : parsing " + this.readLineTokens.get(id) + " as double has failed");
                result[i] = 0;
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("LINE :");
        for (String item : this.readLineTokens) {
            str.append("   ");
            str.append(item);
        }
        return str.toString();
    }

    public void show() {
        System.out.println(this.toString());
    }

    public static void main(String[] args) {
        TextFileReader reader = new TextFileReader();
        reader.openFile("/Users/gavalian/Work/Software/Release-9.0/COATJAVA/coatjava/readertest.txt");
        while (reader.readNext()) {
            reader.show();
            double[] array = reader.getAsDouble(10, 13);
            for (int i = 0; i < array.length; ++i) {
                System.out.print(" " + array[i]);
            }
            System.out.println();
        }
    }
}

