/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.graphics;

import java.awt.Color;
import java.awt.Graphics2D;
import org.jlab.groot.base.ColorPalette;
import org.jlab.groot.data.IDataSet;
import org.jlab.groot.graphics.GraphicsAxisFrame;
import org.jlab.groot.graphics.IDataSetPlotter;
import org.jlab.groot.math.Dimension1D;
import org.jlab.groot.math.Dimension3D;

public class Histogram2DPlotter
implements IDataSetPlotter {
    String plotterName = "";
    String plotterOptions = "";
    IDataSet dataSet = null;
    Dimension3D dataRegion = new Dimension3D();
    Dimension1D dataRegionZ = new Dimension1D();
    ColorPalette palette = new ColorPalette();

    public Histogram2DPlotter(IDataSet ds) {
        this.dataSet = ds;
    }

    @Override
    public String getOptions() {
        return this.plotterOptions;
    }

    @Override
    public void setOptions(String opt) {
        this.plotterOptions = opt;
    }

    @Override
    public String getName() {
        return this.dataSet.getName();
    }

    @Override
    public IDataSet getDataSet() {
        return this.dataSet;
    }

    @Override
    public void draw(Graphics2D g2d, GraphicsAxisFrame frame) {
        int npointsX = this.dataSet.getDataSize(0);
        int npointsY = this.dataSet.getDataSize(1);
        frame.setDrawAxisZ(true);
        this.updateRegion();
        for (int xd = 0; xd < this.dataSet.getDataSize(0); ++xd) {
            for (int yd = 0; yd < this.dataSet.getDataSize(1); ++yd) {
                double dataX = this.dataSet.getDataX(xd);
                double dataY = this.dataSet.getDataY(yd);
                double errorX = this.dataSet.getDataEX(xd);
                double errorY = this.dataSet.getDataEY(yd);
                double xps = frame.getAxisPointX(dataX - errorX * 0.5);
                double xpe = frame.getAxisPointX(dataX + errorX * 0.5);
                double yps = frame.getAxisPointY(dataY - errorY * 0.5);
                double ype = frame.getAxisPointY(dataY + errorY * 0.5);
                double height = yps - ype;
                double dataWeight = this.dataSet.getData(xd, yd);
                boolean zAxisLog = frame.getAxisZ().getLog();
                Color weightColor = frame.getAxisZ().isAutoScale() ? (this.dataRegionZ.getMin() < 0.0 ? this.palette.getColor3D(dataWeight -= this.dataRegionZ.getMin(), this.dataRegionZ.getMax() - this.dataRegionZ.getMin(), zAxisLog) : this.palette.getColor3D(dataWeight, this.dataRegionZ.getMax(), zAxisLog)) : this.palette.getColor3D(dataWeight -= frame.getAxisZ().getRange().getMin(), frame.getAxisZ().getRange().getMax() - frame.getAxisZ().getRange().getMin(), zAxisLog);
                g2d.setColor(weightColor);
                g2d.fillRect((int)xps, (int)ype, (int)(xpe - xps) + 1, (int)(yps - ype) + 1);
            }
        }
        if (this.dataSet.getAttributes().isDrawAxis()) {
            this.palette.draw(g2d, 50, 50, 50, 50, frame.getAxisZ().getRange().getMin(), this.dataRegionZ.getMax(), frame.getAxisZ().getLog());
        }
    }

    public void updateRegion() {
        this.dataRegionZ.setMinMax(this.dataSet.getData(0, 0), this.dataSet.getData(0, 0));
        for (int xd = 0; xd < this.dataSet.getDataSize(0); ++xd) {
            for (int yd = 0; yd < this.dataSet.getDataSize(1); ++yd) {
                this.dataRegionZ.grow(this.dataSet.getData(xd, yd));
            }
        }
    }

    @Override
    public Dimension3D getDataRegion() {
        if (this.dataSet.getDataSize(0) > 0 && this.dataSet.getDataSize(1) > 0) {
            this.dataRegion.set(this.dataSet.getDataX(0), this.dataSet.getDataX(0), this.dataSet.getDataY(0), this.dataSet.getDataY(0), this.dataSet.getData(0, 0), this.dataSet.getData(0, 0));
            for (int xd = 0; xd < this.dataSet.getDataSize(0); ++xd) {
                for (int yd = 0; yd < this.dataSet.getDataSize(1); ++yd) {
                    this.dataRegion.grow(this.dataSet.getDataX(xd) - this.dataSet.getDataEX(xd) * 0.5, this.dataSet.getDataY(yd) - this.dataSet.getDataEY(yd) * 0.5, this.dataSet.getData(xd, yd));
                    this.dataRegion.grow(this.dataSet.getDataX(xd) + this.dataSet.getDataEX(xd) * 0.5, this.dataSet.getDataY(yd) + this.dataSet.getDataEY(yd) * 0.5, this.dataSet.getData(xd, yd));
                }
            }
        }
        return this.dataRegion;
    }
}

