/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.graphics;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import org.jlab.groot.base.TStyle;
import org.jlab.groot.base.WobbleStroke;
import org.jlab.groot.data.IDataSet;
import org.jlab.groot.graphics.GraphicsAxisFrame;
import org.jlab.groot.graphics.IDataSetPlotter;
import org.jlab.groot.math.Dimension3D;

public class FunctionPlotter
implements IDataSetPlotter {
    private Dimension3D dataRegion = new Dimension3D();
    private String drawOptions = "";
    private IDataSet functionData = null;

    public FunctionPlotter(IDataSet func) {
        this.functionData = func;
    }

    @Override
    public String getOptions() {
        return this.drawOptions;
    }

    @Override
    public void setOptions(String opt) {
        this.drawOptions = opt;
    }

    @Override
    public String getName() {
        return this.functionData.getName();
    }

    @Override
    public IDataSet getDataSet() {
        return this.functionData;
    }

    @Override
    public void draw(Graphics2D g2d, GraphicsAxisFrame frame) {
        float[] dash1;
        int npoints = this.functionData.getDataSize(0);
        GeneralPath path = new GeneralPath();
        double xp = frame.getAxisPointX(this.functionData.getDataX(0));
        double yp = frame.getAxisPointY(this.functionData.getDataY(0));
        path.moveTo(xp, yp);
        for (int p = 0; p < npoints; ++p) {
            xp = frame.getAxisPointX(this.functionData.getDataX(p));
            yp = frame.getAxisPointY(this.functionData.getDataY(p));
            path.lineTo(xp, yp);
        }
        int lineColor = this.functionData.getAttributes().getLineColor();
        int lineWidth = this.functionData.getAttributes().getLineWidth();
        int lineStyle = this.functionData.getAttributes().getLineStyle();
        g2d.setColor(TStyle.getColor(lineColor));
        g2d.setStroke(new BasicStroke(lineWidth));
        if (lineStyle == 2) {
            dash1 = new float[]{20.0f};
            g2d.setStroke(new BasicStroke(lineWidth, 0, 0, 20.0f, dash1, 0.0f));
        }
        if (lineStyle == 3) {
            dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(lineWidth, 0, 0, 5.0f, dash1, 0.0f));
        }
        if (lineStyle == 4) {
            dash1 = new float[]{20.0f, 5.0f};
            g2d.setStroke(new BasicStroke(lineWidth, 0, 0, 20.0f, dash1, 0.0f));
        }
        if (lineStyle == 5) {
            WobbleStroke stroke = new WobbleStroke(lineWidth);
            g2d.setStroke(stroke);
        }
        g2d.draw(path);
    }

    @Override
    public Dimension3D getDataRegion() {
        double xp = this.functionData.getDataX(0);
        double yp = this.functionData.getDataY(0);
        this.dataRegion.set(xp, xp, yp, yp, 0.0, 1.0);
        int npoints = this.functionData.getDataSize(0);
        for (int i = 0; i < npoints; ++i) {
            this.dataRegion.grow(this.functionData.getDataX(i), this.functionData.getDataY(i), 0.5);
        }
        double length = this.dataRegion.getDimension(1).getLength();
        this.dataRegion.getDimension(1).setMinMax(this.dataRegion.getDimension(1).getMin(), this.dataRegion.getDimension(1).getMin() + length * 1.1);
        return this.dataRegion;
    }
}

