/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.data;

import java.util.ArrayList;
import java.util.List;

public class DataVector {
    private final ArrayList<Double> datavec = new ArrayList();
    private Boolean isVectorOrdered = true;
    private Boolean isFixedLength = false;

    public DataVector(int size) {
        this.isFixedLength = true;
        for (int i = 0; i < size; ++i) {
            this.datavec.add(0.0);
        }
    }

    public DataVector() {
    }

    public DataVector(double[] data) {
        this.set(data);
    }

    public DataVector(List<Double> data) {
        this.set(data);
    }

    public final void set(double[] data) {
        this.datavec.clear();
        for (int loop = 0; loop < data.length; ++loop) {
            if (loop != 0 && data[loop] < data[loop - 1]) {
                this.isVectorOrdered = false;
            }
            this.datavec.add(data[loop]);
        }
    }

    public final void set(List<Double> data) {
        this.datavec.clear();
        for (Double item : data) {
            this.add(item);
        }
    }

    public int size() {
        return this.datavec.size();
    }

    public void clear() {
        this.datavec.clear();
    }

    public void addDataVector(DataVector vec) {
        if (vec.getSize() != this.getSize()) {
            System.out.println("[addDataVector] error adding vectors. sizes are different");
            return;
        }
        for (int i = 0; i < this.getSize(); ++i) {
            this.datavec.set(i, this.getValue(i) + vec.getValue(i));
        }
    }

    public void add(double value) {
        if (!this.isFixedLength.booleanValue()) {
            if (this.isVectorOrdered.booleanValue() && !this.datavec.isEmpty() && value < this.datavec.get(this.datavec.size() - 1)) {
                this.isVectorOrdered = false;
            }
            this.datavec.add(value);
        } else {
            System.out.println("[DataVector] error : add function does not work with fixed length vectors");
        }
    }

    public double getMin() {
        if (this.datavec.size() < 1) {
            return 0.0;
        }
        double min = this.datavec.get(0);
        for (Double value : this.datavec) {
            if (!(value < min)) continue;
            min = value;
        }
        return min;
    }

    public double getMax() {
        if (this.datavec.size() < 1) {
            return 0.0;
        }
        double max = this.datavec.get(0);
        for (Double value : this.datavec) {
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    public int getBinSuggestion() {
        return 100;
    }

    public void copy(DataVector vec) {
        this.datavec.clear();
        for (int loop = 0; loop < vec.getSize(); ++loop) {
            this.add(vec.getValue(loop));
        }
    }

    public boolean isOrdered() {
        return this.isVectorOrdered;
    }

    public int findBin(double value) {
        return this.findBin(value, 0);
    }

    public int findBin(double value, int start) {
        if (start >= this.getSize()) {
            return -1;
        }
        for (int loop = start; loop < this.getSize(); ++loop) {
            if (!(this.getValue(loop) > value)) continue;
            return loop;
        }
        return -1;
    }

    public void mult(double norm) {
        for (int loop = 0; loop < this.datavec.size(); ++loop) {
            double newValue = this.getValue(loop) * norm;
            this.datavec.set(loop, newValue);
        }
    }

    public void divide(double norm) {
        for (int loop = 0; loop < this.datavec.size(); ++loop) {
            double newValue = this.getValue(loop) / norm;
            this.datavec.set(loop, newValue);
        }
    }

    public DataVector getCumulative() {
        DataVector data = new DataVector();
        double integral = 0.0;
        for (Double value : this.datavec) {
            data.add(integral);
            integral += value.doubleValue();
        }
        return data;
    }

    public double getMean(DataVector xvec) {
        if (this.datavec.size() < 1) {
            return 0.0;
        }
        if (xvec.getSize() != this.getSize()) {
            System.err.println("DataVector::getMean: ** ERROR ** :  data vectors doe not have the same size.");
            return 0.0;
        }
        if (!xvec.isOrdered()) {
            System.err.println("DataVector::getMean: ** ERROR ** :  the vector passed to the routine is not ordered.");
            return 0.0;
        }
        double runsumm = 0.0;
        int count = 0;
        for (int loop = 0; loop < this.getSize(); ++loop) {
            runsumm += this.getValue(loop) * xvec.getValue(loop);
            ++count;
        }
        return runsumm / (double)count;
    }

    public double getMean() {
        if (this.datavec.size() < 1) {
            return 0.0;
        }
        double runsumm = 0.0;
        for (Double value : this.datavec) {
            runsumm += value.doubleValue();
        }
        return runsumm / (double)this.datavec.size();
    }

    public double getRMS() {
        double rms = 0.0;
        double mean = this.getMean();
        for (Double value : this.datavec) {
            rms += (value - mean) * (value - mean);
        }
        double rms2 = rms / (double)this.datavec.size();
        return Math.sqrt(rms2);
    }

    public int getSize() {
        return this.datavec.size();
    }

    public double getValue(int index) {
        if (index < 0 || index >= this.datavec.size()) {
            System.err.println("DataVector:: ** ERROR ** : requested element " + index + " in the vector of size = " + this.datavec.size());
        }
        return this.datavec.get(index);
    }

    public double getLowEdge(int bin) {
        if (!this.isVectorOrdered.booleanValue()) {
            System.err.println("DataVector:: ** ERROR ** : this vector is not ordered. Can not define low egde for the bin");
            return 0.0;
        }
        double value = this.getValue(bin);
        double dist = 0.0;
        dist = bin == 0 ? Math.abs(this.getValue(bin + 1) - value) : Math.abs(this.getValue(bin - 1) - value);
        return value -= 0.5 * dist;
    }

    public double getHighEdge(int bin) {
        if (!this.isVectorOrdered.booleanValue()) {
            System.err.println("DataVector:: ** ERROR ** : this vector is not ordered. Can not define low egde for the bin");
            return 0.0;
        }
        double value = this.getValue(bin);
        double dist = 0.0;
        dist = bin == this.getSize() - 1 ? Math.abs(this.getValue(bin - 1) - value) : Math.abs(this.getValue(bin + 1) - value);
        return value += 0.5 * dist;
    }

    public double getBinWidth(int index) {
        if (!this.isVectorOrdered.booleanValue()) {
            System.err.println("DataVector:: ** ERROR ** : this vector is not ordered. Bin widths do not make sense.");
            return 0.0;
        }
        return this.getHighEdge(index) - this.getLowEdge(index);
    }

    public double[] getArray() {
        double[] array = new double[this.getSize()];
        for (int loop = 0; loop < this.getSize(); ++loop) {
            array[loop] = this.getValue(loop);
        }
        return array;
    }

    public void set(int index, double value) {
        if (index >= 0 && index < this.getSize()) {
            this.datavec.set(index, value);
        } else {
            System.out.println("[DataVector] --> warning : vector has size " + this.getSize() + ". index=" + index + " is out of bounds.");
        }
    }

    public void setValue(int index, double value) {
        if (this.isFixedLength.booleanValue()) {
            if (index >= 0 && index < this.datavec.size()) {
                this.datavec.set(index, value);
            }
        } else {
            System.out.println("[DataVector] error : setValue works only for fixed length vectors.");
        }
    }
}

