/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.base;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;

public class WobbleStroke
implements Stroke {
    private float detail = 2.0f;
    private float amplitude = 2.0f;
    private static final float FLATNESS = 1.0f;
    private int width = 3;

    public WobbleStroke(float detail, float amplitude) {
        this.detail = detail;
        this.amplitude = amplitude;
    }

    public WobbleStroke(int lw) {
        this.width = lw;
        this.detail = 1.0f;
        this.amplitude = 2.0f;
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        GeneralPath result = new GeneralPath();
        shape = new BasicStroke(this.width).createStrokedShape(shape);
        FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] points = new float[6];
        float moveX = 0.0f;
        float moveY = 0.0f;
        float lastX = 0.0f;
        float lastY = 0.0f;
        float thisX = 0.0f;
        float thisY = 0.0f;
        int type = 0;
        boolean first = false;
        float next = 0.0f;
        while (!it.isDone()) {
            type = it.currentSegment(points);
            switch (type) {
                case 0: {
                    moveX = lastX = this.randomize(points[0]);
                    moveY = lastY = this.randomize(points[1]);
                    result.moveTo(moveX, moveY);
                    first = true;
                    next = 0.0f;
                    break;
                }
                case 4: {
                    points[0] = moveX;
                    points[1] = moveY;
                }
                case 1: {
                    thisX = this.randomize(points[0]);
                    thisY = this.randomize(points[1]);
                    float dx = thisX - lastX;
                    float dy = thisY - lastY;
                    float distance = (float)Math.sqrt(dx * dx + dy * dy);
                    if (distance >= next) {
                        float r = 1.0f / distance;
                        float angle = (float)Math.atan2(dy, dx);
                        while (distance >= next) {
                            float x = lastX + next * dx * r;
                            float y = lastY + next * dy * r;
                            result.lineTo(this.randomize(x), this.randomize(y));
                            next += this.detail;
                        }
                    }
                    next -= distance;
                    first = false;
                    lastX = thisX;
                    lastY = thisY;
                }
            }
            it.next();
        }
        return result;
    }

    private float randomize(float x) {
        return x + (float)Math.random() * this.amplitude * 2.0f - 1.0f;
    }
}

