/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.base;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jlab.groot.base.ColorPalette;
import org.jlab.groot.base.PadMargins;
import org.jlab.groot.base.WobbleStroke;
import org.jlab.groot.graphics.GraphicsAxis;
import org.jlab.groot.graphics.GraphicsAxisFrame;
import org.jlab.groot.ui.LatexText;
import org.jlab.groot.ui.PaveText;

public class GraphicsTests
extends JPanel {
    private static final long serialVersionUID = 7128170889587576863L;
    ColorPalette palette = new ColorPalette();
    GraphicsAxis xaxis = new GraphicsAxis(GraphicsAxis.AXISTYPE_HORIZONTAL);
    GraphicsAxis yaxis = new GraphicsAxis(GraphicsAxis.AXISTYPE_VERTICAL);

    public GraphicsTests() {
        this.setPreferredSize(new Dimension(500, 500));
    }

    @Override
    public void paint(Graphics g) {
        Long st = System.currentTimeMillis();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int xT = 100;
        int yT = 200;
        g2d.setColor(Color.red);
        g2d.drawOval(xT - 4, yT - 4, 8, 8);
        g2d.setColor(Color.blue);
        LatexText text = new LatexText("Rotation Test");
        text.setFontSize(18);
        text.drawString(g2d, xT, yT, LatexText.ALIGN_CENTER, LatexText.ALIGN_TOP, LatexText.ROTATE_LEFT);
        text.drawString(g2d, xT, yT, 1, 1);
        System.out.println("Pave text definition");
        PaveText pave = new PaveText(2);
        pave.setPosition(300, 300);
        pave.addText("Entries", "124500");
        pave.addText("RMS", "0.047+/-1.2345");
        for (int i = 0; i < 1; ++i) {
            pave.addText("Mean", "0.567");
            pave.addText("#chi^2/NDF", "126.34/57");
        }
        pave.addText("Underflow", "3456");
        pave.addText("Overflow", "23");
        pave.drawPave(g2d, 200, 200);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.drawOval(200, 200, 40, 40);
        g2d.fillOval(203, 203, 34, 34);
        WobbleStroke stroke = new WobbleStroke(1.0f, 6.0f);
        g2d.setStroke(stroke);
        g2d.drawLine(0, 0, 200, 200);
    }

    private void drawGraphicsFrame(Graphics2D g2d) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        PadMargins customMargins = new PadMargins();
        customMargins.setBottomMargin(60);
        customMargins.setTopMargin(40);
        customMargins.setLeftMargin(70);
        customMargins.setRightMargin(70);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, w, h);
        g2d.setColor(Color.BLACK);
        GraphicsAxisFrame frame = new GraphicsAxisFrame();
        frame.setFrameDimensions(0.0, w, 0.0, h);
        frame.getAxisX().setRange(0.0, 1.0);
        frame.getAxisY().setRange(200.0, 400.0);
        frame.updateMargins(g2d);
        frame.setAxisMargins(customMargins);
        frame.drawAxis(g2d, customMargins);
    }

    private void drawAxis(Graphics2D g2d) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, w, h);
        g2d.setColor(Color.BLACK);
        int offsetX = this.xaxis.getAxisBounds(g2d);
        int offsetY = this.yaxis.getAxisBounds(g2d);
        System.out.println(" AXIS BOUNDAS = " + offsetX + "  " + offsetY);
        this.xaxis.setTitle("X-axis");
        this.xaxis.setDimension(offsetY, w - 40);
        this.xaxis.setRange(0.0, 1.0);
        this.yaxis.setVertical(true);
        this.xaxis.setRange(0.0, 1.0);
        this.yaxis.setDimension(h - offsetX, 40);
        this.xaxis.drawAxis(g2d, offsetY, h - offsetX);
        this.yaxis.drawAxis(g2d, offsetY, h - offsetX);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        GraphicsTests canvas = new GraphicsTests();
        frame.add(canvas);
        frame.pack();
        frame.setVisible(true);
    }
}

