/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.groot.base;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComboBox;
import org.jlab.groot.base.AttributeType;

public class Attributes {
    Map<AttributeType, Integer> attributesMap = new LinkedHashMap<AttributeType, Integer>();
    Map<AttributeType, String> attributesString = new LinkedHashMap<AttributeType, String>();

    public void add(AttributeType type, int value) {
        this.attributesMap.put(type, value);
    }

    public boolean hasAttribute(AttributeType type) {
        return this.attributesMap.containsKey((Object)type);
    }

    public int get(AttributeType type) {
        return this.attributesMap.get((Object)type);
    }

    public String getString(AttributeType type) {
        return this.attributesString.get((Object)type);
    }

    public void addString(AttributeType type, String value) {
        this.attributesString.put(type, value);
    }

    public Map<AttributeType, Integer> getMap() {
        return this.attributesMap;
    }

    public void copy(Attributes attr) {
        this.attributesMap.clear();
        for (Map.Entry<AttributeType, Integer> entry : attr.getMap().entrySet()) {
            this.attributesMap.put(entry.getKey(), entry.getValue());
        }
    }

    public void copyValues(Attributes attr) {
        for (Map.Entry<AttributeType, Integer> entry : this.getMap().entrySet()) {
            if (!attr.getMap().containsKey((Object)entry.getKey())) continue;
            this.attributesMap.put(entry.getKey(), entry.getValue());
        }
    }

    public static void chooseByString(JComboBox comboBox, String value) {
        int nentries = comboBox.getItemCount();
        for (int index = 0; index < nentries; ++index) {
            String item = (String)comboBox.getItemAt(index);
            if (value.compareTo(item) != 0) continue;
            comboBox.setSelectedIndex(index);
            return;
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<AttributeType, Integer> entry : this.getMap().entrySet()) {
            str.append(String.format("* %-24s * %14d *\n", entry.getKey().getName(), entry.getValue()));
        }
        return str.toString();
    }
}

