/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.worker.impl.mandel;

import org.homedns.dade.jcgrid.WorkRequest;
import org.homedns.dade.jcgrid.WorkResult;
import org.homedns.dade.jcgrid.worker.Worker;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelWorkRequest;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelWorkResult;

public class MandelWorker
implements Worker {
    private short mandelIterate(double x, double y, short maxIter) {
        short iter;
        double r = 0.0;
        double i = 0.0;
        double m = 0.0;
        for (iter = 1; iter < maxIter && m < 4.0; iter = (short)(iter + 1)) {
            m = r * r - i * i;
            i = 2.0 * r * i + y;
            r = m + x;
        }
        iter = (short)(iter - 1);
        return iter;
    }

    public WorkResult doWork(WorkRequest work, String workDir) throws Exception {
        MandelWorkRequest mwr = (MandelWorkRequest)work;
        if (mwr.getMaxIter() > 30000) {
            mwr.setMaxIter((short)30000);
        } else if (mwr.getMaxIter() < 512) {
            mwr.setMaxIter((short)512);
        }
        if (mwr.getXStep() > 96) {
            mwr.setXStep(96);
        } else if (mwr.getXStep() < 1) {
            mwr.setYStep(1);
        }
        if (mwr.getYStep() > 96) {
            mwr.setYStep(96);
        } else if (mwr.getYStep() < 1) {
            mwr.setYStep(1);
        }
        short[][] iter = new short[mwr.getXStep()][mwr.getYStep()];
        double y = mwr.getYOrig();
        for (int j = 0; j < mwr.getYStep(); ++j) {
            double x = mwr.getXOrig();
            for (int i = 0; i < mwr.getXStep(); ++i) {
                iter[i][j] = this.mandelIterate(x, y, mwr.getMaxIter());
                x += mwr.getDX();
            }
            y += mwr.getDY();
        }
        return new MandelWorkResult(mwr.getSessionName(), mwr.getRID(), iter);
    }
}

