/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.worker;

import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.GridNodeGeneric;
import org.homedns.dade.jcgrid.vfs.vfsSessionPool;
import org.homedns.dade.jcgrid.worker.GridNodeWorkerConfig;
import org.homedns.dade.jcgrid.worker.GridWorkerFeedback;
import org.homedns.dade.jcgrid.worker.Worker;
import org.homedns.dade.jcgrid.worker.WorkerThread;

public class GridWorker
extends GridNodeGeneric {
    private static final String className = GridWorker.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private Worker worker;
    private WorkerThread wt;
    private long maxCacheSize;
    private vfsSessionPool sessions;
    private GridWorkerFeedback feedback;

    public GridWorker() {
        super(new GridNodeWorkerConfig());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start GridWorker()");
        }
        this.worker = null;
        this.wt = null;
        this.maxCacheSize = 0x4000000L;
        this.sessions = null;
        this.feedback = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"End GridWorker()");
        }
    }

    public void start() throws Exception {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start start()");
        }
        super.start();
        if (this.getNodeConfig().getGridConfig().getUseVFS()) {
            this.sessions = new vfsSessionPool(super.getNodeConfig().getWorkingDir(), this.maxCacheSize);
            this.sessions.start();
            log.warn((Object)("VFS Session cache size: " + this.sessions.getSize() / 0x100000L + "/" + this.maxCacheSize / 0x100000L + "MB"));
        } else {
            this.sessions = null;
        }
        this.wt = new WorkerThread(this);
        this.wt.setWorkerFeedback(this.feedback);
        this.wt.start();
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"End start()");
        }
    }

    public void waitShutdown() throws InterruptedException {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start waitShutdown()");
        }
        this.wt.join();
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"End waitShutdown()");
        }
    }

    public void stop() throws Exception {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start stop()");
        }
        this.wt.interrupt();
        try {
            this.wt.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.stop();
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"End stop()");
        }
    }

    public void setWorkerFeedback(GridWorkerFeedback f) {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("Start setWorkerFeedback(" + f + ")"));
        }
        this.feedback = f;
        if (this.wt != null) {
            this.wt.setWorkerFeedback(f);
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"End setWorkerFeedback()");
        }
    }

    public vfsSessionPool getVFSSessionPool() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getVFSSessionPool()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getVFSSessionPool(" + this.sessions + ")"));
        }
        return this.sessions;
    }

    public Worker getWorker() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getWorker()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getWorker(" + this.worker + ")"));
        }
        return this.worker;
    }

    public void setWorker(Worker w) {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("Start setWorker(" + w + ")"));
        }
        this.worker = w;
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"End setWorker()");
        }
    }

    public long getMaxCacheSize() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getMaxCacheSize()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getMaxCacheSize(" + this.maxCacheSize + ")"));
        }
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(long serverMaxCacheSize) {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("Start setMaxCacheSize(" + serverMaxCacheSize + ")"));
        }
        this.maxCacheSize = serverMaxCacheSize;
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"End setMaxCacheSize()");
        }
    }
}

