/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.homedns.dade.jcgrid.message.GridMessage;
import org.homedns.dade.jcgrid.util.GridMessageChannel;

public class GridMessageFlatChannel
implements GridMessageChannel {
    private Socket socket;
    private ObjectInputStream objIn;
    private ObjectOutputStream objOut;

    public GridMessageFlatChannel(Socket s, boolean isServer) throws IOException {
        this.socket = s;
        InputStream is = this.socket.getInputStream();
        OutputStream os = this.socket.getOutputStream();
        if (isServer) {
            this.objIn = new ObjectInputStream(is);
            this.objOut = new ObjectOutputStream(os);
        } else {
            this.objOut = new ObjectOutputStream(os);
            this.objIn = new ObjectInputStream(is);
        }
    }

    public GridMessage recv() throws IOException, ClassNotFoundException {
        GridMessage msg = (GridMessage)this.objIn.readObject();
        return msg;
    }

    public GridMessage recv(int timeout) throws IOException, ClassNotFoundException {
        this.socket.setSoTimeout(timeout);
        GridMessage msg = (GridMessage)this.objIn.readObject();
        this.socket.setSoTimeout(0);
        return msg;
    }

    public void send(GridMessage msg) throws IOException, ClassNotFoundException {
        this.objOut.writeObject(msg);
        this.objOut.flush();
        this.objOut.reset();
    }

    public void close() throws IOException {
        this.objIn.close();
        this.objOut.close();
        this.socket.close();
    }
}

