/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.server;

import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.GridNode;
import org.homedns.dade.jcgrid.WorkRequest;
import org.homedns.dade.jcgrid.WorkResult;
import org.homedns.dade.jcgrid.server.AdminMainDemon;
import org.homedns.dade.jcgrid.server.ClientHandlerThread;
import org.homedns.dade.jcgrid.server.ClientMainDemon;
import org.homedns.dade.jcgrid.server.GridNodeServerConfig;
import org.homedns.dade.jcgrid.server.HandlerThreads;
import org.homedns.dade.jcgrid.server.WorkRequestQueue;
import org.homedns.dade.jcgrid.server.WorkerMainDemon;
import org.homedns.dade.jcgrid.vfs.vfsSessionPool;

public class GridServer
extends GridNode {
    private static final String className = GridServer.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private ClientMainDemon clientMainDemon;
    private WorkerMainDemon workerMainDemon;
    private AdminMainDemon adminMainDemon;
    private HandlerThreads connectedClients;
    private HandlerThreads connectedWorkers;
    private HandlerThreads connectedAdmins;
    private WorkRequestQueue workRequestQueue;
    private vfsSessionPool sessions;
    private Class m_clientHandlerClass;

    public GridServer(Class a_clientHandlerClass) {
        this();
        this.m_clientHandlerClass = a_clientHandlerClass;
    }

    public Class getRegisteredClientHandler() {
        return this.m_clientHandlerClass;
    }

    public GridServer() {
        super(new GridNodeServerConfig());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start GridServer()");
        }
        this.clientMainDemon = null;
        this.workerMainDemon = null;
        this.adminMainDemon = null;
        this.connectedClients = new HandlerThreads();
        this.connectedWorkers = new HandlerThreads();
        this.connectedAdmins = new HandlerThreads();
        this.workRequestQueue = new WorkRequestQueue();
        this.sessions = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"End GridServer()");
        }
    }

    protected void pushWorkRequest(WorkRequest wr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start pushWorkRequest()");
        }
        this.workRequestQueue.push(wr);
        if (log.isDebugEnabled()) {
            log.debug((Object)"End pushWorkRequest()");
        }
    }

    protected WorkRequest popWorkRequest(long timeout) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start popWorkRequest(" + timeout + ")"));
        }
        WorkRequest wr = (WorkRequest)this.workRequestQueue.pop(timeout);
        if (log.isDebugEnabled()) {
            log.debug((Object)("End popWorkRequest(" + wr + ")"));
        }
        return wr;
    }

    protected WorkRequest popWorkRequest() throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start popWorkRequest()");
        }
        WorkRequest wr = (WorkRequest)this.workRequestQueue.pop();
        if (log.isDebugEnabled()) {
            log.debug((Object)("End popWorkRequest(" + wr + ")"));
        }
        return wr;
    }

    protected void removePendingWorkRequests(String sessionName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start removePendingWorkRequests(" + sessionName + ")"));
        }
        this.workRequestQueue.removePendingWorkRequests(sessionName);
        if (log.isDebugEnabled()) {
            log.debug((Object)"End removePendingWorkRequests()");
        }
    }

    protected void pushWorkResult(WorkResult wr) throws Exception {
        String sessionName;
        ClientHandlerThread cht;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start pushWorkResult(" + wr + ")"));
        }
        if ((cht = (ClientHandlerThread)this.connectedClients.getConnectedHandler(sessionName = wr.getSessionName())) != null) {
            cht.pushWorkResult(wr);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End pushWorkResult()");
        }
    }

    public void start() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start start()");
        }
        super.start();
        if (this.getNodeConfig().getGridConfig().getUseVFS()) {
            long maxCacheSize = ((GridNodeServerConfig)this.getNodeConfig()).getMaxCacheSize();
            this.sessions = new vfsSessionPool(this.getNodeConfig().getWorkingDir(), maxCacheSize);
            this.sessions.start();
            log.warn((Object)("VFS Session cache size: " + this.sessions.getSize() / 0x100000L + "/" + maxCacheSize / 0x100000L + "MB"));
        } else {
            this.sessions = null;
        }
        this.clientMainDemon = new ClientMainDemon(this);
        this.clientMainDemon.start();
        this.workerMainDemon = new WorkerMainDemon(this);
        this.workerMainDemon.start();
        this.adminMainDemon = new AdminMainDemon(this);
        this.adminMainDemon.start();
        log.warn((Object)"Ok");
        if (log.isDebugEnabled()) {
            log.debug((Object)"End start()");
        }
    }

    public void stop() throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start stop()");
        }
        this.clientMainDemon.interrupt();
        this.clientMainDemon.join();
        this.workerMainDemon.interrupt();
        this.workerMainDemon.join();
        this.adminMainDemon.interrupt();
        this.adminMainDemon.join();
        if (log.isDebugEnabled()) {
            log.debug((Object)"End stop()");
        }
    }

    protected HandlerThreads getClientHandlers() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getClientHandlers()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getClientHandlers(" + this.connectedClients + ")"));
        }
        return this.connectedClients;
    }

    protected HandlerThreads getWorkerHandlers() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getWorkerHandlers()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getWorkerHandlers(" + this.connectedWorkers + ")"));
        }
        return this.connectedWorkers;
    }

    protected HandlerThreads getAdminHandlers() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getAdminHandlers()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getAdminHandlers(" + this.connectedAdmins + ")"));
        }
        return this.connectedAdmins;
    }

    public vfsSessionPool getVFSSessionPool() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getVFSSessionPool()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getVFSSessionPool(" + this.sessions + ")"));
        }
        return this.sessions;
    }

    public int getRequestQueueSize() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getRequestQueueSize()");
        }
        int res = this.workRequestQueue.size();
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getRequestQueueSize(" + res + ")"));
        }
        return res;
    }
}

