/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.cmd.povray;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.GridNodeGenericConfig;
import org.homedns.dade.jcgrid.Version;
import org.homedns.dade.jcgrid.cmd.MainCmd;
import org.homedns.dade.jcgrid.worker.GridNodeWorkerConfig;
import org.homedns.dade.jcgrid.worker.GridWorker;
import org.homedns.dade.jcgrid.worker.impl.povray.POVWorker;

public class JCGridWorker {
    private static final String className = JCGridWorker.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));

    public static void main(String[] args) {
        try {
            int i;
            MainCmd.setUpLog4J("worker", true);
            log.warn((Object)"-----------------------------------------------");
            log.warn((Object)("-- JCGridWorker POVRay v" + Version.RELEASE));
            log.warn((Object)"-----------------------------------------------");
            GridNodeWorkerConfig config = new GridNodeWorkerConfig();
            String osName = System.getProperty("os.name");
            log.warn((Object)("OS Name: " + osName));
            boolean usePVEngineEXE = osName.matches("Windows.*");
            Options options = new Options();
            options.addOption("v", false, "Execute pvengine.exe instead of povray command");
            try {
                CommandLine cmd = MainCmd.parseCommonOptions(options, config, args);
                if (cmd.hasOption("v")) {
                    usePVEngineEXE = true;
                }
                if (cmd.getArgs().length > 0) {
                    throw new Exception("Unknown command line option");
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Error while parsing command line", (Throwable)ex);
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("JCGridWorker", options);
                System.exit(0);
            }
            GridWorker[] gw = new GridWorker[config.getWorkerCount()];
            for (i = 0; i < config.getWorkerCount(); ++i) {
                gw[i] = new GridWorker();
                gw[i].setNodeConfig((GridNodeGenericConfig)config.clone());
                ((GridNodeGenericConfig)gw[i].getNodeConfig()).setSessionName(config.getSessionName() + "_" + i);
                ((GridNodeGenericConfig)gw[i].getNodeConfig()).setWorkingDir(config.getWorkingDir() + "_" + i);
                gw[i].setWorker(new POVWorker(usePVEngineEXE));
                gw[i].start();
                log.warn((Object)("Running worker " + i + "..."));
            }
            for (i = 0; i < config.getWorkerCount(); ++i) {
                gw[i].waitShutdown();
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Error", (Throwable)ex);
            System.exit(0);
        }
    }
}

