/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid.cmd.mandel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.WorkRequest;
import org.homedns.dade.jcgrid.WorkResult;
import org.homedns.dade.jcgrid.worker.GridNodeWorkerConfig;
import org.homedns.dade.jcgrid.worker.GridWorker;
import org.homedns.dade.jcgrid.worker.GridWorkerFeedback;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelWorkRequest;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelWorkResult;
import org.homedns.dade.jcgrid.worker.impl.mandel.MandelWorker;

public class guiMandelWorkerPannel
extends JDialog {
    private static final String className = guiMandelWorkerPannel.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private static final long serialVersionUID = 1L;
    private GridWorker worker;
    private JLabel jLabel9;
    private JLabel lStatus;
    private JPanel pImage;
    private JPanel pStatus;

    public guiMandelWorkerPannel(GridNodeWorkerConfig workerConfig, Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.worker = new GridWorker();
        this.worker.setNodeConfig(workerConfig);
        this.worker.setWorker(new MandelWorker());
        this.worker.setWorkerFeedback(new WorkerFeedback());
        try {
            this.worker.start();
        }
        catch (Exception ex) {
            log.warn((Object)"Error starting the JCGrid worker", (Throwable)ex);
            JOptionPane.showMessageDialog(this, "Error starting the JCGrid worker.", "Worker error", 0);
            this.worker = null;
        }
    }

    private void initComponents() {
        this.pStatus = new JPanel();
        this.jLabel9 = new JLabel();
        this.lStatus = new JLabel();
        this.pImage = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("JCGrid MandelWorker");
        this.setDefaultCloseOperation(2);
        this.pStatus.setLayout(new GridBagLayout());
        this.pStatus.setBorder(new TitledBorder("Worker status"));
        this.jLabel9.setText("Status:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pStatus.add((Component)this.jLabel9, gridBagConstraints);
        this.lStatus.setText("...");
        this.lStatus.setForeground(Color.blue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pStatus.add((Component)this.lStatus, gridBagConstraints);
        this.pImage.setBorder(new BevelBorder(1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 48;
        gridBagConstraints.ipady = 48;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pStatus.add((Component)this.pImage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pStatus, gridBagConstraints);
        this.setBounds(100, 30, 300, 200);
    }

    private class WorkerFeedback
    implements GridWorkerFeedback {
        private Color[] colorTable;
        private String lastSessionName;

        public void setMaxIter(int maxIter) {
            this.colorTable = new Color[maxIter];
            float r = 1.0f;
            float g = 0.0f;
            float b = 0.0f;
            float dr = 0.11f;
            float dg = 0.001f;
            float db = 0.001f;
            for (int i = 0; i < maxIter - 1; ++i) {
                this.colorTable[i] = new Color(r, g, b);
                r += dr;
                g += dg;
                b += db;
                if ((double)r > 1.0) {
                    r = (float)((double)r - 1.0);
                }
                if ((double)g > 1.0) {
                    g = (float)((double)g - 1.0);
                }
                if (!((double)b > 1.0)) continue;
                b = (float)((double)b - 1.0);
            }
            this.colorTable[maxIter - 1] = Color.BLACK;
        }

        public void beginWorkingFor(String sessionName, WorkRequest req) {
            guiMandelWorkerPannel.this.lStatus.setText("working for " + sessionName);
            this.lastSessionName = sessionName;
            MandelWorkRequest r = (MandelWorkRequest)req;
            this.setMaxIter(r.getMaxIter());
        }

        public void endWorkingFor(WorkResult res) {
            guiMandelWorkerPannel.this.lStatus.setText("done work for " + this.lastSessionName);
            Graphics graph = guiMandelWorkerPannel.this.pImage.getGraphics();
            if (graph != null) {
                MandelWorkResult r = (MandelWorkResult)res;
                graph.setPaintMode();
                int w = guiMandelWorkerPannel.this.pImage.getWidth();
                int h = guiMandelWorkerPannel.this.pImage.getHeight();
                int fw = r.getIter().length;
                int fh = r.getIter()[0].length;
                for (int y = 0; y < fh; ++y) {
                    for (int x = 0; x < fw; ++x) {
                        graph.setColor(this.colorTable[r.getIter()[x][y] % this.colorTable.length]);
                        graph.fillRect(w / 2 - fw / 2 + x, h / 2 - fh / 2 + (fh - y), 1, 1);
                    }
                }
            }
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

