/*
 * Decompiled with CFR 0.152.
 */
package org.homedns.dade.jcgrid;

import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.GridConfig;
import org.homedns.dade.jcgrid.GridNode;
import org.homedns.dade.jcgrid.GridNodeGenericConfig;
import org.homedns.dade.jcgrid.message.GridMessageBeginSession;
import org.homedns.dade.jcgrid.message.GridMessageEndSession;
import org.homedns.dade.jcgrid.util.GridMessageChannel;
import org.homedns.dade.jcgrid.util.GridMessageFlatChannel;
import org.homedns.dade.jcgrid.util.GridMessageGZIPChannel;

public abstract class GridNodeGeneric
extends GridNode {
    private static final String className = GridNodeGeneric.class.getName();
    private static Logger log = Logger.getLogger((String)className);
    private static Logger logDetail = Logger.getLogger((String)("DETAIL." + className));
    private Socket serverSocket;
    private GridMessageChannel serverChannel;

    public GridNodeGeneric(GridNodeGenericConfig cfg) {
        super(cfg);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start GridNode(" + cfg + ")"));
        }
        this.serverSocket = null;
        this.serverChannel = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"End GridNode()");
        }
    }

    public void start() throws Exception {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start start()");
        }
        super.start();
        log.warn((Object)"  Connecting to server...");
        GridConfig gCfg = this.getNodeConfig().getGridConfig();
        int port = gCfg.getServerClientPort();
        if ("WORKER".equals(this.getNodeConfig().getType())) {
            port = gCfg.getServerWorkerPort();
        } else if ("ADMIN".equals(this.getNodeConfig().getType())) {
            port = gCfg.getServerAdminPort();
        }
        if (gCfg.getUseSecureConnection()) {
            SSLSocketFactory sslFact = (SSLSocketFactory)SSLSocketFactory.getDefault();
            this.serverSocket = sslFact.createSocket(gCfg.getServerAddress(), port);
        } else {
            this.serverSocket = new Socket(gCfg.getServerAddress(), port);
        }
        this.serverChannel = gCfg.getUseCompression() ? new GridMessageGZIPChannel(this.serverSocket) : new GridMessageFlatChannel(this.serverSocket, false);
        log.warn((Object)"  Ok");
        log.warn((Object)"  Sending login information...");
        this.serverChannel.send(new GridMessageBeginSession(((GridNodeGenericConfig)this.getNodeConfig()).getSessionName(), gCfg.getServerPassword()));
        log.warn((Object)"  Ok");
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"End start()");
        }
    }

    public void stop() throws Exception {
        block7: {
            block6: {
                if (logDetail.isDebugEnabled()) {
                    logDetail.debug((Object)"Start stop()");
                }
                try {
                    this.serverChannel.send(new GridMessageEndSession());
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug((Object)"End session failed", (Throwable)ex);
                }
            }
            try {
                this.serverChannel.close();
            }
            catch (Exception ex) {
                if (!logDetail.isDebugEnabled()) break block7;
                logDetail.debug((Object)"Close server channel connection failed", (Throwable)ex);
            }
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"End stop()");
        }
    }

    public GridMessageChannel getGridMessageChannel() {
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)"Start getGridMessageChannel()");
        }
        if (logDetail.isDebugEnabled()) {
            logDetail.debug((Object)("End getGridMessageChannel(" + this.serverChannel + ")"));
        }
        return this.serverChannel;
    }
}

