/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import org.webswing.model.s2c.ComponentTreeMsg;
import org.webswing.toolkit.util.Services;
import org.webswing.toolkit.util.Util;

public class ToolkitUtil {
    public static List<ComponentTreeMsg> getComponentTree() {
        ArrayList<ComponentTreeMsg> tree = new ArrayList<ComponentTreeMsg>();
        tree.addAll(ToolkitUtil.getComponentTree(null));
        if (Services.getToolkitFXService() != null) {
            tree.addAll(ToolkitUtil.getNodeTree());
        }
        return tree;
    }

    public static List<ComponentTreeMsg> getComponentTree(Component root) {
        ArrayList<ComponentTreeMsg> componentTree = new ArrayList<ComponentTreeMsg>();
        if (root == null) {
            Window[] windows;
            for (Window w : windows = Util.getAllWindows()) {
                componentTree.add(ToolkitUtil.createComponentTreeMsg(w));
            }
        } else {
            componentTree.add(ToolkitUtil.createComponentTreeMsg(root));
        }
        return componentTree;
    }

    public static List<ComponentTreeMsg> getNodeTree() {
        return ToolkitUtil.getNodeTree(null);
    }

    public static List<ComponentTreeMsg> getNodeTree(Object node) {
        return Services.getToolkitFXService().requestNodeTree(node);
    }

    public static String getComponentType(Object o) {
        Class<?> cls = o.getClass();
        if (cls.isAnonymousClass()) {
            cls = cls.getInterfaces().length == 0 ? cls.getSuperclass() : cls.getInterfaces()[0];
        }
        return cls.getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ComponentTreeMsg createComponentTreeMsg(Component c) {
        ComponentTreeMsg msg = ComponentTreeMsg.fromComponent(c);
        if (ToolkitUtil.getComponentType(c).equalsIgnoreCase("JFXPanel")) {
            msg.setComponents(ToolkitUtil.getNodeTree(c));
        } else if (c instanceof Container) {
            Object object = c.getTreeLock();
            synchronized (object) {
                Component[] children = ((Container)c).getComponents();
                if (children != null && children.length > 0) {
                    for (Component child : children) {
                        msg.addChildComponent(ToolkitUtil.createComponentTreeMsg(child));
                    }
                }
            }
        }
        return msg;
    }
}

