/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit.jslink;

import java.applet.Applet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import org.webswing.model.jslink.JSObjectMsg;
import org.webswing.model.jslink.JavaEvalRequestMsgIn;
import org.webswing.model.s2c.AppFrameMsgOut;
import org.webswing.toolkit.util.DeamonThreadFactory;
import org.webswing.toolkit.util.JsLinkUtil;
import org.webswing.toolkit.util.Services;
import org.webswing.toolkit.util.WeakValueHashMap;

public class WebJSObject
extends JSObject {
    private static final Map<String, WeakReference<JSObjectMsg>> jsGarbageCollectionMap = new HashMap<String, WeakReference<JSObjectMsg>>();
    private static final WeakValueHashMap<String, Object> javaReferences = new WeakValueHashMap();
    private static boolean jsLinkAllowed = Boolean.getBoolean("webswing.allowJsLink");
    private static String jsLinkWhitelistProp = System.getProperty("webswing.jsLinkWhitelist", "");
    private static List<String> jsLinkWhitelist;
    private static ScheduledExecutorService javaEvalThread;
    private JSObjectMsg jsThis;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebJSObject(JSObjectMsg jsThis) {
        this.jsThis = jsThis;
        if (jsThis != null) {
            Map<String, WeakReference<JSObjectMsg>> map = jsGarbageCollectionMap;
            synchronized (map) {
                jsGarbageCollectionMap.put(jsThis.getId() + "", new WeakReference<JSObjectMsg>(jsThis));
            }
        }
    }

    @Override
    public Object call(String methodName, Object[] args) throws JSException {
        AppFrameMsgOut msg = JsLinkUtil.generateCallRequest(this.jsThis, methodName, args);
        return WebJSObject.sendJsRequest(msg);
    }

    @Override
    public Object eval(String s) throws JSException {
        AppFrameMsgOut msg = JsLinkUtil.generateEvalRequest(this.jsThis, s);
        return WebJSObject.sendJsRequest(msg);
    }

    @Override
    public Object getMember(String name) throws JSException {
        AppFrameMsgOut msg = JsLinkUtil.generateGetMemberRequest(this.jsThis, name);
        return WebJSObject.sendJsRequest(msg);
    }

    @Override
    public void setMember(String name, Object value) throws JSException {
        AppFrameMsgOut msg = JsLinkUtil.generateSetMemberRequest(this.jsThis, name, value);
        WebJSObject.sendJsRequest(msg);
    }

    @Override
    public void removeMember(String name) throws JSException {
        AppFrameMsgOut msg = JsLinkUtil.generateRemoveMemberRequest(this.jsThis, name);
        WebJSObject.sendJsRequest(msg);
    }

    @Override
    public Object getSlot(int index) throws JSException {
        AppFrameMsgOut msg = JsLinkUtil.generateGetSlotRequest(this.jsThis, index);
        return WebJSObject.sendJsRequest(msg);
    }

    @Override
    public void setSlot(int index, Object value) throws JSException {
        AppFrameMsgOut msg = JsLinkUtil.generateSetSlotRequest(this.jsThis, index, value);
        WebJSObject.sendJsRequest(msg);
    }

    public static JSObject getWindow(Applet paramApplet) throws JSException {
        return new WebJSObject(null);
    }

    private static Object sendJsRequest(AppFrameMsgOut msg) {
        try {
            Object result = Services.getConnectionService().sendObjectSync(msg, msg.getJsRequest().getCorrelationId());
            Object parsedResult = JsLinkUtil.parseResponse(result);
            return parsedResult;
        }
        catch (TimeoutException e) {
            throw new JSException(e.getMessage());
        }
        catch (Exception e) {
            throw new JSException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getGarbage() {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, WeakReference<JSObjectMsg>> map = jsGarbageCollectionMap;
        synchronized (map) {
            Iterator<String> i = jsGarbageCollectionMap.keySet().iterator();
            while (i.hasNext()) {
                String key = i.next();
                if (!jsGarbageCollectionMap.get(key).isEnqueued()) continue;
                result.add(key);
                i.remove();
            }
        }
        return result;
    }

    public JSObjectMsg getThisId() {
        return this.jsThis;
    }

    public static String createJavaReference(Object arg) {
        return WebJSObject.createJavaReference(arg, UUID.randomUUID().toString());
    }

    public static String createJavaReference(Object arg, String newId) {
        if (javaReferences.containsValue(arg)) {
            String id = null;
            for (String key : javaReferences.keySet()) {
                if (javaReferences.get(key) != arg) continue;
                id = key;
            }
            return id;
        }
        String id = newId;
        javaReferences.put(id, arg);
        return id;
    }

    public static Object getJavaReference(String id) {
        Object o = javaReferences.get(id);
        return o;
    }

    public static Future<?> evaluateJava(final JavaEvalRequestMsgIn javaReq) {
        return javaEvalThread.submit(new Runnable(){

            @Override
            public void run() {
                if (jsLinkAllowed) {
                    Object javaRef = javaReferences.get(javaReq.getObjectId());
                    AppFrameMsgOut result = JsLinkUtil.callMatchingMethod(javaReq, javaRef, jsLinkWhitelist);
                    Services.getConnectionService().sendObject(result);
                } else {
                    AppFrameMsgOut result = JsLinkUtil.getErrorResponse(javaReq, "JsLink is not allowed for this application. Set the 'allowJsLink' to true in webswing.config to enable it.");
                    Services.getConnectionService().sendObject(result);
                }
            }
        });
    }

    static {
        javaEvalThread = Executors.newSingleThreadScheduledExecutor(DeamonThreadFactory.getInstance("Webswing JsLink Processor"));
        jsLinkWhitelist = new ArrayList<String>();
        jsLinkWhitelist = Arrays.asList(jsLinkWhitelistProp.split(","));
    }
}

