/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit.extra;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.webswing.toolkit.WebToolkit;
import org.webswing.toolkit.WebWindowPeer;
import org.webswing.toolkit.extra.WindowManager;
import org.webswing.toolkit.util.Logger;
import org.webswing.toolkit.util.Util;

public class WindowHierarchyTree {
    private Map<Window, WindowHierarchyNode> lookup = new HashMap<Window, WindowHierarchyNode>();
    private LinkedList<WindowHierarchyNode> rootWindowNodes = new LinkedList();
    private LinkedList<WindowHierarchyNode> alwaysOnTopZOrder = new LinkedList();
    private LinkedList<WindowHierarchyNode> regularZOrder = new LinkedList();
    private LinkedList<WindowHierarchyNode> zOrder = new LinkedList();
    private ArrayDeque<Window> modalsStack = new ArrayDeque();

    protected void bringToFront(Window w) {
        if (w != null && !w.isEnabled()) {
            return;
        }
        if (this.lookup.containsKey(w)) {
            WindowHierarchyNode node = this.lookup.get(w);
            if (node.getParent() == null) {
                if (this.rootWindowNodes.indexOf(node) != 0) {
                    this.rootWindowNodes.remove(node);
                    this.rootWindowNodes.addFirst(node);
                }
                this.rebuildZOrder(true);
            } else {
                LinkedList<WindowHierarchyNode> parentChildren = node.getParent().getChildren();
                if (parentChildren.indexOf(node) != 0) {
                    parentChildren.remove(node);
                    parentChildren.addFirst(node);
                }
                this.bringToFront(node.getParent().getW());
            }
        } else {
            Logger.error("Window not registered. Not able to bring to front.", w);
        }
    }

    protected void addWindow(Window window) {
        if (!this.lookup.containsKey(window)) {
            WindowHierarchyNode parentNode = this.lookup.get(window.getParent());
            if (window instanceof Dialog && ((Dialog)window).isModal()) {
                this.modalsStack.push(window);
            }
            if (window.getParent() == null || parentNode == null) {
                WindowHierarchyNode thisNode = new WindowHierarchyNode(window);
                this.lookup.put(window, thisNode);
                this.rootWindowNodes.add(thisNode);
                this.rebuildZOrder(false);
            } else {
                WindowHierarchyNode thisNode = new WindowHierarchyNode(window, parentNode);
                this.lookup.put(window, thisNode);
                parentNode.addChild(thisNode);
                this.rebuildZOrder(false);
            }
            window.repaint();
        } else {
            Logger.error("Window already registered in hierarchy tree", window);
        }
    }

    protected void removeWindow(Window window) {
        if (this.lookup.containsKey(window)) {
            WindowHierarchyNode node = this.lookup.get(window);
            int index = this.zOrder.indexOf(node);
            this.modalsStack.remove(window);
            Window successor = this.findSuccessor(window);
            this.lookup.remove(window);
            WindowHierarchyNode parent = node.getParent();
            LinkedList<WindowHierarchyNode> children = node.getChildren();
            if (parent != null) {
                parent.getChildren().remove(node);
                for (WindowHierarchyNode child : children) {
                    child.setParent(parent);
                }
                parent.getChildren().addAll(children);
            } else {
                this.rootWindowNodes.remove(node);
                this.rootWindowNodes.addAll(children);
                for (WindowHierarchyNode child : children) {
                    child.setParent(null);
                }
            }
            this.rebuildZOrder(false);
            this.requestRepaintUnderlying(index, window.getBounds());
            if (successor != null && Util.getWebToolkit().getWindowManager().isWindowActive(window)) {
                WindowManager.getInstance().activateWindow(successor);
            }
        } else {
            Logger.debug("Window not registered. Could not remove.", window);
        }
    }

    private Window findSuccessor(Window window) {
        Window modalWindow;
        WindowHierarchyNode node = this.lookup.get(window);
        if (this.modalsStack.size() > 0 && (modalWindow = this.modalsStack.peek()) instanceof Dialog && !((Dialog)modalWindow).getModalityType().equals((Object)Dialog.ModalityType.DOCUMENT_MODAL)) {
            return modalWindow;
        }
        if (node.getParent() != null) {
            return node.getParent().getW();
        }
        int index = this.rootWindowNodes.indexOf(node);
        if (this.rootWindowNodes.size() > index + 1) {
            return this.rootWindowNodes.get(index + 1).getW();
        }
        return null;
    }

    private void rebuildZOrder(boolean repaintChildren) {
        WindowHierarchyNode lastWindowAlwaysOnTop = this.alwaysOnTopZOrder.size() > 0 ? this.alwaysOnTopZOrder.get(0) : null;
        WindowHierarchyNode lastWindowRegular = this.regularZOrder.size() > 0 ? this.regularZOrder.get(0) : null;
        this.alwaysOnTopZOrder.clear();
        this.regularZOrder.clear();
        this.zOrder.clear();
        for (WindowHierarchyNode window : this.rootWindowNodes) {
            this.buildAlwaysOnTopZOrderList(this.alwaysOnTopZOrder, false, window);
        }
        for (WindowHierarchyNode window : this.rootWindowNodes) {
            this.buildRegularZOrderList(this.regularZOrder, window);
        }
        this.zOrder.addAll(this.alwaysOnTopZOrder);
        this.zOrder.addAll(this.regularZOrder);
        if (repaintChildren) {
            this.repaintChildren(lastWindowAlwaysOnTop, this.alwaysOnTopZOrder);
            this.repaintChildren(lastWindowRegular, this.regularZOrder);
        }
    }

    private void repaintChildren(WindowHierarchyNode lastWindow, LinkedList<WindowHierarchyNode> zOrder) {
        if (lastWindow != null) {
            WindowHierarchyNode node;
            Iterator iterator = zOrder.iterator();
            while (iterator.hasNext() && (node = (WindowHierarchyNode)iterator.next()) != lastWindow) {
                Util.getWebToolkit().getPaintDispatcher().notifyWindowZOrderChanged(node.getW());
            }
        }
    }

    private void buildAlwaysOnTopZOrderList(List<WindowHierarchyNode> resultList, boolean inheritedAlwaysOnTop, WindowHierarchyNode currentNode) {
        for (WindowHierarchyNode window : currentNode.getChildren()) {
            this.buildAlwaysOnTopZOrderList(resultList, inheritedAlwaysOnTop, window);
        }
        if (currentNode.getW().isAlwaysOnTop() || inheritedAlwaysOnTop) {
            resultList.add(currentNode);
            inheritedAlwaysOnTop = true;
        }
    }

    private void buildRegularZOrderList(List<WindowHierarchyNode> resultList, WindowHierarchyNode currentNode) {
        if (!currentNode.getW().isAlwaysOnTop()) {
            for (WindowHierarchyNode window : currentNode.getChildren()) {
                this.buildRegularZOrderList(resultList, window);
            }
            resultList.add(currentNode);
        }
    }

    protected boolean contains(Window w) {
        return this.lookup.containsKey(w);
    }

    protected Window getVisibleWindowOnPosition(int x, int y) {
        List clonedZOrder = (List)this.zOrder.clone();
        for (WindowHierarchyNode w : clonedZOrder) {
            if (!w.getW().getBounds().contains(x, y)) continue;
            return w.getW();
        }
        return null;
    }

    protected Map<String, List<Rectangle>> extractNonVisibleAreas() {
        HashMap<String, List<Rectangle>> result = new HashMap<String, List<Rectangle>>();
        if (this.zOrder.size() > 0) {
            for (int i = 1; i < this.zOrder.size() + 1; ++i) {
                String id = i == this.zOrder.size() ? "BG" : ((WebWindowPeer)WebToolkit.targetToPeer(this.zOrder.get(i).getW())).getGuid();
                Rectangle current = i == this.zOrder.size() ? new Rectangle(Util.getWebToolkit().getScreenSize()) : this.zOrder.get(i).getW().getBounds();
                ArrayList<Rectangle> currentDifferences = new ArrayList<Rectangle>();
                for (int j = i - 1; j >= 0; --j) {
                    Rectangle previousBounds = this.zOrder.get(j).getW().getBounds();
                    Rectangle intersect = SwingUtilities.computeIntersection(current.x, current.y, current.width, current.height, (Rectangle)previousBounds.clone());
                    if (intersect.isEmpty()) continue;
                    intersect.setLocation(intersect.x - current.x, intersect.y - current.y);
                    currentDifferences.add(intersect);
                }
                if (currentDifferences.size() == 0) continue;
                result.put(id, currentDifferences);
            }
        }
        return result;
    }

    public List<String> getZOrder() {
        ArrayList<String> zorder = new ArrayList<String>();
        for (int i = 0; i < this.zOrder.size(); ++i) {
            String id = ((WebWindowPeer)WebToolkit.targetToPeer(this.zOrder.get(i).getW())).getGuid();
            zorder.add(id);
        }
        return zorder;
    }

    public void requestRepaintAfterMove(Window w, Rectangle originalPosition) {
        this.requestRepaintUnderlying(this.zOrder.indexOf(this.lookup.get(w)) + 1, originalPosition);
        Rectangle newPosition = w.getBounds();
        if (originalPosition.x != newPosition.x || originalPosition.y != newPosition.y) {
            Util.getWebToolkit().getPaintDispatcher().notifyWindowMoved(w, this.zOrder.indexOf(this.lookup.get(w)), originalPosition, newPosition);
        }
    }

    private void requestRepaintUnderlying(int index, Rectangle bounds) {
        for (int i = index; i < this.zOrder.size(); ++i) {
            Window underlying = this.zOrder.get(i).getW();
            Rectangle uBounds = underlying.getBounds();
            Rectangle boundsCopy = new Rectangle(bounds);
            SwingUtilities.computeIntersection(uBounds.x, uBounds.y, uBounds.width, uBounds.height, boundsCopy);
            WebWindowPeer peer = (WebWindowPeer)WebToolkit.targetToPeer(underlying);
            Util.getWebToolkit().getPaintDispatcher().notifyWindowAreaVisible(peer.getGuid(), new Rectangle(boundsCopy.x - uBounds.x, boundsCopy.y - uBounds.y, boundsCopy.width, boundsCopy.height));
        }
        Rectangle boundsCopy = new Rectangle(bounds);
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        SwingUtilities.computeIntersection(0, 0, screensize.width, screensize.height, boundsCopy);
        Util.getWebToolkit().getPaintDispatcher().notifyBackgroundAreaVisible(boundsCopy);
    }

    protected boolean isInSameModalBranch(Window active, Window current) {
        if (active == null) {
            return true;
        }
        Window modalParentofActive = this.getModalParent(active);
        Window modalParentofCurrent = this.getModalParent(current);
        boolean isActiveParentOfCurrent = this.isParent(modalParentofActive, modalParentofCurrent);
        return modalParentofActive == null || modalParentofActive == modalParentofCurrent || current == modalParentofCurrent && isActiveParentOfCurrent;
    }

    public boolean isParent(Window parent, Window child) {
        if (parent != null && child != null) {
            if (child.getParent() != null) {
                return child.getParent() == parent || this.isParent(parent, (Window)child.getParent());
            }
            return false;
        }
        return false;
    }

    private Window getModalParent(Window w) {
        WindowHierarchyNode window = this.lookup.get(w);
        if (window != null) {
            if (window.getW() instanceof Dialog && ((Dialog)window.getW()).isModal()) {
                return window.getW();
            }
            if (window.getW().getParent() != null) {
                return this.getModalParent((Window)window.getW().getParent());
            }
            return null;
        }
        return null;
    }

    public boolean isInModalBranch(Window w) {
        return this.getModalParent(w) != null;
    }

    public boolean isInFullModalBranch(Window w) {
        WindowHierarchyNode window = this.lookup.get(w);
        if (window != null) {
            if (window.getW() instanceof Dialog && ((Dialog)window.getW()).isModal() && ((Dialog)window.getW()).getModalityType() != Dialog.ModalityType.DOCUMENT_MODAL) {
                return true;
            }
            if (window.getW().getParent() != null) {
                return this.isInFullModalBranch((Window)window.getW().getParent());
            }
            return false;
        }
        return false;
    }

    private class WindowHierarchyNode {
        private Window w;
        private WindowHierarchyNode parent;
        private LinkedList<WindowHierarchyNode> children = new LinkedList();

        public WindowHierarchyNode(Window w) {
            this.w = w;
        }

        public WindowHierarchyNode(Window w, WindowHierarchyNode parent) {
            this.w = w;
            this.parent = parent;
        }

        public Window getW() {
            return this.w;
        }

        public void addChild(WindowHierarchyNode child) {
            this.children.add(child);
        }

        public WindowHierarchyNode getParent() {
            return this.parent;
        }

        public void setParent(WindowHierarchyNode parent) {
            this.parent = parent;
        }

        public LinkedList<WindowHierarchyNode> getChildren() {
            return this.children;
        }

        public String toString() {
            return this.w.toString();
        }
    }
}

