/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit;

import java.awt.HeadlessException;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.webswing.toolkit.WebPrintService;
import org.webswing.toolkit.WebPrinterJobWrapper;
import org.webswing.toolkit.util.Logger;
import org.webswing.toolkit.util.Services;
import org.webswing.toolkit.util.Util;

public class WebPrinterJob
extends PrinterJob {
    private PrintRequestAttributeSet attribs = new HashPrintRequestAttributeSet();
    private Printable printable;
    private Pageable pageable;
    private PrintService service = WebPrintService.getService();

    @Override
    public void setPrintable(Printable painter) {
        this.printable = painter;
    }

    @Override
    public void setPrintable(Printable painter, PageFormat format) {
        this.setPrintable(painter);
    }

    @Override
    public void setPageable(Pageable document) throws NullPointerException {
        this.pageable = document;
    }

    @Override
    public boolean printDialog() throws HeadlessException {
        return true;
    }

    @Override
    public PageFormat pageDialog(PageFormat page) throws HeadlessException {
        return page;
    }

    @Override
    public PageFormat defaultPage(PageFormat page) {
        return this.defaultPage();
    }

    @Override
    public PageFormat defaultPage() {
        HashPrintRequestAttributeSet attrs = new HashPrintRequestAttributeSet();
        attrs.add((OrientationRequested)this.service.getDefaultAttributeValue(OrientationRequested.class));
        attrs.add((MediaSizeName)this.service.getDefaultAttributeValue(Media.class));
        attrs.add((MediaPrintableArea)this.service.getDefaultAttributeValue(MediaPrintableArea.class));
        return WebPrinterJobWrapper.toPageFormat(attrs);
    }

    @Override
    public PageFormat validatePage(PageFormat page) {
        return page;
    }

    @Override
    public void print(PrintRequestAttributeSet attributes) throws PrinterException {
        this.attribs.addAll(attributes);
        this.print();
    }

    @Override
    public void print() throws PrinterException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Services.getPdfService().printToPDF(out, this.pageable, this.printable, this.attribs);
            this.servePDF(out);
        }
        catch (IOException e) {
            Logger.error("IOException while printing to PDF!", e);
        }
    }

    private void servePDF(ByteArrayOutputStream out) {
        String tempDir = System.getProperty("webswing.tempDirPath");
        String id = UUID.randomUUID().toString();
        File f = new File(URI.create(tempDir + "/" + id + ".pdf"));
        try {
            FileOutputStream output = new FileOutputStream(f);
            out.writeTo(output);
            output.close();
        }
        catch (Exception e) {
            Logger.error("Failed to save print pdf file to location " + f.getAbsolutePath(), e);
        }
        Util.getWebToolkit().getPaintDispatcher().notifyPrintPdfFile(id, f);
    }

    @Override
    public void setCopies(int copies) {
    }

    @Override
    public int getCopies() {
        return 1;
    }

    @Override
    public String getUserName() {
        return "";
    }

    @Override
    public void setJobName(String jobName) {
    }

    @Override
    public String getJobName() {
        return "";
    }

    @Override
    public void cancel() {
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public PrintService getPrintService() {
        return this.service;
    }

    @Override
    public void setPrintService(PrintService service) throws PrinterException {
    }
}

