/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import sun.awt.dnd.SunDragSourceContextPeer;

public class WebMouseDragGestureRecognizer
extends MouseDragGestureRecognizer {
    private static final long serialVersionUID = 2473988169935151977L;
    protected static int motionThreshold;

    protected WebMouseDragGestureRecognizer(DragSource ds, Component c, int act, DragGestureListener dgl) {
        super(ds, c, act, dgl);
    }

    protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int i = mouseEvent.getModifiersEx();
        int j = i & 0x1C00;
        if (j != 1024 && j != 2048 && j != 4096) {
            return 0;
        }
        return SunDragSourceContextPeer.convertModifiersToDropAction(i, this.getSourceActions());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.events.clear();
        if (this.mapDragOperationFromModifiers(mouseEvent) != 0) {
            try {
                motionThreshold = DragSource.getDragThreshold();
            }
            catch (Exception localException) {
                motionThreshold = 5;
            }
            this.appendEvent(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.events.clear();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.events.clear();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        int i;
        if (!this.events.isEmpty() && (i = this.mapDragOperationFromModifiers(mouseEvent)) == 0) {
            this.events.clear();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.events.isEmpty()) {
            int i = this.mapDragOperationFromModifiers(mouseEvent);
            if (i == 0) {
                return;
            }
            MouseEvent localMouseEvent = (MouseEvent)this.events.get(0);
            Point localPoint1 = localMouseEvent.getPoint();
            Point localPoint2 = mouseEvent.getPoint();
            int j = Math.abs(localPoint1.x - localPoint2.x);
            int k = Math.abs(localPoint1.y - localPoint2.y);
            if (j > motionThreshold || k > motionThreshold) {
                this.fireDragGestureRecognized(i, ((MouseEvent)this.getTriggerEvent()).getPoint());
            } else {
                this.appendEvent(mouseEvent);
            }
        }
    }
}

