/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit;

import java.awt.Desktop;
import java.awt.peer.DesktopPeer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.webswing.toolkit.util.Logger;
import org.webswing.toolkit.util.Util;

public class WebDesktopPeer
implements DesktopPeer {
    public WebDesktopPeer(Desktop d) {
    }

    @Override
    public boolean isSupported(Desktop.Action action) {
        switch (action) {
            case BROWSE: 
            case MAIL: 
            case EDIT: 
            case OPEN: 
            case PRINT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void open(File file) throws IOException {
        Logger.info("WebDesktopPeer:open", file);
        this.sendFile(file, false);
    }

    @Override
    public void edit(File file) throws IOException {
        Logger.info("WebDesktopPeer:edit", file);
        this.sendFile(file, false);
    }

    @Override
    public void print(File file) throws IOException {
        Logger.info("WebDesktopPeer:print", file);
        this.sendFile(file, true);
    }

    private void sendFile(File file, boolean preview) {
        Util.getWebToolkit().getPaintDispatcher().notifyFileRequested(file, preview);
    }

    @Override
    public void mail(URI mailtoURL) throws IOException {
        Util.getWebToolkit().getPaintDispatcher().notifyOpenLinkAction(mailtoURL);
    }

    @Override
    public void browse(URI url) throws IOException {
        Util.getWebToolkit().getPaintDispatcher().notifyOpenLinkAction(url);
    }
}

