/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.toolkit;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import org.webswing.toolkit.util.Util;

public class WebCursor
extends Cursor {
    private static final long serialVersionUID = -7369225579337480240L;
    private Image image;
    private Point hotSpot;

    public WebCursor(Image cursor, Point hotSpot, String name) {
        super(name);
        this.image = cursor;
        this.hotSpot = hotSpot;
    }

    public BufferedImage getImage() {
        if (this.image instanceof BufferedImage) {
            return (BufferedImage)this.image;
        }
        Util.waitForImage(this.image);
        BufferedImage bimg = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), 2);
        Graphics g = bimg.getGraphics();
        g.drawImage(this.image, 0, 0, null);
        g.dispose();
        this.image = bimg;
        return bimg;
    }

    public Point getHotSpot() {
        return this.hotSpot;
    }
}

