/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.model.s2c;

import java.awt.Component;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import org.webswing.model.Msg;
import org.webswing.toolkit.util.ToolkitUtil;

public class ComponentTreeMsg
implements Msg {
    private static final long serialVersionUID = -8433885502194335248L;
    private String componentType;
    private String name;
    private String value;
    private int screenX;
    private int screenY;
    private int width;
    private int height;
    private boolean enabled;
    private boolean visible;
    private Boolean selected;
    private boolean hidden;
    private List<ComponentTreeMsg> components;

    public static ComponentTreeMsg fromComponent(Component c) {
        JComboBox combo;
        ComponentTreeMsg msg = new ComponentTreeMsg();
        msg.setComponentType(ToolkitUtil.getComponentType(c));
        msg.setName(c.getName());
        if (c instanceof Frame) {
            msg.setValue(((Frame)c).getTitle());
        }
        if (c instanceof AbstractButton) {
            msg.setValue(((AbstractButton)c).getText());
        }
        if (c instanceof JLabel) {
            msg.setValue(((JLabel)c).getText());
        }
        if (c instanceof JTextComponent) {
            msg.setValue(((JTextComponent)c).getText());
        }
        if (c instanceof JToggleButton) {
            msg.setSelected(((JToggleButton)c).isSelected());
        }
        if (c instanceof JComboBox && (combo = (JComboBox)c).getSelectedItem() != null) {
            msg.setValue(combo.getSelectedItem().toString());
        }
        if (c instanceof JSlider) {
            msg.setValue(((JSlider)c).getValue() + "");
        }
        try {
            msg.setScreenX(c.getLocationOnScreen().x);
            msg.setScreenY(c.getLocationOnScreen().y);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        msg.setWidth(c.getWidth());
        msg.setHeight(c.getHeight());
        msg.setEnabled(c.isEnabled());
        msg.setVisible(c.isVisible());
        return msg;
    }

    public void addChildComponent(ComponentTreeMsg child) {
        if (this.components == null) {
            this.components = new ArrayList<ComponentTreeMsg>();
        }
        this.components.add(child);
    }

    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getScreenX() {
        return this.screenX;
    }

    public void setScreenX(int screenX) {
        this.screenX = screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public void setScreenY(int screenY) {
        this.screenY = screenY;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public List<ComponentTreeMsg> getComponents() {
        return this.components;
    }

    public void setComponents(List<ComponentTreeMsg> components) {
        this.components = components;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean getSelected() {
        return this.selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }
}

