/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.dispatch;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import netscape.javascript.JSObject;
import org.webswing.audio.AudioClip;
import org.webswing.dispatch.AbstractEventDispatcher;
import org.webswing.dispatch.PaintDispatcher;
import org.webswing.dispatch.WebPaintDispatcher;
import org.webswing.model.c2s.ActionEventMsgIn;
import org.webswing.model.c2s.AudioEventMsgIn;
import org.webswing.model.c2s.ConnectionHandshakeMsgIn;
import org.webswing.model.c2s.CopyEventMsgIn;
import org.webswing.model.c2s.FilesSelectedEventMsgIn;
import org.webswing.model.c2s.KeyboardEventMsgIn;
import org.webswing.model.c2s.MouseEventMsgIn;
import org.webswing.model.c2s.PasteEventMsgIn;
import org.webswing.model.c2s.SimpleEventMsgIn;
import org.webswing.model.c2s.UploadEventMsgIn;
import org.webswing.model.c2s.WindowEventMsgIn;
import org.webswing.model.c2s.WindowFocusMsgIn;
import org.webswing.model.jslink.JSObjectMsg;
import org.webswing.model.s2c.FileDialogEventMsg;
import org.webswing.toolkit.FocusEventCause;
import org.webswing.toolkit.WebClipboard;
import org.webswing.toolkit.WebClipboardTransferable;
import org.webswing.toolkit.WebWindowPeer;
import org.webswing.toolkit.api.component.HtmlPanel;
import org.webswing.toolkit.api.lifecycle.ShutdownReason;
import org.webswing.toolkit.extra.WindowManager;
import org.webswing.toolkit.jslink.WebJSObject;
import org.webswing.toolkit.util.Logger;
import org.webswing.toolkit.util.Services;
import org.webswing.toolkit.util.Util;

public class WebEventDispatcher
extends AbstractEventDispatcher {
    @Override
    protected void dispatchMessage(SimpleEventMsgIn message) {
        Logger.debug("WebEventDispatcher.dispatchMessage", message);
        switch (message.getType()) {
            case killSwing: {
                Logger.info("Received kill signal from Admin console. Application shutting down.", new Object[0]);
                Services.getConnectionService().scheduleShutdown(ShutdownReason.Admin);
                break;
            }
            case deleteFile: {
                Util.getWebToolkit().getPaintDispatcher().notifyDeleteSelectedFile();
                break;
            }
            case downloadFile: {
                Util.getWebToolkit().getPaintDispatcher().notifyDownloadSelectedFile();
                break;
            }
            case cancelFileSelection: {
                JFileChooser dialog = Util.getWebToolkit().getPaintDispatcher().getFileChooserDialog();
                if (dialog == null) break;
                dialog.cancelSelection();
                break;
            }
            case paintAck: {
                Util.getWebToolkit().getPaintDispatcher().clientReadyToReceive();
                break;
            }
            case repaint: {
                Util.getWebToolkit().getPaintDispatcher().notifyWindowRepaintAll();
                break;
            }
            case unload: {
                boolean instantExit;
                boolean bl = instantExit = Integer.parseInt(System.getProperty("webswing.sessionTimeoutSec", "300")) == 0;
                if (!instantExit) break;
                Logger.warn("Exiting Application. Client has disconnected from web session. (swingSessionTimeout setting is 0 or less)", new Object[0]);
                Services.getConnectionService().scheduleShutdown(ShutdownReason.Inactivity);
                break;
            }
            case hb: {
                break;
            }
            case requestComponentTree: {
                if (!Util.isTestMode()) break;
                Util.getWebToolkit().getPaintDispatcher().notifyComponentTreeRequested();
                break;
            }
            case requestWindowSwitchList: {
                Util.getWebToolkit().getPaintDispatcher().notifyWindowSwitchList();
            }
        }
    }

    @Override
    protected void dispatchKeyboardEvent(KeyboardEventMsgIn event) {
        Window w = Util.getWebToolkit().getWindowManager().getActiveWindow();
        if (w != null) {
            Component src;
            long when = System.currentTimeMillis();
            int modifiers = Util.getKeyModifiersAWTFlag(event);
            int type = Util.getKeyType(event.getType());
            char character = Util.getKeyCharacter(event);
            Component component = src = w.getFocusOwner() == null ? w : w.getFocusOwner();
            if (event.getKeycode() == 13) {
                event.setKeycode(10);
                event.setCharacter(10);
                character = '\n';
            } else if (CONVERTED_KEY_CODES.containsKey(event.getKeycode()) && type != 400) {
                int converted = (Integer)CONVERTED_KEY_CODES.get(event.getKeycode());
                event.setKeycode(converted);
                character = (char)converted;
            } else if (NON_STANDARD_KEY_CODES.contains(event.getKeycode())) {
                event.setKeycode(0);
            }
            if (event.getType() == KeyboardEventMsgIn.KeyEventType.keydown) {
                this.getReleaseCharMap().put(event.getKeycode(), event.getCharacter());
            }
            if (event.getType() == KeyboardEventMsgIn.KeyEventType.keyup) {
                Integer c = this.getReleaseCharMap().get(event.getKeycode());
                character = (char)(c == null ? event.getCharacter() : c.intValue());
            }
            if (type == 400) {
                KeyEvent e = new KeyEvent(src, 400, when, modifiers, 0, (char)event.getCharacter());
                this.dispatchKeyEventInSwing(w, e);
            } else {
                AWTEvent e = Util.createKeyEvent(src, type, when, modifiers, event.getKeycode(), character, 1);
                this.dispatchKeyEventInSwing(w, e);
                if (!(event.getKeycode() != 32 && event.getKeycode() != 9 || event.getType() != KeyboardEventMsgIn.KeyEventType.keydown || event.isCtrl())) {
                    event.setType(KeyboardEventMsgIn.KeyEventType.keypress);
                    this.dispatchKeyboardEvent(event);
                }
            }
        }
    }

    @Override
    protected void windowFocusEvent(WindowFocusMsgIn event) {
        if (event.getHtmlPanelId() != null) {
            HtmlPanel panel = Util.getWebToolkit().getPaintDispatcher().findHtmlPanelById(event.getHtmlPanelId());
            if (panel != null) {
                panel.requestFocusInWindow();
            }
        } else if (event.getWindowId() != null) {
            WindowManager.getInstance().activateWindow(Util.findWindowById(event.getWindowId()));
        }
    }

    @Override
    protected void dispatchMouseEvent(MouseEventMsgIn event) {
        Component c = null;
        boolean relatedToLastEvent = false;
        if (Util.getWebToolkit().getWindowManager().isLockedToWindowDecorationHandler()) {
            c = Util.getWebToolkit().getWindowManager().getLockedToWindow();
        } else {
            c = Util.getWebToolkit().getWindowManager().getVisibleComponentOnPosition(event.getX(), event.getY(), event.getWinId());
            if (this.relatedToLastEvent(event) && !this.isJavaFXdragStarted() && !this.isDndInProgress()) {
                c = (Component)this.getLastMouseEvent().getSource();
                relatedToLastEvent = true;
            }
        }
        if (c == null) {
            if (Util.getWebToolkit().getPaintDispatcher() != null) {
                Util.getWebToolkit().getPaintDispatcher().notifyCursorUpdate(Cursor.getPredefinedCursor(0), null, null);
            }
            this.dispatchExitEvent(System.currentTimeMillis(), 0, -1, -1, event.getX(), event.getY());
            return;
        }
        if (c.isShowing()) {
            MouseEvent e = null;
            int x = 0;
            int y = 0;
            try {
                x = (int)((double)event.getX() - c.getLocationOnScreen().getX());
                y = (int)((double)event.getY() - c.getLocationOnScreen().getY());
            }
            catch (IllegalComponentStateException e1) {
                return;
            }
            this.setLastMousePosition(event.getX(), event.getY());
            long when = System.currentTimeMillis();
            int modifiers = Util.getMouseModifiersAWTFlag(event);
            int id = 0;
            int clickcount = 0;
            int buttons = Util.getMouseButtonsAWTFlag(event.getButton());
            if (buttons != 0 && event.getType() == MouseEventMsgIn.MouseEventType.mousedown) {
                Window w = (Window)(c instanceof Window ? c : SwingUtilities.windowForComponent(c));
                Util.getWebToolkit().getWindowManager().activateWindow(w, null, x, y, false, true, FocusEventCause.MOUSE_EVENT);
            }
            switch (event.getType()) {
                case mousemove: {
                    id = event.getButtons() != 0 ? 506 : 503;
                    buttons = 0;
                    e = new MouseEvent(c, id, when, modifiers, x, y, event.getX(), event.getY(), clickcount, false, buttons);
                    this.setLastMouseEvent(e);
                    this.dispatchMouseEventInSwing(c, e, relatedToLastEvent);
                    break;
                }
                case mouseup: {
                    if (buttons == 0) break;
                    id = 502;
                    boolean popupTrigger = buttons == 3;
                    clickcount = this.computeClickCount(x, y, buttons, false, event.getTimeMilis());
                    e = new MouseEvent(c, id, when, modifiers &= 0xFFFFC3FF, x, y, event.getX(), event.getY(), clickcount, popupTrigger, buttons);
                    this.dispatchMouseEventInSwing(c, e, relatedToLastEvent);
                    if (this.isNearLastMousePressEvent(x, y)) {
                        e = new MouseEvent(c, 500, when, modifiers, x, y, event.getX(), event.getY(), clickcount, popupTrigger, buttons);
                        this.dispatchMouseEventInSwing(c, e, relatedToLastEvent);
                        this.setLastMouseEvent(e);
                        this.setLastMousePressEvent(e, event.getTimeMilis());
                        break;
                    }
                    this.setLastMouseEvent(e);
                    this.setLastMousePressEvent(e, event.getTimeMilis());
                    break;
                }
                case mousedown: {
                    if (buttons == 0) break;
                    id = 501;
                    clickcount = this.computeClickCount(x, y, buttons, true, event.getTimeMilis());
                    e = new MouseEvent(c, id, when, modifiers, x, y, event.getX(), event.getY(), clickcount, false, buttons);
                    this.dispatchMouseEventInSwing(c, e, relatedToLastEvent);
                    this.setLastMousePressEvent(e, event.getTimeMilis());
                    this.setLastMouseEvent(e);
                    break;
                }
                case mousewheel: {
                    id = 507;
                    buttons = 0;
                    modifiers = 0;
                    e = new MouseWheelEvent(c, id, when, modifiers, x, y, clickcount, false, 0, 3, event.getWheelDelta());
                    this.dispatchMouseEventInSwing(c, e, relatedToLastEvent);
                    break;
                }
            }
        }
    }

    @Override
    protected void handleActionEvent(ActionEventMsgIn event) {
        Util.getWebToolkit().processApiEvent(event);
    }

    @Override
    protected void dispatchHandshakeEvent(ConnectionHandshakeMsgIn event) {
        PaintDispatcher paintDispatcher = Util.getWebToolkit().getPaintDispatcher();
        Util.getWebToolkit().initSize(event.getDesktopWidth(), event.getDesktopHeight());
        paintDispatcher.notifyFileDialogActive();
        paintDispatcher.closePasteRequestDialog();
        Util.getWebToolkit().processApiEvent(event);
        if (System.getProperty("webswing.appletClass") != null) {
            Applet a = (Applet)WebJSObject.getJavaReference(System.getProperty("webswing.appletClass"));
            a.resize(event.getDesktopWidth(), event.getDesktopHeight());
            WebJSObject root = new WebJSObject(new JSObjectMsg("instanceObject"));
            ((JSObject)root).setMember("applet", a);
        }
        System.setProperty("webswing.touchMode", event.isTouchMode() + "");
        boolean oldAccessibility = Boolean.valueOf(System.getProperty("webswing.accessibilityEnabled", "false"));
        System.setProperty("webswing.accessibilityEnabled", event.isAccessiblityEnabled() + "");
        if (event.isAccessiblityEnabled() && !oldAccessibility) {
            paintDispatcher.notifyAccessibilityInfoUpdate();
            paintDispatcher.clearAccessibilityInfoState();
        }
    }

    @Override
    protected void handleCopyEvent(CopyEventMsgIn copy) {
        SwingUtilities.invokeLater(() -> {
            if (copy.getType() != null) {
                switch (copy.getType()) {
                    case copy: {
                        this.dispatchCopyEvent();
                        break;
                    }
                    case cut: {
                        this.dispatchCutEvent();
                        break;
                    }
                    case getFileFromClipboard: {
                        this.handleClipboardFileDownload(copy);
                    }
                }
            }
        });
    }

    protected void handleClipboardFileDownload(CopyEventMsgIn copy) {
        Clipboard clipboard;
        if (Boolean.getBoolean("webswing.allowDownload") && (clipboard = Toolkit.getDefaultToolkit().getSystemClipboard()).isDataFlavorAvailable(DataFlavor.javaFileListFlavor)) {
            try {
                List files = (List)clipboard.getData(DataFlavor.javaFileListFlavor);
                for (Object o : files) {
                    File file = (File)o;
                    if (!file.getAbsolutePath().equals(copy.getFile())) continue;
                    if (file.exists() && !file.isDirectory() && file.canRead()) {
                        Util.getWebToolkit().getPaintDispatcher().notifyFileRequested(file, false);
                        continue;
                    }
                    Logger.error("Failed to download file " + copy.getFile() + " from clipboard. File is not accessible or is a directory", new Object[0]);
                }
            }
            catch (Exception e) {
                Logger.error("Failed to download file " + copy.getFile() + " from clipboard.", e);
            }
        }
    }

    @Override
    protected void handlePasteEvent(PasteEventMsgIn paste) {
        Logger.debug("WebEventDispatcher.handlePasteEvent", paste);
        SwingUtilities.invokeLater(() -> {
            boolean clipboardRequested = Util.getWebToolkit().getPaintDispatcher().closePasteRequestDialog();
            WebClipboardTransferable transferable = new WebClipboardTransferable(paste);
            WebClipboard wc = (WebClipboard)Util.getWebToolkit().getSystemClipboard();
            wc.setBrowserClipboard(transferable);
            if (!transferable.isEmpty() && Boolean.getBoolean("webswing.allowLocalClipboard")) {
                wc.setContents((Transferable)((Object)transferable));
            }
            if (!clipboardRequested) {
                this.dispatchPasteEvent(paste.isSpecial());
            }
        });
    }

    @Override
    protected void handleFileSelectionEvent(FilesSelectedEventMsgIn e) {
        SwingUtilities.invokeLater(() -> {
            JFileChooser fc = Util.getWebToolkit().getPaintDispatcher().getFileChooserDialog();
            if (fc != null) {
                FileDialogEventMsg.FileDialogEventType fileChooserEventType = Util.getFileChooserEventType(fc);
                boolean saveMode = FileDialogEventMsg.FileDialogEventType.AutoSave == fileChooserEventType;
                fc.rescanCurrentDirectory();
                if (e.getFiles() != null && e.getFiles().size() > 0) {
                    if (fc.isMultiSelectionEnabled()) {
                        ArrayList<File> arr = new ArrayList<File>();
                        for (int i = 0; i < e.getFiles().size(); ++i) {
                            if (this.getFileUploadMap().get(e.getFiles().get(i)) != null) {
                                arr.add(new File(fc.getCurrentDirectory(), this.getFileUploadMap().get(e.getFiles().get(i))));
                                continue;
                            }
                            if (!saveMode) continue;
                            arr.add(new File(Util.getTimestampedTransferFolder("autosavemulti"), e.getFiles().get(i)));
                        }
                        fc.setSelectedFiles(arr.toArray(new File[0]));
                        Logger.info("Files selected :" + arr, new Object[0]);
                    } else {
                        if (this.getFileUploadMap().get(e.getFiles().get(0)) != null) {
                            File f = new File(fc.getCurrentDirectory(), this.getFileUploadMap().get(e.getFiles().get(0)));
                            fc.setSelectedFile(f);
                        } else if (saveMode) {
                            fc.setSelectedFile(new File(Util.getTimestampedTransferFolder("autosave"), e.getFiles().get(0)));
                        }
                        if (fc.getFileFilter() != null && fc.getSelectedFile() != null && !fc.getFileFilter().accept(fc.getSelectedFile())) {
                            for (FileFilter ff : fc.getChoosableFileFilters()) {
                                if (!ff.accept(fc.getSelectedFile())) continue;
                                fc.setFileFilter(ff);
                                break;
                            }
                        }
                        Logger.info("File selected :" + (fc.getSelectedFile() != null ? fc.getSelectedFile().getAbsoluteFile() : null), new Object[0]);
                    }
                    if (FileDialogEventMsg.FileDialogEventType.AutoUpload == fileChooserEventType || FileDialogEventMsg.FileDialogEventType.AutoSave == fileChooserEventType) {
                        fc.approveSelection();
                    }
                } else if (FileDialogEventMsg.FileDialogEventType.AutoUpload == fileChooserEventType || FileDialogEventMsg.FileDialogEventType.AutoSave == fileChooserEventType) {
                    fc.cancelSelection();
                }
            }
            this.getFileUploadMap().clear();
        });
    }

    @Override
    protected void handleUploadEvent(UploadEventMsgIn upload) {
        SwingUtilities.invokeLater(() -> {
            JFileChooser dialog = Util.getWebToolkit().getPaintDispatcher().getFileChooserDialog();
            if (dialog != null) {
                File currentDir = dialog.getCurrentDirectory();
                File tempFile = new File(upload.getTempFileLocation());
                String validfilename = Util.resolveUploadFilename(currentDir, upload.getFileName());
                if (currentDir.canWrite() && tempFile.exists()) {
                    try {
                        Services.getImageService().moveFile(tempFile, new File(currentDir, validfilename));
                        this.getFileUploadMap().put(upload.getFileName(), validfilename);
                        Logger.info("File upload notification received: " + validfilename, new Object[0]);
                    }
                    catch (IOException e) {
                        Logger.error("Error while moving uploaded file '" + validfilename + "' to target folder: ", e);
                    }
                } else {
                    Logger.error("Error while uploading file '" + validfilename + "'. " + (currentDir.canWrite() ? " Temp upload file " + tempFile.getAbsoluteFile() + " not found" : "Can not write to target folder " + currentDir.getAbsoluteFile()), new Object[0]);
                }
            } else {
                Logger.error("Error while uploading file. FileChooser dialog instance not found", new Object[0]);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleWindowEvent(WindowEventMsgIn windowUpdate) {
        block19: {
            WebWindowPeer winPeer = Util.findWindowPeerById(windowUpdate.getId());
            if (winPeer == null) {
                return;
            }
            Object object = Util.getWebToolkit().getTreeLock();
            synchronized (object) {
                Object object2 = WebPaintDispatcher.webPaintLock;
                synchronized (object2) {
                    Window win;
                    block18: {
                        win = (Window)winPeer.getTarget();
                        if (windowUpdate.getEventType() == null) break block18;
                        switch (windowUpdate.getEventType()) {
                            case close: {
                                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(win, 201));
                                break;
                            }
                            case decorate: {
                                winPeer.setUndecoratedOverride(false);
                                break;
                            }
                            case undecorate: {
                                winPeer.setUndecoratedOverride(true);
                                break;
                            }
                            case dock: {
                                winPeer.setUndocked(false);
                                break;
                            }
                            case undock: {
                                winPeer.setUndocked(true);
                                break;
                            }
                            case focus: {
                                if (!Util.isFXWindow(win)) {
                                    win.requestFocus();
                                    break;
                                }
                                break block19;
                            }
                            case maximize: {
                                if (win instanceof Frame) {
                                    Frame frame = (Frame)win;
                                    frame.setExtendedState(6);
                                    break;
                                }
                                break block19;
                            }
                        }
                        break block19;
                    }
                    SwingUtilities.invokeLater(() -> win.setBounds(windowUpdate.getX(), windowUpdate.getY(), windowUpdate.getWidth(), windowUpdate.getHeight()));
                }
            }
        }
    }

    @Override
    protected void handleAudioEvent(AudioEventMsgIn event) {
        AudioClip clip = Util.getWebToolkit().getPaintDispatcher().findAudioClip(event.getId());
        if (clip == null) {
            Logger.warn("Audio clip [" + event.getId() + "] not found. Cannot notify on playback end.", new Object[0]);
            return;
        }
        clip.notifyPlaybackStopped();
    }
}

