/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.dispatch;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.webswing.dispatch.AbstractPaintDispatcher;
import org.webswing.model.s2c.AppFrameMsgOut;
import org.webswing.toolkit.WebComponentPeer;
import org.webswing.toolkit.WebToolkit;
import org.webswing.toolkit.WebWindowPeer;
import org.webswing.toolkit.api.component.HtmlPanel;
import org.webswing.toolkit.extra.WebRepaintManager;
import org.webswing.toolkit.util.Logger;
import org.webswing.toolkit.util.Util;

public class CwmPaintDispatcher
extends AbstractPaintDispatcher {
    private Map<Container, Void> registeredContainers = new WeakHashMap<Container, Void>();
    private Map<HtmlPanel, Void> registeredHtmlPanels = new WeakHashMap<HtmlPanel, Void>();
    private RepaintManager defaultRepaintManager;
    private AtomicBoolean sendUpdateScheduled = new AtomicBoolean(false);

    public CwmPaintDispatcher() {
        Runnable readyToReceiveMonitor = () -> {
            try {
                this.isClientReadyToReceiveOrResetAfterTimedOut();
            }
            catch (Exception e) {
                Logger.error("readyToReceiveMonitor:failed", e);
            }
        };
        this.getExecutorService().scheduleWithFixedDelay(readyToReceiveMonitor, 1L, 1L, TimeUnit.SECONDS);
        PopupFactory.setSharedInstance(new PopupFactory(){

            @Override
            public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
                try {
                    Field popupTypeField = PopupFactory.class.getDeclaredField("popupType");
                    popupTypeField.setAccessible(true);
                    popupTypeField.set(this, 2);
                }
                catch (Exception e) {
                    Logger.warn("Failed to force Heavyweight popup for CWM mode.", e);
                }
                return super.getPopup(owner, contents, x, y);
            }
        });
    }

    @Override
    public void clientReadyToReceive() {
        if (!this.isClientReadyToReceive()) {
            WebRepaintManager.processDirtyComponents();
        }
        super.clientReadyToReceive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addDirtyArea(String guid, Rectangle repaintedArea, boolean reset) {
        Object object = webPaintLock;
        synchronized (object) {
            super.addDirtyArea(guid, repaintedArea, reset);
            this.scheduleSendUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSendUpdate() {
        Object object = webPaintLock;
        synchronized (object) {
            if (!this.sendUpdateScheduled.get()) {
                this.sendUpdateScheduled.set(true);
                SwingUtilities.invokeLater(this::sendUpdate);
            }
        }
    }

    @Override
    public void notifyNewDirtyRegionQueued() {
        SwingUtilities.invokeLater(() -> {
            Object object = webPaintLock;
            synchronized (object) {
                if (this.isClientReadyToReceive()) {
                    WebRepaintManager.processDirtyComponents();
                }
            }
        });
    }

    @Override
    public RepaintManager getDefaultRepaintManager() {
        if (this.defaultRepaintManager == null) {
            this.defaultRepaintManager = new RepaintManager(){

                @Override
                public void paintDirtyRegions() {
                    CwmPaintDispatcher.this.sendUpdateScheduled.set(true);
                    super.paintDirtyRegions();
                    CwmPaintDispatcher.this.sendUpdate();
                }
            };
        }
        return this.defaultRepaintManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUpdate() {
        try {
            AppFrameMsgOut json;
            Map<String, Set<Rectangle>> currentAreasToUpdate;
            Map<String, Map<Integer, BufferedImage>> windowImages = null;
            Map<String, Image> windowWebImages = null;
            Object object = Util.getWebToolkit().getTreeLock();
            synchronized (object) {
                Object object2 = webPaintLock;
                synchronized (object2) {
                    currentAreasToUpdate = this.popProcessableDirtyAreas();
                    json = Util.fillWithCompositingWindowsData(currentAreasToUpdate);
                    if (!currentAreasToUpdate.isEmpty()) {
                        if (Util.isDD()) {
                            windowWebImages = Util.extractWindowWebImages(currentAreasToUpdate.keySet(), new HashMap<String, Image>());
                        } else {
                            windowImages = Util.extractWindowImages(json, new HashMap<String, Map<Integer, BufferedImage>>());
                        }
                    }
                    this.fillFocusEvent(json);
                    this.setClientNotReady();
                    this.sendUpdateScheduled.set(false);
                }
            }
            Logger.trace("contentSender:paintJson", json);
            if (!currentAreasToUpdate.isEmpty()) {
                if (Util.isDD()) {
                    Logger.trace("contentSender:pngWebImageEncodingStart", json.hashCode());
                    Util.encodeWindowWebImages(windowWebImages, json);
                    Logger.trace("contentSender:pngWebImageEncodingDone", json.hashCode());
                } else {
                    Logger.trace("contentSender:pngEncodingStart", json.hashCode());
                    Util.encodeWindowImages(windowImages, json);
                    Logger.trace("contentSender:pngEncodingDone", json.hashCode());
                }
            }
            json.setDirectDraw(Util.isDD());
            json.setCompositingWM(Util.isCompositingWM());
            json.setSendTimestamp("" + System.currentTimeMillis());
            this.sendObject(json);
        }
        catch (Throwable e) {
            Logger.error("contentSender:error", e);
        }
    }

    @Override
    public void notifyWindowAreaRepainted(String guid, Rectangle repaintedArea) {
        this.addDirtyArea(guid, repaintedArea);
    }

    @Override
    public void notifyWindowAreaVisible(String guid, Rectangle visibleArea) {
    }

    @Override
    public void notifyWindowBoundsChanged(String guid, Rectangle newBounds) {
    }

    @Override
    public void notifyWindowActivated(Window activeWindow) {
        WebComponentPeer activeWindowPeer = (WebComponentPeer)WebToolkit.targetToPeer(activeWindow);
        activeWindowPeer.updateWindowDecorationImage();
    }

    @Override
    public void notifyWindowDeactivated(Window oldActiveWindow) {
        WebComponentPeer oldActiveWindowPeer = (WebComponentPeer)WebToolkit.targetToPeer(oldActiveWindow);
        oldActiveWindowPeer.updateWindowDecorationImage();
    }

    @Override
    public void notifyWindowZOrderChanged(Window w) {
        this.scheduleSendUpdate();
    }

    @Override
    public void notifyWindowMaximized(JFrame target) {
        this.scheduleSendUpdate();
    }

    @Override
    public void notifyBackgroundAreaVisible(Rectangle toRepaint) {
    }

    @Override
    public void notifyWindowMoved(Window w, int zIndex, Rectangle from, Rectangle to) {
        this.scheduleSendUpdate();
    }

    @Override
    public void notifyWindowDockStateChanged() {
        this.scheduleSendUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerWebContainer(Container container) {
        Object object = webPaintLock;
        synchronized (object) {
            this.registeredContainers.put(container, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Window, List<Container>> getRegisteredWebContainersAsMap() {
        Object object = webPaintLock;
        synchronized (object) {
            return Util.toWindowMapSynced(this.registeredContainers.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerHtmlPanel(HtmlPanel hp) {
        Object object = webPaintLock;
        synchronized (object) {
            this.registeredHtmlPanels.put(hp, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Window, List<HtmlPanel>> getRegisteredHtmlPanelsAsMap() {
        Object object = webPaintLock;
        synchronized (object) {
            return Util.toWindowMapSynced(this.registeredHtmlPanels.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HtmlPanel findHtmlPanelById(String id) {
        Object object = webPaintLock;
        synchronized (object) {
            for (HtmlPanel hp : this.registeredHtmlPanels.keySet()) {
                if (!id.equals(System.identityHashCode(hp) + "")) continue;
                return hp;
            }
        }
        return null;
    }

    @Override
    protected String getCurrentCursor(String winId) {
        WebWindowPeer peer = Util.findWindowPeerById(winId);
        return peer == null ? null : peer.getCurrentCursor();
    }

    @Override
    protected void setCurrentCursor(String winId, String cursor) {
        WebWindowPeer peer = Util.findWindowPeerById(winId);
        if (peer != null) {
            peer.setCurrentCursor(cursor);
        }
    }
}

