/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.dispatch;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.webswing.dispatch.EventDispatcher;
import org.webswing.model.MsgIn;
import org.webswing.model.c2s.ActionEventMsgIn;
import org.webswing.model.c2s.AudioEventMsgIn;
import org.webswing.model.c2s.ConnectionHandshakeMsgIn;
import org.webswing.model.c2s.CopyEventMsgIn;
import org.webswing.model.c2s.FilesSelectedEventMsgIn;
import org.webswing.model.c2s.KeyboardEventMsgIn;
import org.webswing.model.c2s.MouseEventMsgIn;
import org.webswing.model.c2s.PasteEventMsgIn;
import org.webswing.model.c2s.SimpleEventMsgIn;
import org.webswing.model.c2s.UploadEventMsgIn;
import org.webswing.model.c2s.WindowEventMsgIn;
import org.webswing.model.c2s.WindowFocusMsgIn;
import org.webswing.toolkit.WebDragSourceContextPeer;
import org.webswing.toolkit.extra.DndEventHandler;
import org.webswing.toolkit.util.DeamonThreadFactory;
import org.webswing.toolkit.util.Logger;
import org.webswing.toolkit.util.Util;
import sun.awt.UngrabEvent;

public abstract class AbstractEventDispatcher
implements EventDispatcher {
    private MouseEvent lastMouseEvent;
    private MouseEventInfo lastMousePressEvent;
    private Point lastMousePosition = new Point();
    private AtomicBoolean javaFXdragStarted = new AtomicBoolean(false);
    private Component lastEnteredWindow;
    private final DndEventHandler dndHandler;
    private final HashMap<String, String> uploadMap = new HashMap();
    private ExecutorService eventDispatcher = Executors.newSingleThreadExecutor(DeamonThreadFactory.getInstance("Webswing Event Dispatcher"));
    private final HashMap<Integer, Integer> releaseCharMap = new HashMap();
    private static final long DOUBLE_CLICK_MAX_DELAY = Long.getLong("webswing.doubleClickMaxDelay", 750L);
    private static final int CLICK_TOLERANCE = 2;
    protected static final List<Integer> NON_STANDARD_KEY_CODES = Arrays.asList(225, 224, 227, 226);
    protected static final Map<Integer, Integer> CONVERTED_KEY_CODES = new HashMap<Integer, Integer>();

    public AbstractEventDispatcher() {
        this.dndHandler = new DndEventHandler();
    }

    @Override
    public void dispatchEvent(MsgIn event) {
        Logger.debug("WebEventDispatcher.dispatchEvent:", event);
        this.eventDispatcher.submit(() -> {
            try {
                if (event instanceof MouseEventMsgIn) {
                    this.dispatchMouseEvent((MouseEventMsgIn)event);
                }
                if (event instanceof KeyboardEventMsgIn) {
                    this.dispatchKeyboardEvent((KeyboardEventMsgIn)event);
                }
                if (event instanceof ConnectionHandshakeMsgIn) {
                    this.dispatchHandshakeEvent((ConnectionHandshakeMsgIn)event);
                }
                if (event instanceof SimpleEventMsgIn) {
                    this.dispatchMessage((SimpleEventMsgIn)event);
                }
                if (event instanceof PasteEventMsgIn) {
                    this.handlePasteEvent((PasteEventMsgIn)event);
                }
                if (event instanceof CopyEventMsgIn) {
                    this.handleCopyEvent((CopyEventMsgIn)event);
                }
                if (event instanceof FilesSelectedEventMsgIn) {
                    this.handleFileSelectionEvent((FilesSelectedEventMsgIn)event);
                }
                if (event instanceof UploadEventMsgIn) {
                    this.handleUploadEvent((UploadEventMsgIn)event);
                }
                if (event instanceof WindowEventMsgIn) {
                    this.handleWindowEvent((WindowEventMsgIn)event);
                }
                if (event instanceof AudioEventMsgIn) {
                    this.handleAudioEvent((AudioEventMsgIn)event);
                }
                if (event instanceof ActionEventMsgIn) {
                    this.handleActionEvent((ActionEventMsgIn)event);
                }
                if (event instanceof WindowFocusMsgIn) {
                    this.windowFocusEvent((WindowFocusMsgIn)event);
                }
            }
            catch (Throwable e) {
                Logger.error("Failed to process event.", e);
            }
        });
    }

    protected abstract void windowFocusEvent(WindowFocusMsgIn var1);

    protected abstract void dispatchMouseEvent(MouseEventMsgIn var1);

    protected abstract void dispatchKeyboardEvent(KeyboardEventMsgIn var1);

    protected abstract void dispatchHandshakeEvent(ConnectionHandshakeMsgIn var1);

    protected abstract void dispatchMessage(SimpleEventMsgIn var1);

    protected abstract void handlePasteEvent(PasteEventMsgIn var1);

    protected abstract void handleCopyEvent(CopyEventMsgIn var1);

    protected abstract void handleFileSelectionEvent(FilesSelectedEventMsgIn var1);

    protected abstract void handleUploadEvent(UploadEventMsgIn var1);

    protected abstract void handleWindowEvent(WindowEventMsgIn var1);

    protected abstract void handleAudioEvent(AudioEventMsgIn var1);

    protected abstract void handleActionEvent(ActionEventMsgIn var1);

    @Override
    public void dispatchEventInSwing(Component c, AWTEvent e) {
        Window w = (Window)(c instanceof Window ? c : SwingUtilities.windowForComponent(c));
        if (w.isEnabled()) {
            Logger.debug("WebEventDispatcher.dispatchEventInSwing:postSystemQueue", e);
            this.dispatchEnterExitEvents(w, e);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
        }
    }

    @Override
    public void dragStart(WebDragSourceContextPeer peer, Transferable transferable, int actions, long[] formats) {
        this.getDndHandler().dragStart(peer, transferable, actions, formats);
    }

    @Override
    public Point getLastMousePosition() {
        return this.lastMousePosition;
    }

    protected void dispatchPasteEvent(boolean special) {
        KeyboardEventMsgIn event = new KeyboardEventMsgIn();
        event.setType(KeyboardEventMsgIn.KeyEventType.keydown);
        event.setCharacter(86);
        event.setKeycode(86);
        event.setCtrl(true);
        event.setShift(special);
        this.dispatchKeyboardEvent(event);
        event.setType(KeyboardEventMsgIn.KeyEventType.keyup);
        this.dispatchKeyboardEvent(event);
    }

    protected void dispatchCopyEvent() {
        KeyboardEventMsgIn event = new KeyboardEventMsgIn();
        event.setType(KeyboardEventMsgIn.KeyEventType.keydown);
        event.setCharacter(67);
        event.setKeycode(67);
        event.setCtrl(true);
        this.dispatchKeyboardEvent(event);
        event.setType(KeyboardEventMsgIn.KeyEventType.keyup);
        this.dispatchKeyboardEvent(event);
    }

    protected void dispatchCutEvent() {
        KeyboardEventMsgIn event = new KeyboardEventMsgIn();
        event.setType(KeyboardEventMsgIn.KeyEventType.keydown);
        event.setCharacter(88);
        event.setKeycode(88);
        event.setCtrl(true);
        this.dispatchKeyboardEvent(event);
        event.setType(KeyboardEventMsgIn.KeyEventType.keyup);
        this.dispatchKeyboardEvent(event);
    }

    protected void dispatchKeyEventInSwing(Component c, AWTEvent e) {
        Window w = (Window)(c instanceof Window ? c : SwingUtilities.windowForComponent(c));
        if (w.isEnabled()) {
            Util.getWebToolkit().getPaintDispatcher().notifyAccessibilityInfoUpdate();
            if (this.isDndInProgress()) {
                this.getDndHandler().processMouseEvent(w, e);
            } else {
                this.dispatchEventInSwing(c, e);
            }
        }
    }

    protected void dispatchMouseEventInSwing(Component c, MouseEvent e, boolean relatedToPreviousEvent) {
        Window w = (Window)(c instanceof Window ? c : SwingUtilities.windowForComponent(c));
        if (w.isEnabled()) {
            w.setCursor(w.getCursor());
            Util.getWebToolkit().getPaintDispatcher().notifyAccessibilityInfoUpdate(c, e.getXOnScreen(), e.getYOnScreen());
            if (!relatedToPreviousEvent && Util.isWindowDecorationEvent(w, e) || Util.getWebToolkit().getWindowManager().isLockedToWindowDecorationHandler()) {
                Logger.debug("WebEventDispatcher.dispatchEventInSwing:windowManagerHandle", e);
                if (e.getID() == 501) {
                    this.dispatchEventInSwing(c, new UngrabEvent(c));
                }
                Util.getWebToolkit().getWindowManager().handleWindowDecorationEvent(w, e);
            } else if (this.isDndInProgress()) {
                this.getDndHandler().processMouseEvent(w, e);
            } else {
                this.dispatchEventInSwing(c, e);
            }
        }
    }

    @Override
    public boolean isDndInProgress() {
        return this.dndHandler.isDndInProgress();
    }

    protected DndEventHandler getDndHandler() {
        return this.dndHandler;
    }

    protected int computeClickCount(int x, int y, int button, boolean isPressed, int timeMilis) {
        if (isPressed) {
            if (this.isNearLastMousePressEvent(x, y) && this.lastMousePressEvent.type == 500 && this.lastMousePressEvent.button == button && (long)(timeMilis - this.lastMousePressEvent.time) < this.getDoubleClickMaxDelay()) {
                return this.lastMousePressEvent.clickcount + 1;
            }
        } else if (this.lastMousePressEvent != null && this.lastMousePressEvent.type == 501 && this.lastMousePressEvent.button == button) {
            return this.lastMousePressEvent.clickcount;
        }
        return 1;
    }

    protected boolean isNearLastMousePressEvent(int x, int y) {
        return this.lastMousePressEvent != null && Math.abs(this.lastMousePressEvent.x - x) < this.getClickTolerance() && Math.abs(this.lastMousePressEvent.y - y) < this.getClickTolerance();
    }

    protected long getDoubleClickMaxDelay() {
        return DOUBLE_CLICK_MAX_DELAY;
    }

    protected int getClickTolerance() {
        return 2;
    }

    protected HashMap<String, String> getFileUploadMap() {
        return this.uploadMap;
    }

    protected HashMap<Integer, Integer> getReleaseCharMap() {
        return this.releaseCharMap;
    }

    protected MouseEvent getLastMouseEvent() {
        return this.lastMouseEvent;
    }

    protected void setLastMouseEvent(MouseEvent lastMouseEvent) {
        this.lastMouseEvent = lastMouseEvent;
    }

    protected boolean relatedToLastEvent(MouseEventMsgIn event) {
        return this.lastMouseEvent != null && (this.lastMouseEvent.getID() == 506 || this.lastMouseEvent.getID() == 501) && (event.getType() == MouseEventMsgIn.MouseEventType.mousemove && event.getButtons() != 0 || event.getType() == MouseEventMsgIn.MouseEventType.mouseup);
    }

    protected void setLastMousePosition(int x, int y) {
        this.lastMousePosition.x = x;
        this.lastMousePosition.y = y;
    }

    protected Component getLastEnteredWindow() {
        return this.lastEnteredWindow;
    }

    protected void setLastEnteredWindow(Component lastEnteredWindow) {
        this.lastEnteredWindow = lastEnteredWindow;
    }

    protected void setLastMousePressEvent(MouseEvent e, int timeMilis) {
        this.lastMousePressEvent = MouseEventInfo.get(e, timeMilis);
    }

    @Override
    public boolean isJavaFXdragStarted() {
        return this.javaFXdragStarted.get();
    }

    @Override
    public void setJavaFXdragStarted(boolean b) {
        this.javaFXdragStarted.getAndSet(b);
    }

    protected void dispatchEnterExitEvents(Window w, AWTEvent e) {
        if (e instanceof MouseEvent && this.getLastEnteredWindow() != w) {
            MouseEvent oe = (MouseEvent)e;
            this.dispatchExitEvent(oe.getWhen(), oe.getModifiersEx() | oe.getModifiers(), oe.getX(), oe.getY(), oe.getXOnScreen(), oe.getYOnScreen());
            if (w != null) {
                MouseEvent enterEvent = new MouseEvent(w, 504, oe.getWhen(), oe.getModifiersEx() | oe.getModifiers(), oe.getX(), oe.getY(), oe.getXOnScreen(), oe.getYOnScreen(), oe.getClickCount(), oe.isPopupTrigger(), oe.getButton());
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(enterEvent);
            }
            this.setLastEnteredWindow(w);
        }
    }

    protected void dispatchExitEvent(long when, int mod, int x, int y, int absX, int absY) {
        if (this.getLastEnteredWindow() != null && this.getLastEnteredWindow().isShowing()) {
            MouseEvent exitEvent = new MouseEvent(this.getLastEnteredWindow(), 505, when, mod, x, y, absX, absY, 0, false, 0);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(exitEvent);
            this.setLastEnteredWindow(null);
        }
    }

    static {
        CONVERTED_KEY_CODES.put(45, 155);
        CONVERTED_KEY_CODES.put(46, 127);
        CONVERTED_KEY_CODES.put(93, 525);
        CONVERTED_KEY_CODES.put(189, 45);
        CONVERTED_KEY_CODES.put(187, 61);
        CONVERTED_KEY_CODES.put(219, 91);
        CONVERTED_KEY_CODES.put(221, 93);
        CONVERTED_KEY_CODES.put(186, 59);
        CONVERTED_KEY_CODES.put(220, 92);
        CONVERTED_KEY_CODES.put(226, 92);
        CONVERTED_KEY_CODES.put(188, 44);
        CONVERTED_KEY_CODES.put(190, 46);
        CONVERTED_KEY_CODES.put(191, 47);
    }

    protected static class MouseEventInfo {
        final int x;
        final int y;
        final int type;
        final int button;
        final int clickcount;
        final int time;

        private MouseEventInfo(MouseEvent e, int time) {
            this.x = e.getX();
            this.y = e.getY();
            this.type = e.getID();
            this.clickcount = e.getClickCount();
            this.button = e.getButton();
            this.time = time;
        }

        public static MouseEventInfo get(MouseEvent e, int time) {
            return new MouseEventInfo(e, time);
        }
    }
}

