/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.math.spline;

import java.util.Arrays;
import jdistlib.math.LinPack;
import jdistlib.math.spline.SmoothSplineCriterion;
import jdistlib.math.spline.SmoothSplineResult;

public class SmoothSpline {
    public static final double kDefaultTolerance = 1.0E-4;
    public static final double kDefaultEpsilon = 2.0E-8;
    public static final double kDefaultSmoothingParamLowerBound = -1.5;
    public static final double kDefaultSmoothingParamUpperBound = 1.5;
    public static final int kDefaultMaxNumIterations = 500;
    private static final double kLog2Of1_4 = Math.log(1.4) / 0.6931471805599453;
    private static final double kLog2Of1_42 = Math.log(1.4285714285714286) / 0.6931471805599453;
    private static final double kstxwx_eps = 1.0E-10;
    private static final double ksslvrg_eps = 1.0E-11;
    private static final double kBigValue = 1.0E100;
    private static final double kAThird = 0.3333333333333333;
    private static final int kInsertionTreshold = 4;

    private static final int calcNumInnerKnots(int n) {
        if (n < 50) {
            return n;
        }
        if (n < 200) {
            return (int)Math.floor(50.0 * Math.pow(2.0, (double)(n - 50) / 150.0));
        }
        if (n < 800) {
            return (int)Math.floor(100.0 * Math.pow(2.0, kLog2Of1_4 * (double)(n - 200) / 600.0));
        }
        if (n < 3200) {
            return (int)Math.floor(140.0 * Math.pow(2.0, kLog2Of1_42 * (double)(n - 800) / 2400.0));
        }
        return (int)Math.floor(200.0 + Math.pow(n - 3200, 0.2));
    }

    private static final double[] formKnots(double[] x) {
        int n = x.length;
        int nk = SmoothSpline.calcNumInnerKnots(n);
        int nMin1 = n - 1;
        int nkMin1 = nk - 1;
        double[] result = new double[nk + 6];
        result[1] = result[2] = x[0];
        result[0] = result[2];
        double d = x[nMin1];
        result[nk + 5] = d;
        result[nk + 4] = d;
        result[nk + 3] = d;
        for (int i = 0; i < nk; ++i) {
            result[i + 3] = x[i * nMin1 / nkMin1];
        }
        return result;
    }

    private static final SmoothSplineResult fitCubicSpline(double penalty, double dfOffset, double[] xs, double[] ys, double[] ws, double ssw, double[] knots, SmoothSplineCriterion criterion, double spar, double lspar, double uspar, double tol, double eps, int maxIteration) {
        int i;
        double fx;
        double v;
        boolean isSparSupplied;
        int n = xs.length;
        int nk = knots.length - 4;
        boolean hasError = false;
        assert (n == ys.length && n == ws.length);
        SmoothSplineResult result = new SmoothSplineResult();
        result.mCoefficients = new double[nk];
        result.mSmoothedValues = new double[n];
        result.mLeverage = new double[n];
        result.mEstimatedDF = dfOffset;
        result.mCriterion = criterion;
        result.mKnots = knots;
        double ratio = 1.0;
        double[][] sigma = null;
        double[] xwy = null;
        Object XtWX = null;
        double[] newWs = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            if (!(ws[i2] > 0.0)) continue;
            newWs[i2] = Math.sqrt(ws[i2]);
        }
        sigma = SmoothSpline.calculateSigma(knots);
        XtWX = SmoothSpline.calculateXtWX(xs, ys, newWs, knots);
        xwy = XtWX[4];
        double[][] newHs = new double[4][];
        for (int i3 = 0; i3 < 4; ++i3) {
            newHs[i3] = XtWX[i3];
        }
        XtWX = newHs;
        double t1 = 0.0;
        double t2 = 0.0;
        for (int i4 = 2; i4 < nk - 3; ++i4) {
            t1 += XtWX[0][i4];
            t2 += sigma[0][i4];
        }
        ratio = t1 / t2;
        boolean bl = isSparSupplied = !Double.isNaN(spar) && !Double.isInfinite(spar);
        if (isSparSupplied) {
            result.mSmoothingParameter = spar;
            result.mLambda = ratio * Math.pow(16.0, result.mSmoothingParameter * 6.0 - 2.0);
            result.mHasFactorizationProblems = SmoothSpline.calculateCVScore(result, penalty, xs, ys, newWs, ssw, knots, criterion, xwy, XtWX, sigma);
            return result;
        }
        result.mIterNo = 0;
        double a = lspar;
        double b = uspar;
        double w = v = a + 0.38196601125010515 * (b - a);
        double x = v;
        double e = 0.0;
        result.mSmoothingParameter = x;
        result.mLambda = ratio * Math.pow(16.0, result.mSmoothingParameter * 6.0 - 2.0);
        result.mHasFactorizationProblems = SmoothSpline.calculateCVScore(result, penalty, xs, ys, newWs, ssw, knots, criterion, xwy, XtWX, sigma);
        double fv = fx = result.mFitCVScore;
        double fw = fx;
        double d = 0.0;
        while (!hasError) {
            double u;
            boolean isGoldenSect;
            double xm = (a + b) * 0.5;
            double tol1 = eps * Math.abs(x) + tol / 3.0;
            double tol2 = tol1 * 2.0;
            ++result.mIterNo;
            if (Math.abs(x - xm) <= tol2 - (b - a) * 0.5 || result.mIterNo > maxIteration) break;
            boolean bl2 = isGoldenSect = Math.abs(e) <= tol1 || fx >= 1.0E100 || fv >= 1.0E100 || fw >= 1.0E100;
            if (!isGoldenSect) {
                double u2;
                double r = (x - w) * (fx - fv);
                double q = (x - v) * (fx - fw);
                double p = (x - v) * q - (x - w) * r;
                if ((q = (q - r) * 2.0) > 0.0) {
                    p = -p;
                }
                q = Math.abs(q);
                r = e;
                e = d;
                boolean bl3 = isGoldenSect = Math.abs(p) >= Math.abs(0.5 * q * r) || q == 0.0 || p <= q * (a - x) || p >= q * (b - x);
                if (!isGoldenSect && ((u2 = x + (d = p / q)) - a < tol2 || b - u2 < tol2)) {
                    double d2 = d = xm >= x ? Math.abs(tol1) : -Math.abs(tol1);
                }
            }
            if (isGoldenSect) {
                e = x >= xm ? a - x : b - x;
                d = 0.38196601125010515 * e;
            }
            result.mSmoothingParameter = u = x + (Math.abs(d) >= tol1 ? d : (d >= 0.0 ? Math.abs(tol1) : -Math.abs(tol1)));
            result.mLambda = ratio * Math.pow(16.0, result.mSmoothingParameter * 6.0 - 2.0);
            hasError = SmoothSpline.calculateCVScore(result, penalty, xs, ys, newWs, ssw, knots, criterion, xwy, XtWX, sigma);
            double fu = result.mFitCVScore;
            if (fu <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                fv = fw;
                w = x;
                fw = fx;
                x = u;
                fx = fu;
                continue;
            }
            if (u < x) {
                a = u;
            } else {
                b = u;
            }
            if (fu <= fw || w == x) {
                v = w;
                fv = fw;
                w = u;
                fw = fu;
                continue;
            }
            if (!(fu <= fv) && v != x && v != w) continue;
            v = u;
            fv = fu;
        }
        result.mSmoothingParameter = x;
        result.mFitCVScore = fx;
        result.mHasFactorizationProblems = hasError;
        double sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += result.mLeverage[i];
        }
        result.mEstimatedDF = sum;
        sum = 0.0;
        for (i = 0; i < n; ++i) {
            double temp = ys[i] - result.mSmoothedValues[i];
            sum += ws[i] * temp * temp;
        }
        result.mPenalizedCriterion = sum;
        return result;
    }

    private static final double[][] calculateSigma(double[] tb) {
        int nb = tb.length - 4;
        int ileft = 0;
        double[][] sg = new double[4][nb];
        double[] yw1 = new double[4];
        double[] yw2 = new double[4];
        double[][] vnikx = new double[3][4];
        for (int i = 0; i < nb; ++i) {
            int ii;
            ileft = SmoothSpline.determineInterval(tb, tb[i], ileft, null);
            SmoothSpline.calculateBSplineDerivatives(tb, tb[i], ileft, vnikx);
            for (ii = 0; ii < 4; ++ii) {
                yw1[ii] = vnikx[2][ii];
            }
            SmoothSpline.calculateBSplineDerivatives(tb, tb[i + 1], ileft, vnikx);
            ++ileft;
            for (ii = 0; ii < 4; ++ii) {
                yw2[ii] = vnikx[2][ii] - yw1[ii];
            }
            double wpt = tb[i + 1] - tb[i];
            int maxIdx = Math.min(ileft, 4);
            for (int ii2 = 0; ii2 < maxIdx; ++ii2) {
                for (int jj = ii2; jj < maxIdx; ++jj) {
                    double[] dArray = sg[jj - ii2];
                    int n = ileft + ii2 - maxIdx;
                    dArray[n] = dArray[n] + wpt * (yw1[ii2] * yw1[jj] + (yw2[ii2] * yw1[jj] + yw2[jj] * yw1[ii2]) * 0.5 + yw2[ii2] * yw2[jj] * 0.3333333333333333);
                }
            }
        }
        return sg;
    }

    private static final double[][] calculateXtWX(double[] x, double[] y, double[] w, double[] knots) {
        int k = x.length;
        int n = knots.length - 4;
        int[] mflag = new int[1];
        double[] vnikx = new double[4];
        double[][] dvnikx = new double[][]{vnikx};
        double[] hs0 = new double[n];
        double[] hs1 = new double[n];
        double[] hs2 = new double[n];
        double[] hs3 = new double[n];
        double[] xwy = new double[n];
        double[][] retval = new double[][]{hs0, hs1, hs2, hs3, xwy};
        int ileft = 0;
        for (int i = 0; i < k; ++i) {
            ileft = SmoothSpline.determineInterval(knots, x[i], ileft, mflag);
            if (mflag[0] == 1) {
                if (x[i] <= knots[ileft] + 1.0E-10) {
                    ileft = n - 1;
                } else {
                    return retval;
                }
            }
            SmoothSpline.calculateBSplineDerivatives(knots, x[i], ileft, dvnikx);
            int j = ileft - 3;
            double w_i = w[i];
            double z_i = y[i];
            double vnikx_i = vnikx[0];
            double temp = w_i * w_i * vnikx_i;
            int n2 = j;
            xwy[n2] = xwy[n2] + temp * z_i;
            int n3 = j;
            hs0[n3] = hs0[n3] + temp * vnikx_i;
            int n4 = j;
            hs1[n4] = hs1[n4] + temp * vnikx[1];
            int n5 = j;
            hs2[n5] = hs2[n5] + temp * vnikx[2];
            int n6 = j++;
            hs3[n6] = hs3[n6] + temp * vnikx[3];
            vnikx_i = vnikx[1];
            temp = w_i * w_i * vnikx_i;
            int n7 = j;
            xwy[n7] = xwy[n7] + temp * z_i;
            int n8 = j;
            hs0[n8] = hs0[n8] + temp * vnikx_i;
            int n9 = j;
            hs1[n9] = hs1[n9] + temp * vnikx[2];
            int n10 = j++;
            hs2[n10] = hs2[n10] + temp * vnikx[3];
            vnikx_i = vnikx[2];
            temp = w_i * w_i * vnikx_i;
            int n11 = j;
            xwy[n11] = xwy[n11] + temp * z_i;
            int n12 = j;
            hs0[n12] = hs0[n12] + temp * vnikx_i;
            int n13 = j++;
            hs1[n13] = hs1[n13] + temp * vnikx[3];
            vnikx_i = vnikx[3];
            temp = w_i * w_i * vnikx_i;
            int n14 = j;
            xwy[n14] = xwy[n14] + temp * z_i;
            int n15 = j;
            hs0[n15] = hs0[n15] + temp * vnikx_i;
        }
        return retval;
    }

    private static final double[][] calculateInnerProduct(double[][] abd) {
        double wjm1;
        int nk = abd[0].length;
        int i = nk - 1;
        double[][] p1ip = new double[abd.length][nk];
        double c0 = 1.0 / abd[3][i];
        p1ip[3][i] = wjm1 = c0 * c0;
        c0 = 1.0 / abd[3][--i];
        double c3 = -abd[2][i + 1] * c0;
        double wjm21 = wjm1;
        double d = c3 * wjm1;
        p1ip[2][i] = d;
        double wjm22 = d;
        double d2 = c0 * c0 + c3 * c3 * wjm1;
        p1ip[3][i] = d2;
        wjm1 = d2;
        c0 = 1.0 / abd[3][--i];
        double c2 = -abd[1][i + 2] * c0;
        c3 = -abd[2][i + 1] * c0;
        double wjm31 = wjm21;
        double wjm32 = wjm22;
        double d3 = c2 * wjm21 + c3 * wjm22;
        p1ip[1][i] = d3;
        double wjm33 = d3;
        p1ip[2][i] = c2 * wjm22 + c3 * wjm1;
        p1ip[3][i] = c0 * c0 + c2 * c2 * wjm21 + 2.0 * c2 * c3 * wjm22 + c3 * c3 * wjm1;
        wjm21 = wjm1;
        wjm22 = p1ip[2][i];
        wjm1 = p1ip[3][i];
        --i;
        while (i >= 0) {
            c0 = 1.0 / abd[3][i];
            double c1 = -abd[0][i + 3] * c0;
            c2 = -abd[1][i + 2] * c0;
            c3 = -abd[2][i + 1] * c0;
            p1ip[0][i] = c1 * wjm31 + c2 * wjm32 + c3 * wjm33;
            p1ip[1][i] = c1 * wjm32 + c2 * wjm21 + c3 * wjm22;
            p1ip[2][i] = c1 * wjm33 + c2 * wjm22 + c3 * wjm1;
            p1ip[3][i] = c0 * c0 + c1 * c1 * wjm31 + 2.0 * c1 * c2 * wjm32 + 2.0 * c1 * c3 * wjm33 + c2 * c2 * wjm21 + 2.0 * c2 * c3 * wjm22 + c3 * c3 * wjm1;
            wjm31 = wjm21;
            wjm32 = wjm22;
            wjm33 = p1ip[1][i];
            wjm21 = wjm1;
            wjm22 = p1ip[2][i];
            wjm1 = p1ip[3][i];
            --i;
        }
        return p1ip;
    }

    private static final boolean calculateCVScore(SmoothSplineResult result, double penalty, double[] x, double[] y, double[] w, double ssw, double[] knot, SmoothSplineCriterion criterion, double[] xwy, double[][] hs, double[][] sg) {
        double[] coef = result.mCoefficients;
        double[] sz = result.mSmoothedValues;
        double[] lev = result.mLeverage;
        int n = x.length;
        int nk = knot.length - 4;
        int[] mflag = new int[1];
        double[][] dvnikx = new double[1][4];
        double[] vnikx = dvnikx[0];
        double[][] abd = new double[4][nk];
        int ileft = 0;
        if (hs != null && sg != null) {
            int nkMin1 = nk - 1;
            int nkMin2 = nk - 2;
            int nkMin3 = nk - 3;
            double lambda = result.mLambda;
            System.arraycopy(xwy, 0, coef, 0, nk);
            abd[3][nkMin1] = hs[0][nkMin1] + lambda * sg[0][nkMin1];
            abd[3][nkMin2] = hs[0][nkMin2] + lambda * sg[0][nkMin2];
            abd[3][nkMin3] = hs[0][nkMin3] + lambda * sg[0][nkMin3];
            abd[2][nkMin1] = hs[1][nkMin2] + lambda * sg[1][nkMin2];
            abd[2][nkMin2] = hs[1][nkMin3] + lambda * sg[1][nkMin3];
            abd[1][nkMin1] = hs[2][nkMin3] + lambda * sg[2][nkMin3];
            for (int i = 0; i < nkMin3; ++i) {
                for (int j = 0; j < 4; ++j) {
                    abd[3 - j][i + j] = hs[j][i] + lambda * sg[j][i];
                }
            }
            int retVal = LinPack.dpbfa(abd, 3);
            if (retVal != 0) {
                return true;
            }
            LinPack.dpbsl(abd, 3, coef);
        }
        for (int i = 0; i < n; ++i) {
            sz[i] = SmoothSpline.evaluateBSplineDerivatives(knot, coef, x[i], 0);
        }
        if (criterion == SmoothSplineCriterion.NO_CRITERION) {
            return false;
        }
        double[][] p1ip = SmoothSpline.calculateInnerProduct(abd);
        for (int i = 0; i < n; ++i) {
            double xv = x[i];
            ileft = SmoothSpline.determineInterval(knot, xv, ileft, mflag);
            if (mflag[0] == -1) {
                ileft = 3;
                xv = knot[3] + 1.0E-11;
            } else if (mflag[0] == 1) {
                ileft = nk - 1;
                xv = knot[nk] - 1.0E-11;
            }
            SmoothSpline.calculateBSplineDerivatives(knot, xv, ileft, dvnikx);
            int j = ileft - 3;
            int jp1 = j + 1;
            int jp2 = j + 2;
            double b0 = vnikx[0];
            double b1 = vnikx[1];
            double b2 = vnikx[2];
            double b3 = vnikx[3];
            double wi = w[i];
            lev[i] = (p1ip[3][j] * b0 * b0 + 2.0 * p1ip[2][j] * b0 * b1 + 2.0 * p1ip[1][j] * b0 * b2 + 2.0 * p1ip[0][j] * b0 * b3 + p1ip[3][jp1] * b1 * b1 + 2.0 * p1ip[2][jp1] * b1 * b2 + 2.0 * p1ip[1][jp1] * b1 * b3 + p1ip[3][jp2] * b2 * b2 + 2.0 * p1ip[2][jp2] * b2 * b3 + p1ip[3][ileft] * b3 * b3) * wi * wi;
        }
        switch (criterion) {
            case GCV: {
                double temp;
                double rss = ssw;
                double df = 0.0;
                double sumw = 0.0;
                for (int i = 0; i < n; ++i) {
                    temp = (y[i] - sz[i]) * w[i];
                    rss += temp * temp;
                    df += lev[i];
                    temp = w[i];
                    sumw += temp * temp;
                }
                temp = 1.0 - (result.mEstimatedDF + penalty * df) / sumw;
                result.mFitCVScore = rss / sumw / (temp * temp);
                break;
            }
            case CV: {
                double sum = 0.0;
                for (int i = 0; i < n; ++i) {
                    double temp = (y[i] - sz[i]) * w[i] / (1.0 - lev[i]);
                    sum += temp * temp;
                }
                result.mFitCVScore = sum / (double)n;
                break;
            }
            case DF_MATCH: {
                double sum = 0.0;
                for (int i = 0; i < n; ++i) {
                    sum += lev[i];
                }
                double temp = result.mEstimatedDF - sum;
                result.mFitCVScore = temp * temp + 3.0;
                break;
            }
        }
        return false;
    }

    private static final void calculateBSplineDerivatives(double[] t, double x, int left, double[][] dbiatx) {
        int k = dbiatx[0].length;
        int nderiv = dbiatx.length;
        int mhigh = Math.max(Math.min(nderiv, k), 1);
        SmoothSpline.calculateBSplineInitialDerivatives(t, k - mhigh, true, x, left, dbiatx[0]);
        if (mhigh == 1) {
            return;
        }
        int ideriv = mhigh;
        for (int m = 2; m <= mhigh; ++m) {
            int j = ideriv;
            int jp1mid = 0;
            while (j <= k) {
                dbiatx[ideriv - 1][j - 1] = dbiatx[0][jp1mid];
                ++j;
                ++jp1mid;
            }
            SmoothSpline.calculateBSplineInitialDerivatives(t, k - --ideriv, false, x, left, dbiatx[0]);
        }
        double[][] a = new double[k][k];
        for (int i = 0; i < k; ++i) {
            a[i][i] = 1.0;
        }
        int kp1 = k + 1;
        for (int m = 2; m <= mhigh; ++m) {
            int kp1mm = kp1 - m;
            int ldummy = 1;
            int il = left + 1;
            int j = k;
            while (ldummy <= kp1mm) {
                double factor = (double)kp1mm / (t[il + kp1mm - 1] - t[il - 1]);
                for (int l = 0; l < j; ++l) {
                    a[l][j - 1] = (a[l][j - 1] - a[l][j - 2]) * factor;
                }
                ++ldummy;
                --il;
                --j;
            }
            for (int i = 1; i <= k; ++i) {
                double sum = 0.0;
                for (int j2 = Math.max(i, m); j2 <= k; ++j2) {
                    sum += a[i - 1][j2 - 1] * dbiatx[m - 1][j2 - 1];
                }
                dbiatx[m - 1][i - 1] = sum;
            }
        }
    }

    private static final void calculateBSplineInitialDerivatives(double[] t, int jhigh, boolean isInit, double x, int left, double[] biatx) {
        if (isInit) {
            biatx[0] = 1.0;
            if (jhigh < 1) {
                return;
            }
        }
        double[] deltal = new double[jhigh + 1];
        double[] deltar = new double[jhigh + 1];
        for (int j = 0; j < jhigh; ++j) {
            deltar[j] = t[left + j + 1] - x;
            deltal[j] = x - t[left - j];
            double saved = 0.0;
            for (int i = 0; i <= j; ++i) {
                double term = biatx[i] / (deltar[i] + deltal[j - i]);
                biatx[i] = saved + deltar[i] * term;
                saved = deltal[j - i] * term;
            }
            biatx[j + 1] = saved;
        }
    }

    private static final int determineInterval(double[] xt, double x, int ilo, int[] mflag) {
        int istep;
        int ihi;
        int n = xt.length;
        if (mflag == null) {
            mflag = new int[1];
        }
        if (ilo < 0) {
            if (x < xt[0]) {
                mflag[0] = -1;
                return 0;
            }
            ilo = 0;
        }
        if ((ihi = ilo + 1) >= n) {
            if (x >= xt[n - 1]) {
                mflag[0] = 1;
                return n - 1;
            }
            if (n <= 1) {
                mflag[0] = -1;
                return 0;
            }
            ilo = n - 2;
            ihi = n - 1;
        }
        if (x < xt[ihi]) {
            if (x >= xt[ilo]) {
                return ilo;
            }
            istep = 1;
            while (true) {
                if ((ilo = (ihi = ilo) - istep) <= 0) {
                    if (x < xt[0]) {
                        mflag[0] = -1;
                        return 0;
                    }
                    ilo = 0;
                } else if (!(x >= xt[ilo - 1])) {
                    istep *= 2;
                    continue;
                }
                break;
            }
        } else {
            istep = 1;
            while (true) {
                if ((ihi = (ilo = ihi) + istep) >= n) {
                    if (x >= xt[n - 1]) {
                        mflag[0] = 1;
                        return n - 1;
                    }
                    ihi = n - 1;
                    break;
                }
                if (x < xt[ihi]) break;
                istep *= 2;
            }
        }
        int middle;
        while ((middle = (ilo + ihi) / 2) != ilo) {
            if (x >= xt[middle]) {
                ilo = middle;
                continue;
            }
            ihi = middle;
        }
        return ilo;
    }

    private static final double evaluateBSplineDerivatives(double[] t, double[] bcoef, double x, int jderiv) {
        int ilo;
        int jj;
        int kmj;
        int j;
        int j2;
        int km1;
        int i = 1;
        int n = bcoef.length;
        int k = t.length - n;
        int[] mflag = new int[1];
        double[] aj = new double[k];
        double[] dm = new double[k - 1];
        double[] dp = new double[k - 1];
        if (jderiv >= k) {
            return 0.0;
        }
        if (x != t[n] || t[n] != t[n + k - 1]) {
            i = SmoothSpline.determineInterval(t, x, 0, mflag) + 1;
            if (mflag[0] != 0) {
                return 0.0;
            }
        } else {
            i = n;
        }
        if ((km1 = k - 1) <= 0) {
            return bcoef[i - 1];
        }
        int jcmin = 1;
        int imk = i - k;
        if (imk >= 0) {
            for (j2 = 0; j2 < km1; ++j2) {
                dm[j2] = x - t[i - j2 - 1];
            }
        } else {
            jcmin = 1 - imk;
            for (j2 = 0; j2 < i; ++j2) {
                dm[j2] = x - t[i - j2 + 1];
            }
            for (j2 = i - 1; j2 < km1; ++j2) {
                dm[j2] = dm[i - 1];
            }
        }
        int jcmax = k - 1;
        int nmi = n - i;
        if (nmi >= 0) {
            for (j = 0; j < km1; ++j) {
                dp[j] = t[i + j] - x;
            }
        } else {
            jcmax = k + nmi - 1;
            for (j = 0; j <= jcmax; ++j) {
                dp[j] = t[i + j] - x;
            }
            for (j = jcmax; j < k; ++j) {
                dp[j] = dp[jcmax];
            }
        }
        for (int jc = jcmin - 1; jc <= jcmax; ++jc) {
            aj[jc] = bcoef[imk + jc];
        }
        for (j = 0; j < jderiv; ++j) {
            kmj = k - j - 1;
            jj = 0;
            ilo = kmj - 1;
            while (jj < kmj) {
                aj[jj] = (aj[jj + 1] - aj[jj]) / (dm[ilo] + dp[jj]) * (double)kmj;
                ++jj;
                --ilo;
            }
        }
        for (j = jderiv; j < km1; ++j) {
            kmj = k - j - 2;
            jj = 0;
            ilo = kmj;
            while (jj <= kmj) {
                aj[jj] = (aj[jj + 1] * dm[ilo] + aj[jj] * dp[jj]) / (dm[ilo] + dp[jj]);
                ++jj;
                --ilo;
            }
        }
        return aj[0];
    }

    public static final double predict(SmoothSplineResult result, double val, int deriv) {
        return SmoothSpline.predict(result.mKnots, result.mCoefficients, result.mXMin, result.mXMax, val, deriv);
    }

    public static final double predict(double[] knots, double[] coefs, double xmin, double xmax, double val, int deriv) {
        double neg;
        double range = xmax - xmin;
        double normalizedValue = (val - xmin) / range;
        if (normalizedValue >= 0.0 && normalizedValue <= 1.0) {
            return SmoothSpline.evaluateBSplineDerivatives(knots, coefs, normalizedValue, deriv) / (deriv > 0 ? Math.pow(range, deriv) : 1.0);
        }
        double d = neg = normalizedValue < 0.0 ? 0.0 : 1.0;
        if (deriv == 0) {
            double intercept = SmoothSpline.evaluateBSplineDerivatives(knots, coefs, neg, 0);
            double slope = SmoothSpline.evaluateBSplineDerivatives(knots, coefs, neg, 1);
            return intercept + slope * (normalizedValue - neg);
        }
        if (deriv == 1) {
            return SmoothSpline.evaluateBSplineDerivatives(knots, coefs, neg, 1);
        }
        return 0.0;
    }

    private static final void normalizeWeights(double[] weights) {
        int i;
        double sumW = 0.0;
        int n = weights.length;
        int numNonZero = 0;
        for (i = 0; i < n; ++i) {
            double wt = weights[i];
            if (wt < 0.0) {
                throw new RuntimeException("Negative weight is not allowed!");
            }
            if (!(wt > 0.0)) continue;
            sumW += wt;
            ++numNonZero;
        }
        if (numNonZero == 0) {
            throw new RuntimeException("All zero weight is not allowed!");
        }
        sumW = (double)numNonZero / sumW;
        i = 0;
        while (i < n) {
            int n2 = i++;
            weights[n2] = weights[n2] * sumW;
        }
    }

    public static final SmoothSplineResult fitDFMatch(double[] x, double[] y, double df) {
        return SmoothSpline.fit(x, y, null, SmoothSplineCriterion.DF_MATCH, 1.0, df, Double.NaN, -1.5, 1.5, 1.0E-4, 500);
    }

    public static final SmoothSplineResult fitDFMatch(double[] x, double[] y, double[] weights, double df) {
        return SmoothSpline.fit(x, y, weights, SmoothSplineCriterion.DF_MATCH, 1.0, df, Double.NaN, -1.5, 1.5, 1.0E-4, 500);
    }

    public static final SmoothSplineResult fit(double[] x, double[] y) {
        return SmoothSpline.fit(x, y, null, SmoothSplineCriterion.NO_CRITERION, 1.0, 0.0, Double.NaN, -1.5, 1.5, 1.0E-4, 500);
    }

    public static final SmoothSplineResult fit(double[] x, double[] y, double[] weights) {
        return SmoothSpline.fit(x, y, weights, SmoothSplineCriterion.NO_CRITERION, 1.0, 0.0, Double.NaN, -1.5, 1.5, 1.0E-4, 500);
    }

    public static final SmoothSplineResult fit(double[] x, double[] y, double[] weights, SmoothSplineCriterion criterion, double penalty, double df) {
        return SmoothSpline.fit(x, y, weights, criterion, penalty, df, Double.NaN, -1.5, 1.5, 1.0E-4, 500);
    }

    public static final SmoothSplineResult fit(double[] x, double[] y, double[] weights, SmoothSplineCriterion criterion, double penalty, double df, double smoothingParam) {
        return SmoothSpline.fit(x, y, weights, criterion, penalty, df, smoothingParam, -1.5, 1.5, 1.0E-4, 500);
    }

    public static final SmoothSplineResult fit(double[] x, double[] y, double[] weights, SmoothSplineCriterion criterion, double penalty, double df, double smoothingParam, double smoothingParamLBound, double smoothingParamUBound, double tolerance, int maxNumIterations) {
        double[][] sortedUniqueArray;
        int n = x.length;
        if (y == null) {
            y = x;
            x = new double[n];
            for (int i = 0; i < n; ++i) {
                x[i] = i + 1;
            }
        }
        if (weights == null) {
            weights = new double[n];
            Arrays.fill(weights, 1.0);
        } else {
            SmoothSpline.normalizeWeights(weights);
        }
        assert (n == y.length && n == weights.length);
        double[][] sortedArray = new double[3][n];
        double sumOfSquare = 0.0;
        System.arraycopy(x, 0, sortedArray[0], 0, n);
        System.arraycopy(y, 0, sortedArray[1], 0, n);
        System.arraycopy(weights, 0, sortedArray[2], 0, n);
        SmoothSpline.sort2DByRow(sortedArray, 0);
        int[] dupeIdx = SmoothSpline.findDuplicateIndices(sortedArray[0]);
        int numUniqueElements = dupeIdx[n - 1] + 1;
        if (numUniqueElements < n) {
            int i;
            sortedUniqueArray = new double[3][numUniqueElements];
            double[] oldXBar = sortedArray[0];
            double[] oldYBar = sortedArray[1];
            double[] oldWBar = sortedArray[2];
            double[] newXBar = sortedUniqueArray[0];
            double[] newYBar = sortedUniqueArray[1];
            double[] newWBar = sortedUniqueArray[2];
            double[] tempBar = new double[numUniqueElements];
            for (i = 0; i < n; ++i) {
                int idx = dupeIdx[i];
                double wt = oldWBar[i];
                double yi = oldYBar[i];
                double wtyi = wt * yi;
                newXBar[idx] = oldXBar[i];
                int n2 = idx;
                newWBar[n2] = newWBar[n2] + wt;
                int n3 = idx;
                newYBar[n3] = newYBar[n3] + wtyi;
                int n4 = idx;
                tempBar[n4] = tempBar[n4] + wtyi * yi;
            }
            for (i = 0; i < numUniqueElements; ++i) {
                double wi = newWBar[i];
                double yi = newYBar[i];
                if (wi > 0.0) {
                    newYBar[i] = yi /= wi;
                }
                sumOfSquare += tempBar[i] - wi * yi * yi;
            }
        } else {
            sortedUniqueArray = sortedArray;
        }
        double[] xbar = sortedUniqueArray[0];
        double[] ybar = sortedUniqueArray[1];
        double[] wbar = sortedUniqueArray[2];
        double xmin = xbar[0];
        double xmax = xbar[numUniqueElements - 1];
        double range = xmax - xmin;
        for (int i = 0; i < numUniqueElements; ++i) {
            xbar[i] = (xbar[i] - xmin) / range;
        }
        double[] knots = SmoothSpline.formKnots(xbar);
        SmoothSplineResult result = SmoothSpline.fitCubicSpline(penalty, df, xbar, ybar, wbar, sumOfSquare, knots, criterion, smoothingParam, smoothingParamLBound, smoothingParamUBound, tolerance, 2.0E-8, maxNumIterations);
        result.mXMax = xmax;
        result.mXMin = xmin;
        if (criterion == SmoothSplineCriterion.CV) {
            double sum = 0.0;
            double sumW = 0.0;
            for (int i = 0; i < n; ++i) {
                int idx = dupeIdx[i];
                double wi = weights[i];
                double wbi = wbar[idx];
                if (wbi <= 0.0) {
                    wbi = 1.0;
                }
                double temp = (y[i] - result.mSmoothedValues[idx]) / (1.0 - result.mLeverage[idx] * wi / wbi);
                sum += wi * temp * temp;
                sumW += wi;
            }
            result.mCVScore = sum / sumW;
        } else {
            double dfOffset = criterion == SmoothSplineCriterion.DF_MATCH ? 0.0 : df;
            double sum = 0.0;
            double sumW = 0.0;
            double denom = 1.0 - (dfOffset + penalty * result.mEstimatedDF) / (double)n;
            denom *= denom;
            for (int i = 0; i < n; ++i) {
                double wi = weights[i];
                double temp = y[i] - result.mSmoothedValues[dupeIdx[i]];
                sum += wi * temp * temp;
                sumW += wi;
            }
            result.mCVScore = sum / sumW / denom;
        }
        return result;
    }

    static final int[] findDuplicateIndices(double[] arr) {
        int n = arr.length;
        int idx = 0;
        int[] result = new int[n];
        double lastX = arr[0];
        for (int i = 1; i < n; ++i) {
            double curX = arr[i];
            if (curX != lastX) {
                lastX = curX;
            }
            result[i] = ++idx;
        }
        return result;
    }

    private static final void sort2DByRow(double[][] data, int rowNo) {
        int maxData = data[0].length - 1;
        SmoothSpline.quickSortByRow(data, rowNo, 0, maxData);
        SmoothSpline.insertionSortByRow(data, rowNo, 0, maxData);
    }

    private static final void quickSortByRow(double[][] data, int rowNo, int lo, int hi) {
        if (hi - lo <= 4) {
            return;
        }
        int midpoint = (hi + lo) / 2;
        if (data[rowNo][lo] > data[rowNo][midpoint]) {
            SmoothSpline.swapRow(data, lo, midpoint);
        }
        if (data[rowNo][lo] > data[rowNo][hi]) {
            SmoothSpline.swapRow(data, lo, hi);
        }
        if (data[rowNo][midpoint] > data[rowNo][hi]) {
            SmoothSpline.swapRow(data, midpoint, hi);
        }
        int right = hi - 1;
        SmoothSpline.swapRow(data, midpoint, right);
        int left = lo;
        double[] dataRow = data[rowNo];
        double pivotElement = dataRow[right];
        while (true) {
            if (dataRow[++left] < pivotElement) {
                continue;
            }
            while (dataRow[--right] > pivotElement) {
            }
            if (right < left) break;
            SmoothSpline.swapRow(data, left, right);
        }
        SmoothSpline.swapRow(data, left, hi - 1);
        SmoothSpline.quickSortByRow(data, rowNo, lo, right);
        SmoothSpline.quickSortByRow(data, rowNo, left + 1, hi);
    }

    private static final void insertionSortByRow(double[][] data, int rowNo, int lo, int hi) {
        int numRows = data.length;
        double[] col_i = new double[numRows];
        for (int i = 1; i <= hi; ++i) {
            int jp1;
            double element_j;
            int j;
            int r;
            for (r = 0; r < numRows; ++r) {
                col_i[r] = data[r][i];
            }
            double element_i = data[rowNo][i];
            for (j = i - 1; j >= lo && !((element_j = data[rowNo][j]) <= element_i); --j) {
                jp1 = j + 1;
                for (r = 0; r < numRows; ++r) {
                    data[r][jp1] = data[r][j];
                }
            }
            jp1 = j + 1;
            for (r = 0; r < numRows; ++r) {
                data[r][jp1] = col_i[r];
            }
        }
    }

    private static final void swapRow(double[][] data, int i, int j) {
        for (double[] curRow : data) {
            double temp = curRow[i];
            curRow[i] = curRow[j];
            curRow[j] = temp;
        }
    }

    static void testBSPLVD() {
        double[] t = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 3.0, 4.0, 6.0, 6.0, 6.0};
        double[][] values = new double[1][3];
        int n = 7;
        int k = 3;
        int nPoint = 25;
        int iLeft = 0;
        double xl = t[k - 1];
        double dx = (t[n] - xl) / (double)(nPoint - 1);
        for (int i = 0; i < nPoint; ++i) {
            int j;
            double x = xl + (double)i * dx;
            double[] allValues = new double[n];
            if ((iLeft = SmoothSpline.determineInterval(t, x, iLeft, null)) >= n) {
                iLeft = n - 1;
            }
            SmoothSpline.calculateBSplineDerivatives(t, x, iLeft, values);
            int imkp1 = iLeft - k + 1;
            for (j = 0; j < k; ++j) {
                allValues[imkp1 + j] = values[0][j];
                values[0][j] = 0.0;
            }
            System.out.print(String.format("%5.2f  %5.7f", x, allValues[0]));
            for (j = 1; j < n; ++j) {
                System.out.print(String.format("  %5.7f", allValues[j]));
            }
            System.out.println();
        }
    }

    static void testSmoothSplines() {
        double[] xi = new double[]{0.0, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 1.0};
        double[] fi = new double[]{0.420650268, 0.869057123, 0.243074468, 0.352583416, 0.869472216, 0.219531331, 0.663085387, 0.476098157, 0.781728422, 0.509583544, 0.570627762, 0.540800479, 0.233658831, 0.103976142, 0.527013717, 0.519541602, 0.935703005, 0.360399664, 0.237154223, 0.851028235, 0.231539401};
        double[] speed = new double[]{4.0, 4.0, 7.0, 7.0, 8.0, 9.0, 10.0, 10.0, 10.0, 11.0, 11.0, 12.0, 12.0, 12.0, 12.0, 13.0, 13.0, 13.0, 13.0, 14.0, 14.0, 14.0, 14.0, 15.0, 15.0, 15.0, 16.0, 16.0, 17.0, 17.0, 17.0, 18.0, 18.0, 18.0, 18.0, 19.0, 19.0, 19.0, 20.0, 20.0, 20.0, 20.0, 20.0, 22.0, 23.0, 24.0, 24.0, 24.0, 24.0, 25.0};
        double[] dist = new double[]{2.0, 10.0, 4.0, 22.0, 16.0, 10.0, 18.0, 26.0, 34.0, 17.0, 28.0, 14.0, 20.0, 24.0, 28.0, 26.0, 34.0, 34.0, 46.0, 26.0, 36.0, 60.0, 80.0, 20.0, 26.0, 54.0, 32.0, 40.0, 32.0, 40.0, 50.0, 42.0, 56.0, 76.0, 84.0, 36.0, 46.0, 68.0, 32.0, 48.0, 52.0, 56.0, 64.0, 66.0, 54.0, 70.0, 92.0, 93.0, 120.0, 85.0};
        double[] y18 = new double[]{1.0, 2.0, 3.0, 5.0, 4.0, 7.0, 6.0, 5.0, 4.0, 3.0, 4.0, 6.0, 8.0, 10.0, 10.0, 10.0, 10.0, 10.0};
        assert (xi.length == fi.length);
        assert (speed.length == dist.length);
        SmoothSplineResult result = SmoothSpline.fit(fi, xi, null, SmoothSplineCriterion.DF_MATCH, 1.0, 3.0);
        System.out.println(result);
        System.out.println(SmoothSpline.predict(result, 0.05, 0));
        System.out.println(SmoothSpline.predict(result, 0.9, 0));
        System.out.println(SmoothSpline.predict(result, 0.95, 0));
        System.out.println();
        result = SmoothSpline.fit(fi, xi, null, SmoothSplineCriterion.GCV, 1.0, 0.0);
        System.out.println(result);
        System.out.println(SmoothSpline.predict(result, 0.05, 0));
        System.out.println(SmoothSpline.predict(result, 0.9, 0));
        System.out.println(SmoothSpline.predict(result, 0.95, 0));
        System.out.println();
        result = SmoothSpline.fit(fi, xi, null, SmoothSplineCriterion.CV, 1.0, 0.0);
        System.out.println(result);
        System.out.println(SmoothSpline.predict(result, 0.05, 0));
        System.out.println(SmoothSpline.predict(result, 0.9, 0));
        System.out.println(SmoothSpline.predict(result, 0.95, 0));
        System.out.println();
        result = SmoothSpline.fit(speed, dist, null, SmoothSplineCriterion.GCV, 1.0, 0.0);
        System.out.println(result);
        result = SmoothSpline.fit(speed, dist, null, SmoothSplineCriterion.DF_MATCH, 1.0, 10.0);
        System.out.println(result);
        result = SmoothSpline.fit(y18, null, null, SmoothSplineCriterion.GCV, 1.0, 0.0);
        System.out.println(result);
    }
}

