/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.math.opt;

import jdistlib.math.MultivariableFunction;

public abstract class OptimizationConfig {
    public static final int defaultMaxNumFunctionCall = 50000;
    protected double[] initialGuess;
    protected double[] lowerBound;
    protected double[] upperBound;
    protected int maxNumFunctionCall = 50000;
    protected boolean isMinimize = true;
    protected MultivariableFunction objectiveFunction;

    public OptimizationConfig() {
    }

    public OptimizationConfig(double[] initGuess, double[] lo, double[] hi, MultivariableFunction fun) {
        this(initGuess, lo, hi, fun, 50000, true);
    }

    public OptimizationConfig(double[] initGuess, double[] lo, double[] hi, MultivariableFunction fun, int maxCall, boolean isMin) {
        this.setInitialGuess(initGuess);
        this.setLowerBound(lo);
        this.setUpperBound(hi);
        this.setObjectiveFunction(fun);
        this.setMaxNumFunctionCall(maxCall);
        this.setMinimize(isMin);
    }

    public double[] getInitialGuess() {
        return this.initialGuess;
    }

    public void setInitialGuess(double[] initialGuess) {
        this.initialGuess = initialGuess;
    }

    public double[] getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double[] lowerBound) {
        this.lowerBound = lowerBound;
    }

    public double[] getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double[] upperBound) {
        this.upperBound = upperBound;
    }

    public int getMaxNumFunctionCall() {
        return this.maxNumFunctionCall;
    }

    public void setMaxNumFunctionCall(int maxNumFunctionCall) {
        this.maxNumFunctionCall = maxNumFunctionCall;
    }

    public boolean isMinimize() {
        return this.isMinimize;
    }

    public void setMinimize(boolean isMinimize) {
        this.isMinimize = isMinimize;
    }

    public MultivariableFunction getObjectiveFunction() {
        return this.objectiveFunction;
    }

    public void setObjectiveFunction(MultivariableFunction objectiveFunction) {
        this.objectiveFunction = objectiveFunction;
    }
}

