/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.util.ArrayUtil;

public class NDArrayIndex {
    private int[] indices = new int[1];
    private boolean isInterval = false;

    public NDArrayIndex(int ... indices) {
        this.indices = indices;
    }

    public int end() {
        if (this.indices != null && this.indices.length > 0) {
            return this.indices[this.indices.length - 1];
        }
        return 0;
    }

    public int offset() {
        if (this.indices.length < 1) {
            return 0;
        }
        return this.indices[0];
    }

    public int length() {
        if (this.indices.length < 1) {
            return 0;
        }
        return this.indices[this.indices.length - 1] - this.indices[0];
    }

    public int[] indices() {
        return this.indices;
    }

    public void reverse() {
        ArrayUtil.reverse(this.indices);
    }

    public String toString() {
        return "NDArrayIndex{indices=" + Arrays.toString(this.indices) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NDArrayIndex)) {
            return false;
        }
        NDArrayIndex that = (NDArrayIndex)o;
        return Arrays.equals(this.indices, that.indices);
    }

    public int hashCode() {
        return Arrays.hashCode(this.indices);
    }

    public static NDArrayIndex[] create(INDArray index) {
        if (index.isMatrix()) {
            NDArrayIndex[] ret = new NDArrayIndex[index.rows()];
            for (int i = 0; i < index.rows(); ++i) {
                NDArrayIndex idx;
                INDArray row = index.getRow(i);
                int[] nums = new int[index.getRow(i).columns()];
                for (int j = 0; j < row.columns(); ++j) {
                    nums[j] = (int)row.getFloat(j);
                }
                ret[i] = idx = new NDArrayIndex(nums);
            }
            return ret;
        }
        if (index.isVector()) {
            int[] indices = ArrayUtil.toInts(index);
            return new NDArrayIndex[]{new NDArrayIndex(indices)};
        }
        throw new IllegalArgumentException("Passed in ndarray must be a matrix or a vector");
    }

    public boolean isInterval() {
        return this.isInterval;
    }

    public void setInterval(boolean isInterval) {
        this.isInterval = isInterval;
    }

    public static NDArrayIndex concat(NDArrayIndex ... indexes) {
        int[][] indices = new int[indexes.length][];
        for (int i = 0; i < indexes.length; ++i) {
            indices[i] = indexes[i].indices();
        }
        return new NDArrayIndex(Ints.concat((int[][])indices));
    }

    public static NDArrayIndex interval(int begin, int end) {
        return NDArrayIndex.interval(begin, end, false);
    }

    public static NDArrayIndex interval(int begin, int end, boolean inclusive) {
        assert (begin <= end) : "Beginning index in range must be less than end";
        NDArrayIndex ret = new NDArrayIndex(ArrayUtil.range(begin, inclusive ? end + 1 : end));
        ret.isInterval = true;
        return ret;
    }
}

