/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.gui.matrix;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jdmp.core.variable.Variable;
import org.jdmp.gui.matrix.MatrixListTableModel;
import org.jdmp.gui.matrix.MatrixTableCellRenderer;
import org.ujmp.core.Matrix;
import org.ujmp.core.interfaces.HasToolTip;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.frame.MatrixFrame;

public class MatrixListPanel
extends JPanel
implements MouseListener,
ListSelectionListener,
TableModelListener {
    private static final long serialVersionUID = -6599031713168986357L;
    private JTable jTable = null;
    private Variable variable = null;
    private MatrixListTableModel dataModel = null;
    private boolean scroll = true;

    public MatrixListPanel(Variable variable) {
        this.variable = variable;
        this.setLayout(new GridBagLayout());
        this.dataModel = new MatrixListTableModel(variable);
        this.setBorder(BorderFactory.createTitledBorder("Matrices (" + this.dataModel.getRowCount() + ")"));
        this.jTable = new JTable(this.dataModel){
            private static final long serialVersionUID = -1349144990029853301L;

            @Override
            public String getToolTipText(MouseEvent event) {
                Object o;
                int row = this.rowAtPoint(event.getPoint());
                if (row < MatrixListPanel.this.jTable.getRowCount() && (o = MatrixListPanel.this.jTable.getValueAt(row, 0)) instanceof HasToolTip) {
                    return ((HasToolTip)o).getToolTipText();
                }
                return null;
            }
        };
        this.jTable.addMouseListener(this);
        this.addMouseListener(this);
        this.jTable.setAutoResizeMode(4);
        this.dataModel.addTableModelListener(this);
        int rowHeight = UIManager.getInt("Table.rowHeight");
        if (rowHeight < 1) {
            rowHeight = 32;
        }
        this.jTable.setRowHeight(rowHeight);
        this.jTable.getColumnModel().getColumn(0).setMinWidth(45);
        this.jTable.getColumnModel().getColumn(0).setPreferredWidth(45);
        this.jTable.setDefaultRenderer(MatrixGUIObject.class, new MatrixTableCellRenderer());
        this.add((Component)this.jTable.getTableHeader(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this.jTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.registerKeyboardActions();
    }

    private void registerKeyboardActions() {
    }

    private void registerKeyboardAction(Action a) {
        KeyStroke keyStroke = (KeyStroke)a.getValue("AcceleratorKey");
        this.getActionMap().put(a.getValue("Name"), a);
        this.getInputMap(1).put(keyStroke, a.getValue("Name"));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            if (e.getSource() == this) {
                this.mouseClickedOnObjectList(e);
            } else {
                this.mouseClickedOnObject(e);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void mouseClickedOnObjectList(MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void mouseClickedOnObject(MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                if (e.getClickCount() != 2) break;
                int row = this.jTable.rowAtPoint(e.getPoint());
                this.jTable.setRowSelectionInterval(row, row);
                MatrixGUIObject m = (MatrixGUIObject)((Matrix)this.dataModel.getValueAt(this.jTable.getSelectedRow(), 0)).getGUIObject();
                MatrixFrame mf = new MatrixFrame(m);
                mf.setVisible(true);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                int row = this.jTable.rowAtPoint(e.getPoint());
                this.jTable.setRowSelectionInterval(row, row);
                MatrixGUIObject m = (MatrixGUIObject)((Object)((Matrix)this.dataModel.getValueAt(this.jTable.getSelectedRow(), 0)));
                JPopupMenu popup = new JPopupMenu();
                if (this.variable instanceof Variable) {
                    // empty if block
                }
                popup.show(this.jTable, e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.scroll = false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.scroll = true;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        try {
            MatrixGUIObject m = null;
            int row = this.jTable.getSelectedRow();
            if (row >= 0 && row < this.dataModel.getRowCount()) {
                m = (MatrixGUIObject)this.dataModel.getValueAt(row, 0);
            }
            if (e.getKeyChar() != '\u007f' && e.getKeyChar() != '\u0003') {
                System.out.println("char entered in MatrixListPanel: " + e.getKeyChar());
            }
            if (this.variable instanceof Variable && m != null) {
                e.getKeyChar();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int maxRow;
        int minRow;
        if (this.scroll && !e.getValueIsAdjusting() && (minRow = this.jTable.getSelectionModel().getMinSelectionIndex()) == (maxRow = this.jTable.getSelectionModel().getMaxSelectionIndex())) {
            JViewport viewport = (JViewport)this.jTable.getParent();
            Rectangle rect = this.jTable.getCellRect(minRow, 0, true);
            Rectangle viewRect = viewport.getViewRect();
            rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
            int centerX = (viewRect.width - rect.width) / 2;
            int centerY = (viewRect.height - rect.height) / 2;
            if (rect.x < centerX) {
                centerX = -centerX;
            }
            if (rect.y < centerY) {
                centerY = -centerY;
            }
            rect.translate(centerX, centerY);
            viewport.scrollRectToVisible(rect);
        }
        this.fireValueChanged(e);
    }

    public void fireValueChanged(ListSelectionEvent e) {
        for (Object o : this.listenerList.getListenerList()) {
            if (!(o instanceof ListSelectionListener)) continue;
            ((ListSelectionListener)o).valueChanged(e);
        }
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.listenerList.add(ListSelectionListener.class, l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.listenerList.add(ListSelectionListener.class, l);
    }

    public MatrixGUIObject getSelectedMatrix() {
        ListSelectionModel lsm = this.jTable.getSelectionModel();
        if (lsm.isSelectionEmpty() || lsm.getValueIsAdjusting()) {
            return null;
        }
        int selectedRow = lsm.getMinSelectionIndex();
        return (MatrixGUIObject)this.jTable.getModel().getValueAt(selectedRow, 1);
    }

    public void updateTitle() {
        this.getBorder().setTitle("Matrices (" + this.jTable.getRowCount() + ")");
        this.repaint(1000L);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateTitle();
    }

    @Override
    public TitledBorder getBorder() {
        return (TitledBorder)super.getBorder();
    }
}

