/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.gui.dataset.actions;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.jdmp.core.dataset.HasDataSetMap;
import org.jdmp.core.dataset.ListDataSet;
import org.ujmp.core.filematrix.FileFormat;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.gui.actions.AbstractObjectAction;

public class LinkDataSetToFileAction
extends AbstractObjectAction {
    private static final long serialVersionUID = 5742073625833450916L;

    public LinkDataSetToFileAction(JComponent c, GUIObject m) {
        super(c, m);
        this.putValue("Name", "to File...");
        this.putValue("ShortDescription", "link a dataset to a file on disk");
        this.putValue("MnemonicKey", 70);
    }

    @Override
    public Object call() {
        try {
            File file = null;
            FileFormat fileFormat = null;
            JFileChooser chooser = new JFileChooser();
            for (FileFormat f : FileFormat.values()) {
                chooser.addChoosableFileFilter(f.getFileFilter());
            }
            chooser.setFileFilter(FileFormat.CSV.getFileFilter());
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setDialogTitle("Link");
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                file = chooser.getSelectedFile();
                FileFilter filter = chooser.getFileFilter();
                for (FileFormat f : FileFormat.values()) {
                    if (!filter.equals(f.getFileFilter())) continue;
                    fileFormat = f;
                }
            }
            if (file == null) {
                return null;
            }
            ListDataSet ds = ListDataSet.Factory.linkToFile(fileFormat, file, new Object[0]);
            if (this.getCoreObject() instanceof HasDataSetMap) {
                try {
                    ((HasDataSetMap)((Object)this.getCoreObject())).getDataSetMap().add(ds);
                }
                catch (Exception e) {
                    ds.showGUI();
                }
            } else {
                ds.showGUI();
            }
            return ds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

