/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.gui.dataset.actions;

import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.jdmp.core.dataset.HasDataSetMap;
import org.jdmp.core.dataset.ListDataSet;
import org.ujmp.core.filematrix.FileFormat;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.gui.actions.AbstractObjectAction;

public class ImportDataSetFromURLAction
extends AbstractObjectAction {
    private static final long serialVersionUID = 116250003084148340L;

    public ImportDataSetFromURLAction(JComponent c, GUIObject i) {
        super(c, i);
        this.putValue("Name", "from URL...");
        this.putValue("ShortDescription", "Import a DataSet from an URL on the web");
        this.putValue("MnemonicKey", 85);
    }

    @Override
    public Object call() {
        try {
            URL url = null;
            while (url == null) {
                String s = JOptionPane.showInputDialog("Enter URL:", (Object)"http://");
                url = new URL(s);
            }
            FileFormat fileFormat = FileFormat.values()[JOptionPane.showOptionDialog(this.getComponent(), "Select format", "Import DataSet", 0, 3, null, (Object[])FileFormat.values(), (Object)FileFormat.CSV)];
            ListDataSet ds = ListDataSet.Factory.importFromURL(fileFormat, url, new Object[0]);
            if (this.getCoreObject() instanceof HasDataSetMap) {
                try {
                    ((HasDataSetMap)((Object)this.getCoreObject())).getDataSetMap().add(ds);
                }
                catch (Exception e) {
                    ds.showGUI();
                }
            } else {
                ds.showGUI();
            }
            return ds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

