/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.sample;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jdmp.core.dataset.DataSet;
import org.jdmp.core.sample.AbstractSample;
import org.jdmp.core.sample.Sample;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;

public class MatrixSample
extends AbstractSample {
    private static final long serialVersionUID = 8749986739854189724L;
    private final DataSet dataSet;
    private final int index;
    private final Map<String, Matrix> map = new HashMap<String, Matrix>();

    public MatrixSample(DataSet dataSet, int index) {
        this.dataSet = dataSet;
        this.index = index;
    }

    @Override
    public synchronized Matrix get(Object key) {
        Matrix m = this.map.get(key);
        if (m == null) {
            Matrix all = this.dataSet.getMatrix(key);
            if (all == null) {
                return null;
            }
            if (all.getRowCount() < (long)this.dataSet.size()) {
                return null;
            }
            m = all.selectRows(Calculation.Ret.LINK, this.index);
            this.map.put(String.valueOf(key), m);
        }
        return m;
    }

    @Override
    public Set<String> keySet() {
        return this.dataSet.keySet();
    }

    @Override
    public Sample clone() {
        throw new RuntimeException("not suppored");
    }

    @Override
    protected void clearMap() {
        throw new RuntimeException("not suppored");
    }

    @Override
    protected Matrix removeFromMap(Object key) {
        throw new RuntimeException("not suppored");
    }

    @Override
    protected Matrix putIntoMap(String key, Object value) {
        Matrix mv = value instanceof Matrix ? (Matrix)value : Matrix.Factory.linkToValue(value);
        Matrix m = this.dataSet.getMatrix(key);
        if (m == null || m.isEmpty()) {
            m = Matrix.Factory.zeros((long)this.dataSet.size(), mv.getColumnCount());
            this.dataSet.setMatrix(key, m);
        }
        m.setContent(Calculation.Ret.ORIG, mv, this.index, 0L);
        return null;
    }

    @Override
    public int size() {
        return this.dataSet.size();
    }
}

