/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.hashing;

import java.util.ArrayList;
import java.util.List;
import org.jdmp.core.algorithm.hashing.AbstractHashing;
import org.jdmp.core.algorithm.hashing.HashRandomProjection;
import org.jdmp.core.dataset.ListDataSet;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.MathUtil;

public class MinHashing
extends AbstractHashing {
    private static final long serialVersionUID = -6746930977676653097L;
    private final int numberOfBits;
    private final int numberOfPermutations;
    private final HashRandomProjection hashRandomProjections;
    private final List<List<Integer>> permutations = new ArrayList<List<Integer>>();

    public MinHashing(int numberOfBits, int numberOfPermutations) {
        this.hashRandomProjections = new HashRandomProjection(numberOfBits);
        this.numberOfBits = numberOfBits;
        this.numberOfPermutations = numberOfPermutations;
    }

    @Override
    public void reset() {
        this.hashRandomProjections.clear();
        this.permutations.clear();
    }

    @Override
    public void train(ListDataSet dataSet) {
        this.hashRandomProjections.train(dataSet);
        for (int i = 0; i < this.numberOfPermutations; ++i) {
            this.permutations.add(MathUtil.randPermInt(0, this.numberOfBits));
        }
    }

    @Override
    public Matrix hash(Matrix input) {
        DenseMatrix result = Matrix.Factory.zeros(1L, (long)this.numberOfPermutations);
        Matrix hash = this.hashRandomProjections.hash(input);
        block0: for (int i = 0; i < this.numberOfPermutations; ++i) {
            for (int j = 0; j < this.numberOfBits; ++j) {
                int pos = this.permutations.get(i).get(j);
                if (!hash.getAsBoolean(0L, pos)) continue;
                result.setAsDouble(j, 0L, i);
                continue block0;
            }
        }
        return result;
    }
}

