/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.estimator;

import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.algorithm.estimator.AbstractDensityEstimator;

public class GeneralDensityEstimator
extends AbstractDensityEstimator {
    private final Map<Object, Double> counts = new HashMap<Object, Double>(2);
    private double sumOfCounts;

    @Override
    public void addValue(Object value, double weight) {
        Double count = this.counts.get(value);
        if (count == null) {
            count = 0.0;
        }
        this.counts.put(value, count + weight);
        this.sumOfCounts += weight;
    }

    @Override
    public void addValue(double value, double weight) {
        this.addValue((Object)value, weight);
    }

    @Override
    public double getProbability(double value) {
        return this.getProbability((Object)value);
    }

    @Override
    public double getProbability(Object value) {
        if (this.sumOfCounts == 0.0) {
            return 1.0E-15;
        }
        Double count = this.counts.get(value);
        if (count == null || count == 0.0) {
            return 1.0E-15;
        }
        double probability = count / this.sumOfCounts;
        return probability < 1.0E-15 ? 1.0E-15 : probability;
    }

    @Override
    public void removeValue(Object value, double weight) {
        Double count = this.counts.get(value);
        if (count != null) {
            count = count - weight;
            this.counts.put(value, count);
            this.sumOfCounts -= weight;
        }
    }

    @Override
    public void removeValue(double value, double weight) {
        this.removeValue((Object)value, weight);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GeneralDensityEstimator");
        for (Object key : this.counts.keySet()) {
            sb.append(" " + key + ":" + this.counts.get(key));
        }
        return sb.toString();
    }
}

