/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.estimator;

import org.jdmp.core.algorithm.estimator.AbstractDensityEstimator;
import org.ujmp.core.util.MathUtil;

public class GaussianDensityEstimator
extends AbstractDensityEstimator {
    private double count = 0.0;
    private double runningMean = 0.0;
    private double runningSum = 0.0;
    private double sigma = 1.0;
    private boolean isSigmaUpToDate = false;

    public double getVariance() {
        if (this.count == 0.0 || this.runningSum == 0.0) {
            return 1.0;
        }
        return this.runningSum / (this.count - 1.0);
    }

    public double getSigma() {
        if (!this.isSigmaUpToDate) {
            this.sigma = Math.sqrt(this.getVariance());
            this.isSigmaUpToDate = true;
        }
        return this.sigma;
    }

    @Override
    public void addValue(double x, double weight) {
        this.isSigmaUpToDate = false;
        this.count += weight;
        if (Math.abs(this.count - weight) < 1.0E-12) {
            this.runningMean = x;
        } else {
            double newMean = this.runningMean + (weight * x - this.runningMean) / this.count;
            this.runningSum += (weight * x - this.runningMean) * (weight * x - newMean);
            this.runningMean = newMean;
        }
    }

    @Override
    public void removeValue(double x, double weight) {
        if (weight == 1.0) {
            this.removeValue(x);
        } else {
            this.isSigmaUpToDate = false;
            if (this.count == 0.0) {
                throw new RuntimeException("density estimator is already empty");
            }
            if (Math.abs(this.count - weight) < 1.0E-12) {
                this.count = 0.0;
                this.runningMean = 0.0;
                this.runningSum = 0.0;
            } else {
                double oldMean = (this.count * this.runningMean - weight * x) / (this.count - weight);
                this.runningSum -= (weight * x - this.runningMean) * (weight * x - oldMean);
                this.runningMean = oldMean;
                this.count -= weight;
            }
        }
    }

    @Override
    public double getProbability(double value) {
        double probability = MathUtil.gauss(this.runningMean, this.getSigma(), value);
        return probability < 1.0E-15 ? 1.0E-15 : probability;
    }

    public double getMu() {
        return this.runningMean;
    }

    public String toString() {
        return "mu:" + this.getMu() + ",sigma:" + this.getSigma();
    }
}

