/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.basic;

import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.MathUtil;

public class FMeasure
extends AbstractAlgorithm {
    private static final long serialVersionUID = 280845197953557673L;
    public static final String DESCRIPTION = "target = fmeasure(source)";

    public FMeasure(Variable ... variables) {
        this.setDescription(DESCRIPTION);
        this.addVariableKey("Source");
        this.addVariableKey("Target");
        this.setEdgeLabel("Source", "Source");
        this.setEdgeLabel("Target", "Target");
        this.setEdgeDirection("Source", Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection("Target", Algorithm.EdgeDirection.Outgoing);
        this.setVariables(variables);
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> input) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Matrix source = MathUtil.getMatrix(input.get("Source"));
        DenseMatrix target = Matrix.Factory.zeros(source.getRowCount(), 1L);
        long cols = source.getColumnCount();
        long rows = source.getRowCount();
        int k = 0;
        while ((long)k < rows) {
            int tp = 0;
            int tn = 0;
            int fn = 0;
            int fp = 0;
            int r = 0;
            while ((long)r < rows) {
                int c = 0;
                while ((long)c < cols) {
                    boolean predicted;
                    int count = source.getAsInt(r, c);
                    boolean expected = r == k;
                    boolean bl = predicted = c == k;
                    if (expected && predicted) {
                        tp += count;
                    } else if (expected && !predicted) {
                        fn += count;
                    } else if (!expected && predicted) {
                        fp += count;
                    } else {
                        tn += count;
                    }
                    ++c;
                }
                ++r;
            }
            target.setAsDouble(MathUtil.f1Measure(tp, fp, fn), k, 0L);
            ++k;
        }
        result.put("Target", target);
        return result;
    }
}

