/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.jayes.util.triangulation;

import bayesnet.jayes.util.Graph;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class QuotientGraph {
    private final Graph graph;
    private final boolean[] isElement;
    private final Set<Integer>[] neighborCache;

    public QuotientGraph(Graph graph) {
        this.graph = graph.clone();
        this.isElement = new boolean[graph.numberOfVertices()];
        this.neighborCache = new Set[graph.numberOfVertices()];
    }

    public Set<Integer> getNeighbors(int variable) {
        if (this.neighborCache[variable] != null) {
            return this.neighborCache[variable];
        }
        LinkedHashSet<Integer> neighbors = new LinkedHashSet<Integer>();
        if (!this.isElement[variable]) {
            for (int neighbor : this.graph.getNeighbors(variable)) {
                if (this.isElement[neighbor]) {
                    neighbors.addAll(this.graph.getNeighbors(neighbor));
                    continue;
                }
                neighbors.add(neighbor);
            }
            neighbors.remove(variable);
        }
        this.neighborCache[variable] = neighbors;
        return this.neighborCache[variable];
    }

    public void eliminate(int variable) {
        if (this.isElement[variable]) {
            throw new IllegalArgumentException("variable already eliminated");
        }
        Set<Integer> neighbors = this.getNeighbors(variable);
        this.neighborCache[variable] = null;
        for (Integer neighbor : neighbors) {
            this.neighborCache[neighbor.intValue()] = null;
        }
        for (int elementNeighbor : new ArrayList<Integer>(this.graph.getNeighbors(variable))) {
            if (!this.isElement[elementNeighbor]) continue;
            this.merge(this.graph, variable, elementNeighbor);
        }
        this.isElement[variable] = true;
    }

    private void merge(Graph graph, int v1, int v2) {
        for (int n : graph.getNeighbors(v2)) {
            if (v1 == n) continue;
            graph.addEdge(v1, n);
        }
        this.virtualRemoveNode(graph, v2);
    }

    private void virtualRemoveNode(Graph graph, int node) {
        graph.removeIncidentEdges(node);
    }
}

