/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.jayes.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Graph
implements Cloneable {
    private final ArrayList<Integer>[] adjacency;

    public int numberOfVertices() {
        return this.adjacency.length;
    }

    public Graph(int nodes) {
        this.adjacency = new ArrayList[nodes];
        for (int i = 0; i < nodes; ++i) {
            this.adjacency[i] = new ArrayList();
        }
    }

    public void addEdge(int v1, int v2) {
        this.addOrdered(this.adjacency[v1], v2);
        this.addOrdered(this.adjacency[v2], v1);
    }

    private void addOrdered(List<Integer> list, int v2) {
        int i = Collections.binarySearch(list, v2);
        if (i < 0) {
            list.add(-i - 1, v2);
        }
    }

    public void removeEdge(int v1, int v2) {
        this.removeOrdered(this.adjacency[v1], v2);
        this.removeOrdered(this.adjacency[v2], v1);
    }

    private void removeOrdered(List<Integer> list, int v2) {
        int i = Collections.binarySearch(list, v2);
        if (i >= 0) {
            list.remove(i);
        }
    }

    public void removeIncidentEdges(int v) {
        for (int n : this.adjacency[v]) {
            this.removeOrdered(this.adjacency[n], v);
        }
        this.adjacency[v].clear();
    }

    public List<Integer> getNeighbors(int var) {
        return this.adjacency[var];
    }

    public Graph clone() {
        try {
            Graph clone = (Graph)super.clone();
            for (int i = 0; i < this.adjacency.length; ++i) {
                clone.adjacency[i] = (ArrayList)this.adjacency[i].clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

