/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.jayes.util;

import bayesnet.jayes.BayesNode;
import bayesnet.jayes.factor.AbstractFactor;
import bayesnet.jayes.factor.Cut;
import java.util.Map;

public final class BayesNodeUtil {
    private BayesNodeUtil() {
    }

    public static double[] getSubCpt(BayesNode node, Map<BayesNode, String> evidence) {
        AbstractFactor factor = node.getFactor();
        for (BayesNode p : node.getParents()) {
            if (evidence.containsKey(p)) {
                factor.select(p.getId(), p.getOutcomeIndex(evidence.get(p)));
                continue;
            }
            throw new IllegalArgumentException("evidence does not cover all parents of node");
        }
        Cut cut = new Cut(factor);
        cut.initialize();
        if (cut.getSubCut() != null || cut.getStepSize() != 1 || cut.getEnd() - cut.getStart() != node.getOutcomeCount()) {
            throw new AssertionError((Object)"Unexpected factor structure: node's dimension is not the lowest");
        }
        double[] subCpt = new double[node.getOutcomeCount()];
        for (int i = 0; i < node.getOutcomeCount(); ++i) {
            subCpt[i] = factor.getValue(cut.getStart() + i * cut.getStepSize());
        }
        factor.resetSelections();
        return subCpt;
    }
}

