/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.jayes.transformation;

import bayesnet.jayes.BayesNet;
import bayesnet.jayes.BayesNode;
import bayesnet.jayes.factor.AbstractFactor;
import bayesnet.jayes.factor.DenseFactor;
import bayesnet.jayes.factor.arraywrapper.DoubleArrayWrapper;
import bayesnet.jayes.transformation.IDecompositionStrategy;
import bayesnet.jayes.transformation.util.ArrayFlatten;
import bayesnet.jayes.transformation.util.CanonicalDoubleArrayManager;
import bayesnet.jayes.transformation.util.DecompositionFailedException;
import bayesnet.jayes.util.MathUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractDecomposition
implements IDecompositionStrategy {
    @Override
    public final void decompose(BayesNet net, BayesNode node) throws DecompositionFailedException {
        if (!net.getNodes().contains(node)) {
            throw new IllegalArgumentException("Node " + node + " is not part of the bayesnet " + net.getName());
        }
        AbstractFactor f = node.getFactor();
        if (f.getDimensions().length == 1) {
            throw new DecompositionFailedException("Node " + node + " has no parents, impossible to decompose");
        }
        f = this.reorderFactor(f);
        int[] dimensions = f.getDimensions();
        List<double[]> vectors = ArrayFlatten.unflatten(f.getValues().toDoubleArray(), dimensions[dimensions.length - 1]);
        List<double[]> basis = this.getBasis(f, vectors);
        double[] latentProb = this.getLatentProbabilities(vectors, basis);
        if (f == node.getFactor()) {
            this.createLatentNodeInOriginalOrder(net, node, basis, latentProb);
        } else {
            this.createLatentNodeReordered(net, node, f, basis, latentProb);
        }
    }

    private AbstractFactor reorderFactor(AbstractFactor f) {
        int min;
        int[] dimensions = f.getDimensions();
        int minIndex = Ints.lastIndexOf((int[])dimensions, (int)(min = Ints.min((int[])dimensions)));
        if (minIndex == dimensions.length - 1) {
            return f;
        }
        int[] nDim = this.rotateRight(dimensions, dimensions.length - 1 - minIndex);
        int[] nIDs = this.rotateRight(f.getDimensionIDs(), dimensions.length - 1 - minIndex);
        DenseFactor f2 = new DenseFactor();
        f2.setDimensionIDs(nIDs);
        f2.setDimensions(nDim);
        ((AbstractFactor)f2).fill(1.0);
        f2.multiplyCompatible(f);
        return f2;
    }

    protected abstract List<double[]> getBasis(AbstractFactor var1, List<double[]> var2) throws DecompositionFailedException;

    private double[] getLatentProbabilities(List<double[]> vectors, List<double[]> best) throws DecompositionFailedException {
        CanonicalDoubleArrayManager canon = new CanonicalDoubleArrayManager();
        best = Lists.transform(best, (Function)canon);
        vectors = Lists.transform(vectors, (Function)canon);
        List<double[]> newVectors = this.toLatentSpace(vectors, (List<double[]>)best);
        return ArrayFlatten.flatten((double[][])newVectors.toArray((T[])new double[0][]));
    }

    private List<double[]> toLatentSpace(List<double[]> vectors, List<double[]> best) throws DecompositionFailedException {
        ArrayList<double[]> latent = new ArrayList<double[]>();
        for (double[] v : vectors) {
            latent.add(this.toLatentSpace(v, best));
        }
        return latent;
    }

    protected abstract double[] toLatentSpace(double[] var1, List<double[]> var2) throws DecompositionFailedException;

    private void createLatentNodeInOriginalOrder(BayesNet net, BayesNode node, List<double[]> basis, double[] latentProb) {
        BayesNode newNode = net.createNode("latent-" + node.getName());
        this.addOutcomes(newNode, basis.size());
        newNode.setParents(node.getParents());
        newNode.setProbabilities(latentProb);
        node.setParents(Arrays.asList(newNode));
        node.setProbabilities(ArrayFlatten.flatten((double[][])basis.toArray((T[])new double[0][])));
    }

    private void createLatentNodeReordered(BayesNet net, BayesNode node, AbstractFactor f, List<double[]> basis, double[] latentProb) {
        BayesNode newNode = net.createNode("latent-" + node.getName());
        this.addOutcomes(newNode, basis.size());
        int[] dimensions = f.getDimensions();
        BayesNode parentNode = net.getNode(f.getDimensionIDs()[dimensions.length - 1]);
        newNode.setParents(Arrays.asList(parentNode));
        newNode.setProbabilities(ArrayFlatten.flatten((double[][])this.transpose(basis).toArray((T[])new double[0][])));
        ArrayList<BayesNode> parents = new ArrayList<BayesNode>(node.getParents());
        int index = parents.indexOf(parentNode);
        parents.remove(parentNode);
        parents.add(index, newNode);
        node.setParents(parents);
        double[] nodeProbs = this.undoReordering(latentProb, node.getFactor(), f, newNode.getId());
        node.setProbabilities(nodeProbs);
    }

    private void addOutcomes(BayesNode newNode, int d) {
        for (int i = 0; i < d; ++i) {
            newNode.addOutcome("outcome" + i);
        }
    }

    private double[] undoReordering(double[] latentProb, AbstractFactor originalFactor, AbstractFactor newFactor, int originalId) {
        AbstractFactor o2 = originalFactor.clone();
        AbstractFactor n2 = newFactor.clone();
        n2.getDimensionIDs()[n2.getDimensionIDs().length - 1] = originalId;
        int oInd = Ints.indexOf((int[])o2.getDimensionIDs(), (int)originalId);
        n2.getDimensions()[n2.getDimensions().length - 1] = o2.getDimensions()[oInd];
        n2.setValues(new DoubleArrayWrapper(latentProb));
        o2.setValues(new DoubleArrayWrapper(new double[MathUtils.product(o2.getDimensions())]));
        o2.fill(1.0);
        o2.multiplyCompatible(n2);
        return o2.getValues().toDoubleArray();
    }

    protected final List<double[]> transpose(List<double[]> best) {
        int i;
        ArrayList<double[]> result = new ArrayList<double[]>();
        for (i = 0; i < best.get(0).length; ++i) {
            result.add(new double[best.size()]);
        }
        for (i = 0; i < best.size(); ++i) {
            double[] arr = best.get(i);
            for (int j = 0; j < arr.length; ++j) {
                ((double[])result.get((int)j))[i] = arr[j];
            }
        }
        return result;
    }

    private int[] rotateRight(int[] array, int amount) {
        int[] result = new int[array.length];
        System.arraycopy(array, 0, result, amount, array.length - amount);
        System.arraycopy(array, array.length - amount, result, 0, amount);
        return result;
    }
}

