/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.jayes.io.xdsl;

import bayesnet.jayes.BayesNet;
import bayesnet.jayes.BayesNode;
import bayesnet.jayes.io.IBayesNetWriter;
import bayesnet.jayes.io.util.XMLUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class XDSLWriter
implements IBayesNetWriter {
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
    private static final String COMMENT = "<!--\n\t Bayesian Network in XDSL format \n-->\n";
    private final Writer out;

    public XDSLWriter(OutputStream out) {
        this.out = new OutputStreamWriter(out);
    }

    @Override
    public void write(BayesNet net) throws IOException {
        StringBuilder bldr = new StringBuilder();
        bldr.append(XML_HEADER);
        bldr.append(COMMENT);
        int offset = bldr.length();
        this.getVariableDefs(bldr, net);
        this.getGenieExtensions(bldr, net);
        XMLUtil.surround(offset, bldr, "smile", "version", "1.0", "id", XMLUtil.escape(net.getName()), "numsamples", "1000");
        this.out.write(bldr.toString());
        this.out.flush();
    }

    private void getGenieExtensions(StringBuilder bldr, BayesNet net) {
        int offset = bldr.length();
        for (BayesNode node : net.getNodes()) {
            int nodeOffset = bldr.length();
            bldr.append(XMLUtil.escape(node.getName()));
            XMLUtil.surround(nodeOffset, bldr, "name", new String[0]);
            bldr.append('\n');
            int posOffset = bldr.length();
            bldr.append("0 0 100 100");
            XMLUtil.surround(posOffset, bldr, "position", new String[0]);
            bldr.append('\n');
            XMLUtil.emptyTag(bldr, "font", "color", "000000", "name", "Arial", "size", "8");
            bldr.append('\n');
            XMLUtil.emptyTag(bldr, "interior", "color", "e5f6f7");
            bldr.append('\n');
            XMLUtil.emptyTag(bldr, "outline", "color", "000000");
            bldr.append('\n');
            XMLUtil.surround(nodeOffset, bldr, "node", "id", XMLUtil.escape(node.getName()));
        }
        XMLUtil.surround(offset, bldr, "genie", "version", "1.0", "name", XMLUtil.escape(net.getName()));
        XMLUtil.surround(offset, bldr, "extensions", new String[0]);
    }

    private void getVariableDefs(StringBuilder bldr, BayesNet net) {
        int offset = bldr.length();
        for (BayesNode node : net.getNodes()) {
            int nodeOffset = bldr.length();
            this.encodeStates(bldr, node);
            this.encodeParents(bldr, node);
            bldr.append('\n');
            this.encodeProbabilities(bldr, node);
            XMLUtil.surround(nodeOffset, bldr, "cpt", "id", XMLUtil.escape(node.getName()));
            bldr.append('\n');
        }
        XMLUtil.surround(offset, bldr, "nodes", new String[0]);
    }

    private void encodeStates(StringBuilder bldr, BayesNode node) {
        for (String outcome : node.getOutcomes()) {
            XMLUtil.emptyTag(bldr, "state", "id", XMLUtil.escape(outcome));
            bldr.append('\n');
        }
    }

    private void encodeParents(StringBuilder bldr, BayesNode node) {
        int offset = bldr.length();
        for (BayesNode p : node.getParents()) {
            bldr.append(XMLUtil.escape(p.getName()));
            bldr.append(' ');
        }
        if (!node.getParents().isEmpty()) {
            bldr.deleteCharAt(bldr.length() - 1);
        }
        XMLUtil.surround(offset, bldr, "parents", new String[0]);
    }

    private void encodeProbabilities(StringBuilder bldr, BayesNode node) {
        if (node.getProbabilities().length == 0) {
            throw new IllegalArgumentException("Bayesian Network is broken: " + node.getName() + " has an empty conditional probability table");
        }
        int offset = bldr.length();
        for (double d : node.getProbabilities()) {
            bldr.append(d);
            bldr.append(' ');
        }
        bldr.deleteCharAt(bldr.length() - 1);
        XMLUtil.surround(offset, bldr, "probabilities", new String[0]);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

